/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.qa.service;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.gptas.api.qa.QAResultService;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class QAResultServiceImpl
implements QAResultService {
    private static final Long DEFAULT_ASSISTANT_ID = 100000L;
    private static final String BOS_GPTAS_QA = "bos-gptas-qa";

    public void saveQAResult(Map<String, String> params, Long assistantId, String resultType, Integer clientType, List<Object> knlId, List<String> fdbkType, String fdbkDesc, String chatSessionId) {
        String number;
        Map map;
        String question = params.get("question");
        String currentPageId = params.get("PAGE_ID");
        String formId = "";
        if (params.containsKey("api")) {
            formId = "API";
        } else {
            IFormView viewNoPlugin;
            if (StringUtils.isNotEmpty((String)currentPageId)) {
                viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(currentPageId);
                if (viewNoPlugin == null) {
                    viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(params.get("ROOT_PAGE_ID"));
                }
            } else {
                viewNoPlugin = SessionManager.getCurrent().getViewNoPlugin(params.get("ROOT_PAGE_ID"));
            }
            formId = this.getSourceByFormView(viewNoPlugin);
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_qaresult");
        DynamicObject data = new DynamicObject((DynamicObjectType)type);
        long id = ID.genLongId();
        String billNo = "QAR_" + id;
        if (params.containsKey("billno")) {
            BusinessDataWriter.delete((String)"bos_qaresult", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)params.get("billno"))});
            billNo = params.get("billno");
        }
        data.set("billno", (Object)billNo);
        data.set("billstatus", (Object)"A");
        data.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        data.set("userinput", (Object)QAResultServiceImpl.safeSubString(question, 2000));
        data.set("userinput_tag", (Object)question);
        data.set("answer", (Object)QAResultServiceImpl.safeSubString(params.get("answer"), 2000));
        data.set("answer_tag", (Object)params.get("answer"));
        data.set("currentpage", (Object)formId);
        if (resultType.length() == 1 && resultType.toUpperCase().matches("[A-F]")) {
            data.set("type", (Object)resultType);
        } else {
            data.set("type", (Object)"A");
        }
        data.set("clienttype", (Object)this.safeClientType(clientType).getType());
        if ("C".equals(resultType)) {
            data.set("fdbktype", (Object)(null == fdbkType ? "" : QAResultServiceImpl.safeSubString(String.join((CharSequence)",", fdbkType), 200)));
            data.set("fdbkdesc", (Object)(null == fdbkDesc ? "" : QAResultServiceImpl.safeSubString(fdbkDesc, 200)));
        }
        if (null == assistantId || 0L == assistantId) {
            assistantId = DEFAULT_ASSISTANT_ID;
        }
        data.set("assistant", (Object)assistantId);
        data.set("chatsessionid", (Object)chatSessionId);
        String action = params.get("action");
        if (StringUtils.isNotEmpty((String)action) && action.startsWith("QA_DISP") && !(map = BusinessDataReader.loadFromCache((String)"corpus_libs", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(number = action.substring(8)))})).isEmpty()) {
            DynamicObject row = (DynamicObject)map.values().iterator().next();
            data.set("grouptype_id", row.get("id"));
        }
        DynamicObjectCollection entryentity = data.getDynamicObjectCollection("entryentity");
        for (Object o : knlId) {
            DynamicObject row = entryentity.addNew();
            row.set("file_id", o);
        }
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new Object[]{data});
    }

    private static String safeSubString(String text, int maxLen) {
        if (StringUtils.isEmpty((String)text)) {
            return "";
        }
        if (text.length() > maxLen) {
            return text.substring(0, maxLen);
        }
        return text;
    }

    public String getSourceByFormView(IFormView viewNoPlugin) {
        String formId;
        if (viewNoPlugin == null) {
            return "";
        }
        String caption = viewNoPlugin.getFormShowParameter().getCaption();
        if (viewNoPlugin.getFormShowParameter() instanceof ListShowParameter) {
            formId = ((ListShowParameter)viewNoPlugin.getFormShowParameter()).getBillFormId();
            if (StringUtils.isNotEmpty((String)caption)) {
                caption = caption + ResManager.loadKDString((String)"\u5217\u8868", (String)"QAUtil_1", (String)BOS_GPTAS_QA, (Object[])new Object[0]);
            }
        } else {
            formId = viewNoPlugin.getFormShowParameter().getFormId();
        }
        if (StringUtils.isEmpty((String)caption) && StringUtils.isNotEmpty((String)formId)) {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)formId);
            caption = formConfig.getCaption().toString();
        }
        formId = caption + "(" + formId + ")";
        return formId;
    }

    private ClientType safeClientType(Integer clientType) {
        return ClientType.getClientType(clientType);
    }

    static enum ClientType {
        WEB(1),
        IDEA(2),
        VSCODE(3),
        SIDEBAR(4),
        OTHER(99);

        private final Integer type;

        private ClientType(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public static ClientType getClientType(Integer type) {
            switch (type) {
                case 1: {
                    return WEB;
                }
                case 2: {
                    return IDEA;
                }
                case 3: {
                    return VSCODE;
                }
                case 4: {
                    return SIDEBAR;
                }
            }
            return OTHER;
        }
    }
}

