/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.assistant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.utils.AssistantPreset;
import kd.bos.gptas.utils.IFrameUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;

public class AssistantCorpusFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BTN_UPLOAD_ICON = "uploadicon";
    private static final String PROP_ICON = "icon";
    private static final String PROP_STATUS = "status";

    public void registerListener(EventObject e) {
        Button uploadBtn = (Button)this.getControl(BTN_UPLOAD_ICON);
        uploadBtn.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.getModel().setValue(PROP_STATUS, (Object)"A");
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject evt) {
        DynamicObjectCollection promptObjs = QueryServiceHelper.query((String)"gai_prompt", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "like", (Object)"gptas%")});
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(promptObjs.size());
        if (CollectionUtils.isNotEmpty((Collection)promptObjs)) {
            for (DynamicObject promptObj : promptObjs) {
                ComboItem item = new ComboItem();
                Long promptId = promptObj.getLong("id");
                item.setValue(promptId.toString());
                String promptName = promptObj.getString("name");
                item.setCaption(new LocaleString(promptName));
                comboItems.add(item);
            }
        }
        ComboEdit promptCombo = (ComboEdit)this.getControl("prompt");
        promptCombo.setComboItems(comboItems);
        Long id = (Long)this.getModel().getDataEntity().getPkValue();
        String icon = (String)this.getModel().getValue(PROP_ICON);
        if (AssistantPreset.isPresetAssistant((Long)id).booleanValue() && StringUtils.isBlank((CharSequence)icon)) {
            String presetIconUrl = AssistantPreset.getIconUrl((Long)id);
            this.getModel().setValue(PROP_ICON, (Object)IFrameUtil.buildImageUrl((String)presetIconUrl, (boolean)false));
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save || source instanceof Submit) {
            Long id = (Long)this.getModel().getDataEntity().getPkValue();
            String icon = (String)this.getModel().getValue(PROP_ICON);
            String presetIconUrl = AssistantPreset.getIconUrl((Long)id);
            if (AssistantPreset.isPresetAssistant((Long)id).booleanValue() && StringUtils.isNotBlank((CharSequence)icon) && icon.startsWith(IFrameUtil.buildImageUrl((String)presetIconUrl, (boolean)true))) {
                this.getModel().setValue(PROP_ICON, (Object)"");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Save || source instanceof Submit) {
            this.getView().updateView();
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (null != urls && urls.length > 0) {
            String iconUrl = (String)urls[0];
            this.getModel().setValue(PROP_ICON, (Object)iconUrl);
        }
    }
}

