/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.assistant;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.gptas.utils.AssistantPreset;
import kd.bos.gptas.utils.IFrameUtil;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;

public class AssistantCorpusListPlugin
extends AbstractListPlugin {
    private static final String SYSTEM_TYPE = "bos-devportal-gptas";
    private static final String BTN_FEEDBACK = "feedback";
    private static final String BILL_QA_RESULT = "bos_qaresult";
    private static final String PROP_ASSISTANT = "assistant";
    private static final String PROP_STATUS = "status";
    private static final String PROP_ICON = "icon";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_FEEDBACK});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new AssistantListDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        if (lsp.isLookUp()) {
            List qFilters = e.getQFilters();
            qFilters.removeIf(filter -> PROP_STATUS.equals(filter.getProperty()));
        }
    }

    public void click(EventObject evt) {
        Button btn;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && BTN_FEEDBACK.equals(key = (btn = (Button)source).getKey())) {
            this.showFeedbackList();
        }
    }

    private void showFeedbackList() {
        Object clickDataPkId = ((ListView)this.getView()).getFocusRowPkId();
        ListSelectedRow clickRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        String name = clickRow.getName();
        ListShowParameter feedBackListParameter = ShowFormHelper.createShowListForm((String)BILL_QA_RESULT, (boolean)false, (int)0, (boolean)false);
        String caption = String.format(ResManager.loadKDString((String)"%s\u53cd\u9988\u5217\u8868", (String)"AssistantCorpusListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
        feedBackListParameter.setCaption(caption);
        feedBackListParameter.setMultiSelect(true);
        ListFilterParameter filterParameter = feedBackListParameter.getListFilterParameter();
        if (null == filterParameter) {
            filterParameter = new ListFilterParameter();
            feedBackListParameter.setListFilterParameter(filterParameter);
        }
        filterParameter.setFilter(new QFilter(PROP_ASSISTANT, "=", clickDataPkId));
        feedBackListParameter.setListFilterParameter(filterParameter);
        this.getView().showForm((FormShowParameter)feedBackListParameter);
    }

    static class AssistantListDataProvider
    extends ListDataProvider {
        AssistantListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dataCol = super.getData(start, limit);
            if (dataCol.isEmpty()) {
                return dataCol;
            }
            DataEntityPropertyCollection properties = this.getEntityType().getProperties();
            if (!properties.containsKey((Object)AssistantCorpusListPlugin.PROP_ICON)) {
                return dataCol;
            }
            for (DynamicObject data : dataCol) {
                Long id = (Long)data.getPkValue();
                String icon = (String)data.get(AssistantCorpusListPlugin.PROP_ICON);
                if (!AssistantPreset.isPresetAssistant((Long)id).booleanValue()) continue;
                String presetIconUrl = AssistantPreset.getIconUrl((Long)id);
                if (!StringUtils.isBlank((CharSequence)icon) && !StringUtils.equals((CharSequence)icon, (CharSequence)presetIconUrl)) continue;
                data.set(AssistantCorpusListPlugin.PROP_ICON, (Object)IFrameUtil.buildImageUrl((String)presetIconUrl, (boolean)false));
            }
            return dataCol;
        }
    }
}

