/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.kmbase.skill;

import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class SkillCorpusFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String BOS_DEVPORTAL_GPTAS = "bos-devportal-gptas";
    private static final String F7_API_SELECT = "bos_skillcorpus_api";
    private static final String PROP_API = "api";
    private static final String CALLBACK_API = "apiCloseCallBack";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{PROP_API});
    }

    public void afterBindData(EventObject e) {
        String sampleText = (String)this.getModel().getValue("inputcontent_tag");
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        if (!sampleText.trim().startsWith("```")) {
            md.setText("```\n" + sampleText);
        } else {
            md.setText(sampleText);
        }
        this.updateMarkdown();
    }

    public void click(EventObject evt) {
        TextEdit api;
        String key;
        Object source = evt.getSource();
        if (source instanceof TextEdit && PROP_API.equals(key = (api = (TextEdit)source).getKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(F7_API_SELECT);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            String selectedApiName = (String)this.getModel().getValue(PROP_API);
            parameter.setCustomParam("selectedApiName", (Object)selectedApiName);
            parameter.setCaption(ResManager.loadKDString((String)"API\u9009\u62e9", (String)"SkillCorpusFormPlugin_0", (String)BOS_DEVPORTAL_GPTAS, (Object[])new Object[0]));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_API));
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.updateValBeforeSave();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.updateMarkdown();
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (null == returnData) {
            return;
        }
        String apiName = (String)returnData;
        if (StringUtils.isBlank((CharSequence)apiName)) {
            return;
        }
        this.getModel().setValue(PROP_API, (Object)apiName);
    }

    private void updateMarkdown() {
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
            md.setModelType(Markdown.Preview);
        } else {
            String value = (String)this.getModel().getValue("status");
            if ("A".equals(value)) {
                md.setModelType(Markdown.Edit);
            } else {
                md.setModelType(Markdown.Preview);
            }
        }
    }

    private void updateValBeforeSave() {
        Markdown md = (Markdown)this.getView().getControl("markdownap");
        String sampleText = md.getText();
        if (sampleText.trim().startsWith("```")) {
            this.getModel().setValue("inputcontent_tag", (Object)sampleText.trim().substring(3));
        } else {
            this.getModel().setValue("inputcontent_tag", (Object)sampleText);
        }
    }
}

