/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.gptas.utils.AssistantPreset;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class AssistantCorpusUtils {
    private static final Long[] assistants = new Long[]{100000L, 100005L, 100002L, 100004L};

    public static List<Map<String, Object>> assistantForHomePage() {
        Map objectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_corpus_assistant", (String)"id,icon,number,name,des", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)assistants)});
        if (objectMap != null && !objectMap.isEmpty()) {
            ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(objectMap.size());
            for (DynamicObject value : objectMap.values()) {
                String iconUrl;
                HashMap<String, String> object = new HashMap<String, String>(4);
                if (StringUtils.isNotEmpty((CharSequence)value.getString("icon"))) {
                    String iconPath = AssistantCorpusUtils.checkKdcdc(UrlService.getImageFullUrl((String)value.getString("icon")));
                    object.put("icon", iconPath);
                }
                if (StringUtils.isNotEmpty((CharSequence)(iconUrl = AssistantPreset.getIconUrl((Long)value.getLong("id"))))) {
                    object.put("icon", AssistantCorpusUtils.checkKdcdc(UrlService.getDomainContextUrl() + iconUrl));
                }
                if (null != value.getLocaleString("name")) {
                    object.put("name", value.getLocaleString("name").getLocaleValue());
                }
                object.put("desc", value.getString("des"));
                object.put("number", value.getString("number"));
                object.put("id", value.getString("id"));
                values.add(object);
            }
            return values;
        }
        return Collections.emptyList();
    }

    public static String checkKdcdc(String imgURL) {
        boolean accountSession = Boolean.parseBoolean(SystemPropertyUtils.getProptyByTenant((String)"svc_login_account_session", (String)RequestContext.get().getTenantId()));
        if (accountSession) {
            return AssistantCorpusUtils.addKdcdc(imgURL);
        }
        return imgURL;
    }

    private static String addKdcdc(String imgURL) {
        if (StringUtils.isNotEmpty((CharSequence)imgURL)) {
            if (imgURL.contains("?")) {
                return imgURL + "&kdcdc=" + RequestContext.get().getAccountId();
            }
            return imgURL + "?kdcdc=" + RequestContext.get().getAccountId();
        }
        return null;
    }
}

