/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.api;

import kd.bos.gptas.api.KMSearchService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.VectorService;
import kd.bos.gptas.api.vector.EmbeddingModel;

final class GptasServiceFactory {
    GptasServiceFactory() {
    }

    static LLMService createLLM() {
        try {
            return (LLMService)Class.forName("kd.bos.gptas.common.llm.service.LLMServiceImpl").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static VectorService createVector(EmbeddingModel embeddingModel) {
        try {
            return (VectorService)Class.forName("kd.bos.gptas.common.VectorServiceImpl").getConstructor(EmbeddingModel.class).newInstance(new Object[]{embeddingModel});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static RerankService createRerank(String rerankNumber) {
        try {
            return (RerankService)Class.forName("kd.bos.gptas.common.rerank.service.RerankServiceImpl").getConstructor(String.class).newInstance(rerankNumber);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static KMSearchService createKMSearch(EmbeddingModel embeddingType) {
        try {
            return (KMSearchService)Class.forName("kd.bos.gptas.kmbase.service.KnowledgeVectorServiceImpl").getConstructor(EmbeddingModel.class).newInstance(new Object[]{embeddingType});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

