/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.api;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.EmbeddingModel;

public interface KMConfigService {
    public void save(String var1, EmbeddingModel var2, SplitConfig var3, Map<String, String> var4);

    public SplitConfig getSplitConfig(String var1);

    public static KMConfigService create() {
        return new KMConfigServiceImpl();
    }

    public static class KMConfigServiceImpl
    implements KMConfigService {
        @Override
        public void save(String entityNumber, EmbeddingModel embeddingModel, SplitConfig splitConfig, Map<String, String> params) {
            Class orRegister = TypesContainer.getOrRegister((String)"kd.bos.gptas.kmbase.common.KMConfigWriter");
            try {
                Method method = orRegister.getMethod("save", String.class, EmbeddingModel.class, SplitConfig.class, Map.class);
                method.invoke(null, new Object[]{entityNumber, embeddingModel, splitConfig, params});
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SplitConfig getSplitConfig(String entityNumber) {
            Class orRegister = TypesContainer.getOrRegister((String)"kd.bos.gptas.kmbase.common.KMConfigReader");
            try {
                Method method = orRegister.getMethod("getSplitConfig", String.class);
                return (SplitConfig)method.invoke(null, entityNumber);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }
}

