/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common;

import kd.bos.exception.ErrorCode;

public enum GptasErrorCode {
    UNKNOWN_ERROR(10000, "\u672a\u77e5\u9519\u8bef"),
    INVALID_PARAMETER(10001, "\u53c2\u6570\u65e0\u6548"),
    SERVICE_NOT_AVAILABLE(10002, "\u670d\u52a1\u4e0d\u53ef\u7528"),
    OPERATION_TIMEOUT(10003, "\u64cd\u4f5c\u8d85\u65f6"),
    VECTOR_STORE_ERROR(11000, "\u5411\u91cf\u5b58\u50a8\u9519\u8bef"),
    VECTOR_STORE_CONNECTION_ERROR(11001, "\u5411\u91cf\u5b58\u50a8\u8fde\u63a5\u9519\u8bef"),
    VECTOR_STORE_WRITE_ERROR(11002, "\u5411\u91cf\u5199\u5165\u9519\u8bef"),
    VECTOR_STORE_READ_ERROR(11003, "\u5411\u91cf\u8bfb\u53d6\u9519\u8bef"),
    VECTOR_STORE_DELETE_ERROR(11004, "\u5411\u91cf\u5220\u9664\u9519\u8bef"),
    VECTOR_DIMENSION_MISMATCH(11005, "\u5411\u91cf\u7ef4\u5ea6\u4e0d\u5339\u914d"),
    VECTOR_ID_NOT_FOUND(11006, "\u5411\u91cfID\u4e0d\u5b58\u5728"),
    VECTOR_BATCH_OPERATION_ERROR(11007, "\u5411\u91cf\u6279\u91cf\u64cd\u4f5c\u9519\u8bef"),
    VECTOR_SEARCH_ERROR(11008, "\u5411\u91cf\u68c0\u7d22\u9519\u8bef"),
    EMBEDDING_ERROR(12000, "Embedding\u9519\u8bef"),
    EMBEDDING_SERVICE_ERROR(12001, "Embedding\u670d\u52a1\u9519\u8bef"),
    EMBEDDING_REQUEST_ERROR(12002, "Embedding\u8bf7\u6c42\u9519\u8bef"),
    EMBEDDING_RESPONSE_ERROR(12003, "Embedding\u54cd\u5e94\u9519\u8bef"),
    EMBEDDING_TIMEOUT_ERROR(12004, "Embedding\u8d85\u65f6"),
    EMBEDDING_QUOTA_EXCEEDED(12005, "Embedding\u914d\u989d\u8d85\u9650"),
    EMBEDDING_MODEL_ERROR(12006, "Embedding\u6a21\u578b\u9519\u8bef"),
    EMBEDDING_TEXT_TOO_LONG(12007, "\u6587\u672c\u957f\u5ea6\u8d85\u9650"),
    EMBEDDING_BATCH_ERROR(12008, "\u6279\u91cfEmbedding\u9519\u8bef");

    private final int code;
    private final String message;

    private GptasErrorCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static GptasErrorCode fromCode(int code) {
        for (GptasErrorCode errorCode : GptasErrorCode.values()) {
            if (errorCode.getCode() != code) continue;
            return errorCode;
        }
        return UNKNOWN_ERROR;
    }

    public String toString() {
        return String.format("[%d] %s", this.getCode(), this.getMessage());
    }

    public ErrorCode toErrorCode() {
        return new ErrorCode(String.valueOf(this.getCode()), this.getMessage());
    }
}

