/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common;

import kd.bos.gptas.common.GptasErrorCode;

public class GptasException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final GptasErrorCode errorCode;
    private final String errorDetail;

    public GptasException(GptasErrorCode errorCode) {
        super(errorCode.getMessage());
        this.errorCode = errorCode;
        this.errorDetail = null;
    }

    public GptasException(GptasErrorCode errorCode, String errorDetail) {
        super(errorCode.getMessage() + ": " + errorDetail);
        this.errorCode = errorCode;
        this.errorDetail = errorDetail;
    }

    public GptasException(GptasErrorCode errorCode, String errorDetail, Throwable cause) {
        super(errorCode.getMessage() + ": " + errorDetail, cause);
        this.errorCode = errorCode;
        this.errorDetail = errorDetail;
    }

    public GptasErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDetail() {
        return this.errorDetail;
    }

    public int getCode() {
        return this.errorCode.getCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(": [").append(this.errorCode.getCode()).append("] ").append(this.errorCode.getMessage());
        if (this.errorDetail != null) {
            sb.append(" - ").append(this.errorDetail);
        }
        return sb.toString();
    }
}

