/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.KMImExportService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.common.vectordb.VectorStoreFactory;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.gptas.common.vectordb.proto.VectorBuffer;
import kd.bos.gptas.common.vectordb.service.VectorStoreService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.Pair;

public class KMImExportServiceImpl
implements KMImExportService {
    private VectorStoreService vectorStoreService;

    private VectorStoreService getVectorStoreService(String entityId) {
        if (this.vectorStoreService != null) {
            return this.vectorStoreService;
        }
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityId);
        this.vectorStoreService = VectorStoreFactory.create(splitConfig.getEmbeddingModel());
        return this.vectorStoreService;
    }

    public long batchExport(OutputStream outputStream, String entityId, List<Long> ids) throws IOException {
        return this.exportByProto(outputStream, entityId, ids);
    }

    private long exportByString(OutputStream outputStream, String entityId, List<Long> ids) throws IOException {
        long start = 0L;
        long limit = 100L;
        long count = 100L;
        VectorBuffer.VectorCollections.Builder vectorBuilder = VectorBuffer.VectorCollections.newBuilder();
        ArrayList<String> list = new ArrayList<String>(16);
        long total = 0L;
        while (count == 100L) {
            Map<String, List<?>> map = this.getVectorStoreService(entityId).query(entityId, ids, start, limit);
            QFilter[] qFilters = new QFilter[]{new QFilter("segmententity.id", "in", map.get("id"))};
            DynamicObjectCollection rows = QueryServiceHelper.query((String)entityId, (String)"number,segmententity.id,segmententity.seq", (QFilter[])qFilters, (String)"number,segmententity.seq");
            HashMap<Long, List> mapVector = new HashMap<Long, List>(16);
            List<?> chunkIds = map.get("id");
            List<?> vector = map.get("vector");
            for (int i = 0; i < chunkIds.size(); ++i) {
                mapVector.put((Long)chunkIds.get(i), (List)vector.get(i));
            }
            StringBuilder s = new StringBuilder(16);
            for (DynamicObject row : rows) {
                s.append(row.getString("number"));
                s.append(row.getInt("segmententity.seq"));
                List floats = (List)mapVector.get(row.getLong("segmententity.id"));
                for (Float aFloat : floats) {
                    s.append(aFloat);
                }
                list.add(s.toString());
            }
            count = map.get("id").size();
            start += count;
            total += count;
        }
        for (String s : list) {
            outputStream.write(s.getBytes(StandardCharsets.UTF_8));
        }
        return total;
    }

    private long exportByProto(OutputStream outputStream, String entityId, List<Long> ids) throws IOException {
        long start = 0L;
        long limit = 100L;
        long count = 100L;
        VectorBuffer.VectorCollections.Builder vectorBuilder = VectorBuffer.VectorCollections.newBuilder();
        long total = 0L;
        while (count == 100L) {
            Map<String, List<?>> map = this.getVectorStoreService(entityId).query(entityId, ids, start, limit);
            QFilter[] qFilters = new QFilter[]{new QFilter("segmententity.id", "in", map.get("id"))};
            DynamicObjectCollection rows = QueryServiceHelper.query((String)entityId, (String)"number,segmententity.id,segmententity.seq", (QFilter[])qFilters, (String)"number,segmententity.seq");
            HashMap<Long, List> mapVector = new HashMap<Long, List>(16);
            List<?> chunkIds = map.get("id");
            List<?> vector = map.get("vector");
            for (int i = 0; i < chunkIds.size(); ++i) {
                mapVector.put((Long)chunkIds.get(i), (List)vector.get(i));
            }
            for (DynamicObject row : rows) {
                VectorBuffer.VectorFields.Builder fieldsBuilder = VectorBuffer.VectorFields.newBuilder();
                fieldsBuilder.setNumber(row.getString("number"));
                fieldsBuilder.setSeq(row.getInt("segmententity.seq"));
                fieldsBuilder.addAllVector((Iterable)mapVector.get(row.getLong("segmententity.id")));
                VectorBuffer.VectorFields vectorFields = fieldsBuilder.build();
                vectorBuilder.addFields(vectorFields);
            }
            count = map.get("id").size();
            start += count;
            total += count;
        }
        vectorBuilder.setEntityId(entityId);
        VectorBuffer.VectorCollections data = vectorBuilder.build();
        data.writeTo(outputStream);
        return total;
    }

    public long batchImport(InputStream inputStream, String entityId) throws IOException {
        VectorBuffer.VectorCollections data = VectorBuffer.VectorCollections.parseFrom(inputStream);
        if (!entityId.equals(data.getEntityId())) {
            return -1L;
        }
        int vectorCount = data.getFieldsCount();
        String lastNumber = "";
        ArrayList<Integer> seqList = new ArrayList<Integer>(16);
        HashMap<Integer, List<Float>> mapVector = new HashMap<Integer, List<Float>>(16);
        ArrayList<VectorChunk> vectorChunkList = new ArrayList<VectorChunk>(16);
        for (int i = 0; i < vectorCount; ++i) {
            VectorBuffer.VectorFields vector = data.getFields(i);
            String number = vector.getNumber();
            int seq = vector.getSeq();
            if (!lastNumber.isEmpty() && !lastNumber.equals(number)) {
                vectorChunkList.addAll(this.convertToVectorChunkList(entityId, lastNumber, seqList, mapVector));
                mapVector.clear();
                seqList.clear();
            }
            mapVector.put(seq, vector.getVectorList());
            seqList.add(seq);
            lastNumber = number;
        }
        vectorChunkList.addAll(this.convertToVectorChunkList(entityId, lastNumber, seqList, mapVector));
        if (!vectorChunkList.isEmpty()) {
            Pair<List<VectorChunk>, List<VectorChunk>> result = this.getVectorStoreService(entityId).batchStore(vectorChunkList);
            this.updateFinishedStatus(entityId, (List)result.getKey());
            return ((List)result.getKey()).size();
        }
        return 0L;
    }

    private void updateFinishedStatus(String entityId, List<VectorChunk> vectorChunkList) {
        Object[] datas;
        HashSet<Long> set = new HashSet<Long>(16);
        for (VectorChunk vectorChunk : vectorChunkList) {
            Long knowledgeId = vectorChunk.getChunk().getKnowledgeId();
            set.add(knowledgeId);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityId);
        for (Object o : datas = BusinessDataReader.load((Object[])set.toArray(), (IDataEntityType)dataEntityType)) {
            DynamicObject bill = (DynamicObject)o;
            bill.set("uploadstatus", (Object)"S");
        }
        BusinessDataWriter.save((IDataEntityType)dataEntityType, (Object[])datas);
    }

    private List<VectorChunk> convertToVectorChunkList(String entityId, String lastNumber, List<Integer> seqList, Map<Integer, List<Float>> mapVector) {
        if (seqList.isEmpty()) {
            return Collections.emptyList();
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)lastNumber).and("segmententity.seq", "in", seqList), new QFilter("uploadstatus", "=", (Object)"I").or("uploadstatus", "=", (Object)"F")};
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entityId, (String)"id,number,segmententity.id,segmententity.seq,segmententity.segment_tag", (QFilter[])qFilters, (String)"number,segmententity.seq");
        ArrayList<VectorChunk> vectorChunkList = new ArrayList<VectorChunk>(16);
        for (DynamicObject row : rows) {
            Integer key = row.getInt("segmententity.seq");
            if (!mapVector.containsKey(key)) continue;
            Chunk chunk = new Chunk(Long.valueOf(row.getLong("segmententity.id")), entityId, Long.valueOf(row.getLong("id")), row.getString("segmententity.segment_tag"));
            VectorChunk vectorChunk = VectorChunk.asVector(chunk, mapVector.get(key));
            vectorChunkList.add(vectorChunk);
        }
        return vectorChunkList;
    }
}

