/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class KnowledgeVectorStorePlugin
implements VectorStorePlugin {
    private static final Log log = LogFactory.getLog(KnowledgeVectorStorePlugin.class);
    private String entityId = "";

    @Override
    public List<VectorResult> postSearch(List<VectorResult> results) {
        if (CollectionUtils.isEmpty(results)) {
            return Collections.emptyList();
        }
        try {
            this.fillChunkText(results);
            int startSize = results.size();
            results = results.stream().filter(vectorResult -> vectorResult.getChunk() != null && StringUtils.isNotBlank((CharSequence)vectorResult.getChunk().getContent())).collect(Collectors.toList());
            if (startSize != results.size()) {
                log.info("KnowledgeVectorStoreService.postSearch changed results size, from {} to {}", (Object)startSize, (Object)results.size());
            }
            return results;
        }
        catch (Exception e) {
            log.error("Error in postSearch", (Throwable)e);
            return results;
        }
    }

    private void fillChunkText(List<VectorResult> vectorResults) {
        if (CollectionUtils.isEmpty(vectorResults)) {
            return;
        }
        HashMap<String, Map> chunkOfIdOfEntityId = new HashMap<String, Map>();
        for (VectorResult vectorResult : vectorResults) {
            if (vectorResult == null || vectorResult.getChunk() == null) continue;
            Chunk chunk = vectorResult.getChunk();
            String entityId = chunk.getEntityId();
            chunkOfIdOfEntityId.computeIfAbsent(entityId, k -> new HashMap()).put(chunk.getId(), chunk);
        }
        for (Map.Entry entry : chunkOfIdOfEntityId.entrySet()) {
            String entityId = (String)entry.getKey();
            Map chunkOfId = (Map)entry.getValue();
            if (StringUtils.isBlank((CharSequence)entityId) || MapUtils.isEmpty((Map)chunkOfId)) continue;
            String selectFields = "name,segmententity.id,segmententity.segment_tag,id,segmententity.extendcontent_tag, segmententity.seq,segmententity.segmenttype";
            boolean isGroupKM = EntityMetadataCache.getDataEntityType((String)entityId).getProperties().containsKey((Object)"group");
            if (isGroupKM) {
                selectFields = selectFields + ",group.id";
            }
            QFilter qFilter = new QFilter("segmententity.id", "in", (Object)chunkOfId.keySet().toArray(new Long[0]));
            DataSet ds = QueryServiceHelper.queryDataSet((String)"km", (String)entityId, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"id");
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    Object o;
                    Long id = row.getLong("segmententity.id");
                    Chunk chunk = (Chunk)chunkOfId.get(id);
                    if (chunk == null) continue;
                    String content = this.convertCVPIMGToPreviewUrl(row.getString("segmententity.segment_tag"));
                    chunk.setContent(content);
                    chunk.setKnowledgeId(row.getLong("id"));
                    chunk.setKnowledgeName(row.getString("name"));
                    chunk.setChunkSeq(row.getInteger("segmententity.seq").intValue());
                    chunk.setEntityId(entityId);
                    chunk.setChunkType(row.getString("segmententity.segmenttype"));
                    String extContent = this.convertCVPIMGToPreviewUrl(row.getString("segmententity.extendcontent_tag"));
                    chunk.setExtendContent(extContent);
                    if (!isGroupKM || !((o = row.get("group.id")) instanceof Number)) continue;
                    chunk.setGroupId(row.getLong("group.id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private String convertCVPIMGToPreviewUrl(String content) {
        String patternString = "(?s)<cvp.img>(.*?)</cvp.img>";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = this.convertToPreviewUrl(matcher.group(1));
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String convertToPreviewUrl(String url) {
        String attUrl = UrlService.getAttachmentPreviewUrl((String)url);
        attUrl = EncreptSessionUtils.encryptSession((String)attUrl);
        return attUrl;
    }

    @Override
    public List<VectorChunk> preStore(List<VectorChunk> vectorChunks) {
        if (CollectionUtils.isEmpty(vectorChunks)) {
            return Collections.emptyList();
        }
        vectorChunks.forEach(this::validateChunk);
        Map vectorChunksByFormId = vectorChunks.stream().collect(Collectors.groupingBy(chunk -> chunk.getChunk().getEntityId(), LinkedHashMap::new, Collectors.toList()));
        Map<String, Set<Long>> validKnowledgeIdsByFormId = this.buildValidKnowledgeIds(vectorChunksByFormId);
        return vectorChunks.stream().filter(chunk -> this.isValidChunk((VectorChunk)chunk, validKnowledgeIdsByFormId)).collect(Collectors.toList());
    }

    private boolean isValidChunk(VectorChunk vectorChunk, Map<String, Set<Long>> validKnowledgeIds) {
        if (vectorChunk == null || vectorChunk.getChunk() == null) {
            return false;
        }
        String formId = vectorChunk.getChunk().getEntityId();
        Long knowledgeId = vectorChunk.getChunk().getKnowledgeId();
        if (formId == null || knowledgeId == null) {
            return false;
        }
        Set<Long> validIds = validKnowledgeIds.get(formId);
        return validIds != null && validIds.contains(knowledgeId);
    }

    private void validateChunk(VectorChunk vectorChunk) {
        if (vectorChunk == null) {
            throw new IllegalArgumentException("VectorChunk cannot be null");
        }
        SplitConfig splitConfig = this.getSplitConfig(vectorChunk.getChunk().getEntityId());
        if (splitConfig.isEnableVector() && (vectorChunk.getVector() == null || vectorChunk.getVector().isEmpty())) {
            throw new IllegalArgumentException("Vector data cannot be empty");
        }
        if (vectorChunk.getChunk() == null) {
            throw new IllegalArgumentException("chunk data cannot be empty");
        }
        if (vectorChunk.getChunk().getKnowledgeId() == null) {
            throw new IllegalArgumentException("knowledgeId cannot be empty");
        }
        if (vectorChunk.getChunk().getId() == 0L) {
            throw new IllegalArgumentException("chunkId cannot be empty");
        }
    }

    private Map<String, Set<Long>> buildValidKnowledgeIds(Map<String, List<VectorChunk>> vectorChunksByFormId) {
        HashMap<String, Set<Long>> validKnowledgeIds = new HashMap<String, Set<Long>>();
        vectorChunksByFormId.forEach((formId, vectorChunks) -> {
            Long[] knowledgeIds = (Long[])vectorChunks.stream().map(chunk -> chunk.getChunk().getKnowledgeId()).distinct().toArray(Long[]::new);
            QFilter qFilter = new QFilter("id", "in", (Object)knowledgeIds).and(new QFilter("status", "=", (Object)"C"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])qFilter.toArray());
            Set existingIds = dynamicObjects.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
            if (!existingIds.isEmpty()) {
                validKnowledgeIds.put((String)formId, existingIds);
            }
        });
        return validKnowledgeIds;
    }

    @Override
    public SplitConfig getSplitConfig(String entityId) {
        return KMConfigService.create().getSplitConfig(entityId);
    }
}

