/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.embedding.exception;

import kd.bos.gptas.common.GptasErrorCode;
import kd.bos.gptas.common.GptasException;

public class EmbeddingException
extends GptasException {
    private static final long serialVersionUID = 1L;

    public EmbeddingException(GptasErrorCode errorCode) {
        super(errorCode);
    }

    public EmbeddingException(GptasErrorCode errorCode, String errorDetail) {
        super(errorCode, errorDetail);
    }

    public EmbeddingException(GptasErrorCode errorCode, String errorDetail, Throwable cause) {
        super(errorCode, errorDetail, cause);
    }

    public static EmbeddingException serviceError(String detail) {
        return new EmbeddingException(GptasErrorCode.EMBEDDING_SERVICE_ERROR, detail);
    }

    public static EmbeddingException requestError(String detail) {
        return new EmbeddingException(GptasErrorCode.EMBEDDING_REQUEST_ERROR, detail);
    }

    public static EmbeddingException responseError(String detail) {
        return new EmbeddingException(GptasErrorCode.EMBEDDING_RESPONSE_ERROR, detail);
    }

    public static EmbeddingException timeoutError(long timeout) {
        String detail = String.format("Operation timed out after %d ms", timeout);
        return new EmbeddingException(GptasErrorCode.EMBEDDING_TIMEOUT_ERROR, detail);
    }

    public static EmbeddingException quotaExceeded(String detail) {
        return new EmbeddingException(GptasErrorCode.EMBEDDING_QUOTA_EXCEEDED, detail);
    }

    public static EmbeddingException modelError(String model, String detail) {
        String errorDetail = String.format("Model '%s' error: %s", model, detail);
        return new EmbeddingException(GptasErrorCode.EMBEDDING_MODEL_ERROR, errorDetail);
    }

    public static EmbeddingException textTooLong(int maxLength, int actualLength) {
        String detail = String.format("Text length %d exceeds maximum length %d", actualLength, maxLength);
        return new EmbeddingException(GptasErrorCode.EMBEDDING_TEXT_TOO_LONG, detail);
    }

    public static EmbeddingException batchError(String detail, Throwable cause) {
        return new EmbeddingException(GptasErrorCode.EMBEDDING_BATCH_ERROR, detail, cause);
    }
}

