/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.marker;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Stream;
import kd.bos.gptas.api.llm.MarkedMessageStream;
import kd.bos.gptas.api.llm.Marker;
import kd.bos.gptas.api.llm.MarkerContent;
import kd.bos.gptas.api.llm.MarkerPair;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.gptas.common.llm.marker.processor.MarkerProcessor;
import kd.bos.gptas.common.llm.marker.stream.StreamHandler;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MarkerAwareMessageStream
implements MarkedMessageStream {
    private final MessageStream originalMessage;
    private final MarkerProcessor processor;
    private final Queue<MarkerContent> contentQueue;
    private final Deque<MarkerContent> allMarkerContents;
    private boolean isFinished = false;

    public MarkerAwareMessageStream(MessageStream originalMessage, List<Marker> markers) {
        if (originalMessage == null) {
            throw new IllegalArgumentException("originalMessage cannot be null");
        }
        if (CollectionUtils.isEmpty(markers)) {
            throw new IllegalArgumentException("markers cannot be empty");
        }
        this.originalMessage = originalMessage;
        this.processor = new MarkerProcessor(markers);
        this.contentQueue = new LinkedList<MarkerContent>();
        this.allMarkerContents = new LinkedList<MarkerContent>();
    }

    public Stream<MarkerPair<String, MarkerContent>> stream() {
        return new StreamHandler(this).stream();
    }

    public boolean hasNext() {
        boolean nextChunk = this.processNextChunk();
        if (nextChunk) {
            return true;
        }
        return !this.contentQueue.isEmpty();
    }

    public MarkerPair<String, MarkerContent> next() {
        if (this.contentQueue.isEmpty()) {
            return new MarkerPair((Object)"", new MarkerContent(null, false, ""));
        }
        MarkerContent markerContent = this.contentQueue.poll();
        return new MarkerPair((Object)(StringUtils.isBlank((CharSequence)markerContent.getContent()) ? "" : markerContent.getContent()), markerContent);
    }

    private boolean processNextChunk() {
        if (this.isFinished) {
            return false;
        }
        if (this.originalMessage.hasNext()) {
            Queue<MarkerContent> result = this.processor.process((String)this.originalMessage.next());
            this.addToQueues(result);
            return true;
        }
        this.isFinished = true;
        Queue<MarkerContent> result = this.processor.lastProcess();
        this.addToQueues(result);
        return false;
    }

    private void addToQueues(Queue<MarkerContent> markerContents) {
        while (!markerContents.isEmpty()) {
            MarkerContent markerContent = markerContents.poll();
            if (markerContent.getMarker() == null || markerContent.getMarker() != null && markerContent.getMarker().isStream()) {
                this.contentQueue.offer(markerContent);
            }
            if (markerContent.getMarker() == null) continue;
            if (this.allMarkerContents.isEmpty() || this.allMarkerContents.peekLast() == null || this.allMarkerContents.peekLast().isEnd()) {
                this.allMarkerContents.add(new MarkerContent(markerContent.getMarker(), markerContent.isEnd(), markerContent.getContent()));
                continue;
            }
            MarkerContent markerContentLast = this.allMarkerContents.peekLast();
            markerContentLast.setEnd(markerContent.isEnd());
            markerContentLast.setContent(markerContentLast.getContent() + markerContent.getContent());
        }
    }

    public List<MarkerContent> getAllMarkerContents() {
        while (this.hasNext()) {
            this.next();
        }
        return new ArrayList<MarkerContent>(this.allMarkerContents);
    }
}

