/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.marker;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import java.util.stream.Collectors;
import kd.bos.gptas.api.llm.Marker;
import kd.bos.gptas.api.llm.MarkerContent;
import kd.bos.gptas.api.llm.MarkerPair;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.gptas.common.llm.marker.MarkerAwareMessageStream;
import kd.bos.gptas.common.llm.marker.SimpleMessageStream;

public class MarkerAwareMessageStreamExample {
    public static void main(String[] args) {
        LinkedList<String> messages = new LinkedList<String>(Arrays.asList("Hello", "<kn>Knowl", "edge1", "-aaabbb", "cccddd", "eeefff</kn>", "World", "<k", "n>Knowledge2</k", "n>CCC", "AAAA", "BBBB"));
        System.out.println("=== \u793a\u4f8b: \u6807\u8bb0\u5185\u5bb9\u53c2\u4e0e\u6d41\u5904\u7406 ===");
        System.out.println("\u539f\u59cb\u6d88\u606f: " + String.join((CharSequence)" ", messages));
        MarkerAwareMessageStreamExample.demonstrateContentMode(messages);
        MarkerAwareMessageStreamExample.demonstrateMarkerMode(messages);
        MarkerAwareMessageStreamExample.demonstrateCombinedMode(messages);
    }

    private static void demonstrateContentMode(Queue<String> messages) {
        MarkerAwareMessageStream stream = new MarkerAwareMessageStream(MarkerAwareMessageStreamExample.createMessageStream(messages), Collections.singletonList(new Marker("<kn>", "</kn>", true)));
        System.out.println("\n1. \u5185\u5bb9\u6a21\u5f0f\u8f93\u51fa:");
        stream.stream().filter(stringMarkerContentMarkerPair -> !stringMarkerContentMarkerPair.isMarked()).forEach(markerPair -> System.out.println("\u6587\u672c: " + (String)markerPair.getContent()));
        System.out.println("\u6536\u96c6\u5230\u7684\u6807\u8bb0: " + stream.getAllMarkerContents().stream().map(MarkerContent::getContent).collect(Collectors.joining(", ")));
    }

    private static void demonstrateMarkerMode(Queue<String> messages) {
        MarkerAwareMessageStream stream = new MarkerAwareMessageStream(MarkerAwareMessageStreamExample.createMessageStream(messages), Collections.singletonList(new Marker("<kn>", "</kn>", true)));
        System.out.println("\n2. \u6807\u8bb0\u6a21\u5f0f\u8f93\u51fa:");
        stream.stream().filter(MarkerPair::isMarked).forEach(markerPair -> System.out.println("\u6587\u672c: " + (String)markerPair.getContent()));
    }

    private static void demonstrateCombinedMode(Queue<String> messages) {
        MarkerAwareMessageStream stream = new MarkerAwareMessageStream(MarkerAwareMessageStreamExample.createMessageStream(messages), Collections.singletonList(new Marker("<kn>", "</kn>", true)));
        System.out.println("\n3. \u7ec4\u5408\u6a21\u5f0f\u8f93\u51fa:");
        stream.stream().forEach(markerPair -> System.out.printf("\u6587\u672c[%s] \u6807\u8bb0[%s] \u6807\u8bb0\u7ed3\u675f[%s]%n", markerPair.getContent(), markerPair.isMarked(), markerPair.getMarkerContent().isEnd()));
    }

    private static MessageStream createMessageStream(Queue<String> messages) {
        return new SimpleMessageStream(new LinkedList<String>(messages));
    }
}

