/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.marker.processor;

public class SlidingWindowProcessor {
    private StringBuilder content = new StringBuilder();
    private int minRetainSize;
    private SlideModel currentSlideModel;

    public SlidingWindowProcessor(int size) {
        this.minRetainSize = size / 2;
        this.currentSlideModel = SlideModel.SAFE;
    }

    public void input(String str) {
        this.content.append(str);
    }

    public String getContent() {
        return this.content.toString();
    }

    public void setState(SlideModel slideModel) {
        this.currentSlideModel = slideModel;
    }

    public String slide() {
        return this.slide(null, null);
    }

    public String slide(Integer pos, Integer length) {
        if (this.content.length() == 0) {
            return "";
        }
        String result = "";
        switch (this.currentSlideModel) {
            case SAFE: {
                if (this.content.length() <= this.minRetainSize) {
                    return "";
                }
                int moveLength = this.content.length() - this.minRetainSize;
                result = this.content.substring(0, moveLength);
                this.content.delete(0, moveLength);
                break;
            }
            case POINT: {
                if (pos == null || length == null || pos < 0 || length <= 0 || pos + length > this.content.length()) break;
                result = this.content.substring(0, pos);
                this.content.delete(0, pos + length);
                break;
            }
            case FINISH: {
                result = this.content.toString();
                this.content.delete(0, this.content.length());
                break;
            }
        }
        return result;
    }

    public static enum SlideModel {
        SAFE,
        POINT,
        FINISH;

    }
}

