/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.llm.stream;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.function.Function;
import kd.bos.gptas.api.llm.MessageStream;
import kd.bos.gptas.common.llm.stream.BufferedMessageStream;
import kd.bos.gptas.common.llm.stream.LineReader;

public class IterMessageStream
implements MessageStream,
AutoCloseable {
    private final LineReader lineReader;
    private final AutoCloseable closeable;
    private boolean closed = false;
    private final Function<String, String> resultConsumer;
    private String nextLine = null;
    private BufferedMessageStream buf;
    private StringBuilder bufCollector = new StringBuilder(1024);

    public IterMessageStream(LineReader reader, AutoCloseable closeable, Function<String, String> resultConsumer) {
        this.lineReader = reader;
        this.closeable = closeable;
        this.resultConsumer = resultConsumer;
    }

    public boolean hasNext() {
        if (this.buf != null) {
            return this.buf.hasNext();
        }
        if (this.nextLine != null) {
            return true;
        }
        try {
            this.nextLine = this.lineReader.read();
            if (this.nextLine == null) {
                this.silentlyClose();
            }
            this.lineReader.readEmpty();
            return this.nextLine != null;
        }
        catch (Exception e) {
            this.silentlyClose();
            return false;
        }
    }

    public String next() {
        if (this.buf != null) {
            return this.buf.next();
        }
        if (this.nextLine != null || this.hasNext()) {
            String lineToReturn = this.nextLine;
            this.nextLine = null;
            String data = this.resultConsumer.apply(lineToReturn);
            this.bufCollector.append(data);
            return data;
        }
        this.silentlyClose();
        throw new NoSuchElementException();
    }

    private void silentlyClose() {
        if (!this.closed) {
            this.closed = true;
            this.buf = new BufferedMessageStream(this.bufCollector.toString());
            this.bufCollector = null;
            try {
                this.closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String fetch() {
        if (this.buf == null) {
            while (this.hasNext()) {
                this.next();
            }
        }
        return this.buf.fetch();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                throw new IOException("Failed to close " + this.getClass().getSimpleName(), e);
            }
        }
    }
}

