/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.rerank.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.rerank.RerankResult;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.rerank.RerankFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RerankServiceImpl
implements RerankService {
    private static final Log log = LogFactory.getLog(RerankServiceImpl.class);
    private String rerankNumber;

    public RerankServiceImpl(String rerankNumber) {
        this.rerankNumber = rerankNumber;
    }

    public List<RerankResult> rerank(String content, List<Chunk> chunks, int topK) {
        RerankService rerankService = RerankFactory.create(this.rerankNumber);
        return rerankService.rerank(content, chunks, topK);
    }

    public List<VectorResult> rerankSearchResults(String content, List<VectorResult> vectorResults, int topK) {
        RerankService rerankService = RerankFactory.create(this.rerankNumber);
        List chunks = vectorResults.stream().map(VectorResult::getChunk).collect(Collectors.toList());
        List rerankResults = rerankService.rerank(content, chunks, topK);
        ArrayList<VectorResult> rerankedVectorResults = new ArrayList<VectorResult>(vectorResults.size());
        int currentRank = 1;
        for (RerankResult rerankResult : rerankResults) {
            if (rerankResult.getOriginIndex() >= vectorResults.size()) {
                log.error("Rerank result index out of bounds: originIndex={}, candidateSize={}, content='{}'", new Object[]{rerankResult.getOriginIndex(), vectorResults.size(), content});
                continue;
            }
            VectorResult originalVectorResult = vectorResults.get(rerankResult.getOriginIndex());
            originalVectorResult.setRank(currentRank++);
            originalVectorResult.setScore(rerankResult.getRelevanceScore());
            originalVectorResult.setScoreFrom("rerank");
            rerankedVectorResults.add(originalVectorResult);
        }
        return rerankedVectorResults;
    }
}

