/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.common.vectortask.storage;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorTask;
import kd.bos.gptas.api.vector.VectorTaskItem;

public abstract class AbstractVectorTaskStorage {
    protected static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("vectortask", new DistributeCacheHAPolicy(true, true));
    private static final String TASK_KEY_PREFIX = "vector:tasks:";
    private static final String CHUNK_KEY_PREFIX = "vector:chunks:";

    protected VectorTaskItem createInitialChunkStatus(Chunk chunk) {
        return new VectorTaskItem.Builder().chunkId(String.valueOf(chunk.getId())).status(VectorTaskItem.VectorTaskItemStatus.PENDING).updateTime(System.currentTimeMillis()).build();
    }

    protected String getTaskKey(String taskId) {
        return RequestContext.get().getAccountId() + TASK_KEY_PREFIX + taskId;
    }

    protected String getChunkKey(String taskId) {
        return RequestContext.get().getAccountId() + CHUNK_KEY_PREFIX + taskId;
    }

    protected void validateTask(VectorTask task) {
        if (task == null || task.getTaskId() == null || task.getTaskId().isEmpty()) {
            throw new IllegalArgumentException("Invalid task or taskId");
        }
    }

    protected void validateChunksAndStatus(List<Chunk> chunks, VectorTaskItem.VectorTaskItemStatus status) {
        if (chunks == null || chunks.isEmpty()) {
            throw new IllegalArgumentException("Chunks cannot be null or empty");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
    }

    protected String[] getChunkIds(List<Chunk> chunks) {
        return (String[])chunks.stream().map(chunk -> String.valueOf(chunk.getId())).toArray(String[]::new);
    }

    private static String getAccountId() {
        return RequestContext.get().getAccountId();
    }
}

