/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.openapi;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AccessTokenManager {
    private static Map<String, TokenInfo> tokenInfoMap = new ConcurrentHashMap<String, TokenInfo>();

    AccessTokenManager() {
    }

    private static String genMapKey(Map<String, Object> data) {
        return data.toString();
    }

    static String getAccessToken(Map<String, Object> data) {
        String key = AccessTokenManager.genMapKey(data);
        TokenInfo tokenInfo = tokenInfoMap.get(key);
        if (tokenInfo != null && tokenInfo.expiredTime > System.currentTimeMillis()) {
            return tokenInfo.accessToken;
        }
        return null;
    }

    static void setAccessToken(Map<String, Object> data, String accessToken, long expiredTime) {
        String key = AccessTokenManager.genMapKey(data);
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.accessToken = accessToken;
        tokenInfo.expiredTime = expiredTime;
        tokenInfoMap.put(key, tokenInfo);
    }

    static void clearAccessToken(Map<String, Object> data) {
        String key = AccessTokenManager.genMapKey(data);
        tokenInfoMap.remove(key);
    }

    private static class TokenInfo {
        String accessToken;
        long expiredTime;

        private TokenInfo() {
        }
    }
}

