/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.utils;

import kd.bos.context.RequestContext;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkInternal;

public class SystemPropertyUtils {
    @SdkInternal
    public static Integer getInteger(String tenantId, String key, Integer defaultValue) {
        Integer returnValue = defaultValue;
        String keyValue = SystemPropertyUtils.getProptyByTenant(key, tenantId);
        if (StringUtils.isNotEmpty((String)keyValue) && StringUtils.isNumericString((String)keyValue)) {
            returnValue = Integer.parseInt(keyValue);
        }
        return returnValue;
    }

    @SdkInternal
    public static String getProptyByTenant(String key, String tenantId) {
        if (StringUtils.isNotEmpty((String)tenantId)) {
            String pValue = System.getProperty(tenantId + "_" + key);
            if (StringUtils.isEmpty((String)pValue)) {
                pValue = System.getProperty(key);
            }
            return pValue;
        }
        return System.getProperty(key);
    }

    @SdkInternal
    public static String getPropertyByTenant(String key) {
        String tenantId = RequestContext.get().getTenantId();
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtils.isEmpty((String)pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }
}

