/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.gptas.webapi;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class ConversionResult
implements Serializable {
    private final DynamicObject data;
    private final Map<Integer, List<String>> errors;

    public ConversionResult(DynamicObject data, Map<Integer, List<String>> errors) {
        this.data = data;
        this.errors = errors;
    }

    public DynamicObject getData() {
        return this.data;
    }

    public Map<Integer, List<String>> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public String getErrorMessage() {
        if (!this.hasErrors()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, List<String>> entry : this.errors.entrySet()) {
            for (String error : entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(error);
            }
        }
        return sb.toString();
    }
}

