/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.utils.AppParameterUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.exception.KDException;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIKMTemplateAppendGenIndexOpPlugin
extends AbstractOperationServicePlugIn {
    private boolean enableIndex;
    private static final Logger LOG = LoggerFactory.getLogger(AIKMTemplateAppendGenIndexOpPlugin.class);
    private int maxQ;
    private int indexSpan;
    private static final String PROMPT = AIKMTemplateAppendGenIndexOpPlugin.getPrompt();
    private static final String DYNAMIC_PROMPT = "\n -\u4e0d\u8981\u548c\u5df2\u6709\u95ee\u9898\u91cd\u590d\n\n\n# \u6587\u7ae0\u5185\u5bb9:\nid\u4e3a{{id}}\u7684\u6587\u7ae0\u9700\u8981\u751f\u6210{{questionCount}}\u4e2a\u95ee\u9898\uff0c\u6587\u7ae0\u5185\u5bb9\u4e3a\uff1a{{content}}\n";
    private static final String EXSITS_STR = "\n# \u5df2\u6709\u95ee\u9898:\n{{existQ}};";

    public void initialize(InitOperationArgs e) {
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(this.billEntityType.getName());
        this.enableIndex = splitConfig.isEnableIndex();
        this.maxQ = splitConfig.getMaxQ();
        Object param = AppParameterUtils.getAppParam().get("indexspan");
        this.indexSpan = param != null ? (Integer)param : 100;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!this.enableIndex) {
            return;
        }
        String segmentSeq = this.getOption().getVariableValue("segmentseq", "");
        if (StringUtils.isBlank((CharSequence)segmentSeq)) {
            return;
        }
        int seq = Integer.parseInt(segmentSeq);
        DynamicObject dynamicObject = e.getDataEntities()[0];
        if (dynamicObject == null) {
            return;
        }
        DynamicObject selectedSegment = (DynamicObject)dynamicObject.getDynamicObjectCollection("segmententity").get(seq);
        if (selectedSegment == null) {
            return;
        }
        SubEntryType subEntryType = (SubEntryType)this.billEntityType.getAllEntities().get("subentryentity");
        this.genQindex(selectedSegment, PROMPT + DYNAMIC_PROMPT, this.indexSpan, this.maxQ, subEntryType);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private String buildPrompt(DynamicObject segment, DynamicObjectCollection subEntryEntity, String prompt, int indexSpan, int maxQ) {
        String segmentText = (String)segment.get("segment_tag");
        int questionCount = indexSpan != 0 ? (int)Math.min(Math.ceil((double)segmentText.length() / (double)indexSpan), (double)maxQ) : maxQ;
        prompt = prompt.replace("{{id}}", String.valueOf(segment.getLong("id")));
        prompt = prompt.replace("{{questionCount}}", String.valueOf(questionCount));
        prompt = prompt.replace("{{content}}", segmentText);
        StringBuilder qindexStr = new StringBuilder();
        for (DynamicObject dynamicObject : subEntryEntity) {
            String qindex = dynamicObject.getString("qindex");
            if (!StringUtils.isNotBlank((CharSequence)qindex)) continue;
            qindexStr.append(qindex).append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)qindexStr)) {
            prompt = prompt + EXSITS_STR.replace("{{existQ}}", qindexStr.toString());
        }
        return prompt;
    }

    private void genQindex(DynamicObject segment, String prompt, int indexSpan, int maxQ, SubEntryType subEntryType) throws KDException {
        DynamicObjectCollection subEntryEntity = segment.getDynamicObjectCollection("subentryentity");
        prompt = this.buildPrompt(segment, subEntryEntity, prompt, indexSpan, maxQ);
        try {
            Object questObj;
            String content = LLMService.create().syncLLM(prompt, new HashMap(0));
            for (int tryCount = 0; StringUtils.isBlank((CharSequence)content) && tryCount < 3; ++tryCount) {
                content = LLMService.create().syncLLM(prompt, new HashMap(0));
            }
            content = content.replace("```json", "").replace("```", "");
            LOG.info("GenQA result content:" + content);
            List qaList = SerializationUtils.fromJsonStringToList((String)content, Map.class);
            if (!qaList.isEmpty() && (questObj = ((Map)qaList.get(0)).get("questions")) instanceof List) {
                int seq = subEntryEntity.size() + 1;
                segment.set("hasgenindex", (Object)true);
                for (Object quest : (List)questObj) {
                    if (!(quest instanceof String) || StringUtils.isBlank(quest)) continue;
                    DynamicObject subDynamicObject = new DynamicObject((DynamicObjectType)subEntryType);
                    subDynamicObject.set("seq", (Object)seq);
                    subDynamicObject.set("qindex", quest);
                    subEntryEntity.add((Object)subDynamicObject);
                    ++seq;
                }
            }
        }
        catch (Exception e) {
            LOG.error(String.format("BatchGenIndexTask gen index of segment seq %1$d error, %2$s", segment.getInt("seq"), e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPrompt() {
        try (InputStream stream = AIKMTemplateAppendGenIndexOpPlugin.class.getResourceAsStream("/" + AIKMTemplateAppendGenIndexOpPlugin.class.getPackage().getName().replace(".", "/") + "/prompt/GenQ.md");){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i, StandardCharsets.UTF_8));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

