/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.kmbase.common.KMConfigReader;

public class AIKMTemplateAuditOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM_TYPE = "ai-km";
    private boolean enableIndex;

    public void initialize(InitOperationArgs e) {
        SplitConfig splitConfig = KMConfigReader.getSplitConfig((String)this.billEntityType.getName());
        this.enableIndex = splitConfig.isEnableIndex();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CheckGenIndexValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        if (this.enableIndex) {
            this.getOption().setVariableValue("handlerclass_KMIndexHandler", "kd.ai.km.management.index.KMIndexHandler");
            e.getFieldKeys().add("uploadstatus");
        }
    }

    class CheckGenIndexValidator
    extends AbstractValidator {
        CheckGenIndexValidator() {
        }

        public void validate() {
            if (AIKMTemplateAuditOpPlugin.this.enableIndex) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Object uploadStatus = dataEntity.getValue("uploadstatus");
                    if (uploadStatus == null || uploadStatus.equals("G")) continue;
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8fd8\u672a\u751f\u6210\u5b8c\u589e\u5f3a\u7d22\u5f15\uff0c\u8bf7\u7a0d\u540e\u5ba1\u6838\u3002", (String)"CheckGenIndexValidator_0", (String)AIKMTemplateAuditOpPlugin.SYSTEM_TYPE, (Object[])new Object[0]));
                }
            }
        }
    }
}

