/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.id.ID;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIKMTemplateGenIndexOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String SYSTEM_TYPE = "ai-km";
    private static final Logger log = LoggerFactory.getLogger(AIKMTemplateGenIndexOpPlugin.class);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final String CALLBACK_TASK_GEN_INDEX = "CALLBACK_TASK_GENINDEX";
    private boolean enableIndex;

    public void initialize(InitOperationArgs e) {
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(this.billEntityType.getName());
        this.enableIndex = splitConfig.isEnableIndex();
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("segmententity.hasgenindex");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (!this.enableIndex) {
            log.info("\u672a\u5f00\u542f\u7d22\u5f15\u589e\u5f3a\uff0c\u4e0d\u751f\u6210\u7d22\u5f15");
            return;
        }
        DynamicObject[] dynamicObjects = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>(10);
        block0: for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection segmentEntity = dynamicObject.getDynamicObjectCollection("segmententity");
            for (DynamicObject segment : segmentEntity) {
                if (segment.getBoolean("hasgenindex")) continue;
                ids.add(dynamicObject.getLong("id"));
                continue block0;
            }
        }
        if (ids.isEmpty()) {
            log.info("\u5f85\u751f\u6210\u7d22\u5f15\u7684\u5206\u5757\u5df2\u7ecf\u751f\u6210\u8fc7\u7d22\u5f15\u4e86\u3002");
            return;
        }
        String cacheKey = CacheKeyUtil.getAcctId() + this.billEntityType.getName() + ".ids";
        if (cache.contains(cacheKey)) {
            Map values = cache.getAll(cacheKey);
            Collection idsCollect = values.values();
            for (String idsString : idsCollect) {
                if (!StringUtils.isNotBlank((CharSequence)idsString)) continue;
                List cacheIds = (List)SerializationUtils.fromJsonString((String)idsString, List.class);
                for (Long id : cacheIds) {
                    ids.remove(id);
                }
            }
        }
        if (!ids.isEmpty()) {
            this.startGenIndexTask(ids);
        } else {
            log.info("\u7d22\u5f15\u751f\u6210\u4efb\u52a1\u5df2\u5b58\u5728\uff0c\u4e0d\u91cd\u590d\u751f\u6210");
        }
    }

    private void startGenIndexTask(List<Long> ids) {
        String pageId = this.getOption().getVariableValue("pageid", "");
        IFormView formView = SessionManager.getCurrent().getView(pageId);
        JobInfo jobInfo = this.createJobInfo(formView, ids);
        if (formView == null) {
            ScheduleServiceHelper.dispatch((JobInfo)jobInfo);
            return;
        }
        String pluginName = this.getOption().getVariableValue("pluginname", "kd.ai.km.tpl.KMBaseListPlugin");
        CloseCallBack closeCallBack = new CloseCallBack(pluginName, CALLBACK_TASK_GEN_INDEX);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"AIKMTemplateGenIndexOpPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setCloseCallBack(closeCallBack);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formView);
    }

    private JobInfo createJobInfo(IFormView formView, List<Long> ids) {
        String captionValue;
        String appId;
        JobInfo jobInfo = new JobInfo();
        if (formView == null) {
            appId = "gai";
            captionValue = this.billEntityType.getName();
        } else {
            FormShowParameter fsp = formView.getFormShowParameter();
            appId = fsp.getAppId();
            captionValue = fsp.getFormConfig().getCaption().getLocaleValue();
        }
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        LocaleString jobName = new LocaleString(captionValue);
        jobInfo.setName(jobName.toString());
        jobInfo.setNumber(this.billEntityType.getName() + "_genIndex_Job");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.km.base.BatchGenIndexTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("entitynumber", this.billEntityType.getName());
        params.put("ids", ids);
        jobInfo.setParams(params);
        return jobInfo;
    }
}

