/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import kd.ai.km.utils.AppParameterUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDException;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGenIndexTask
extends AbstractTask {
    private static final String SYSTEM_TYPE = "ai-km";
    private static final Logger log = LoggerFactory.getLogger(BatchGenIndexTask.class);
    private static final ThreadPool threadPools = ThreadPools.newFixedThreadPool((String)BatchGenIndexTask.class.getName(), (int)10);
    private static final ThreadPool SegmentHandleThreadPools = ThreadPools.newFixedThreadPool((String)(BatchGenIndexTask.class.getName() + "_segment"), (int)10);
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));
    private static final String PROMPT = BatchGenIndexTask.getPrompt();
    private static final String DYNAMIC_PROMPT = "\n# \u6587\u7ae0\u5185\u5bb9:\nid\u4e3a{{id}}\u7684\u6587\u7ae0\u9700\u8981\u751f\u6210{{questionCount}}\u4e2a\u95ee\u9898\uff0c\u6587\u7ae0\u5185\u5bb9\u4e3a\uff1a{{content}}\n";
    private AtomicInteger totalSegCount = new AtomicInteger(0);
    private AtomicInteger progressCount = new AtomicInteger(0);
    private int progressPercent = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) {
        log.info("BatchGenIndexTask execute");
        String entityNumber = (String)map.get("entitynumber");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            log.warn("BatchGenIndexTask entitynumber is null");
            return;
        }
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        boolean enableIndex = splitConfig.isEnableIndex();
        if (!enableIndex) {
            log.warn("BatchGenIndexTask enableIndex is false");
            return;
        }
        String cacheKey = CacheKeyUtil.getAcctId() + entityNumber + ".ids";
        try {
            int maxQ = splitConfig.getMaxQ();
            Object param = AppParameterUtils.getAppParam().get("indexspan");
            int indexSpan = param != null ? (Integer)param : 100;
            List ids = (List)map.get("ids");
            if (ids.isEmpty()) {
                log.warn("BatchGenIndexTask ids is empty");
                return;
            }
            Collections.sort(ids);
            cache.put(cacheKey, this.taskId, ids.toString(), 7200);
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"BatchGenIndexTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
            this.calSegCount(dynamicObjects);
            SubEntryType subEntryType = (SubEntryType)EntityMetadataCache.getDataEntityType((String)entityNumber).getAllEntities().get("subentryentity");
            Phaser phaser = new Phaser(1);
            for (DynamicObject dynamicObject : dynamicObjects) {
                phaser.register();
                threadPools.execute(() -> {
                    this.genQindex(dynamicObject, indexSpan, maxQ, subEntryType);
                    phaser.arriveAndDeregister();
                });
            }
            phaser.arriveAndAwaitAdvance();
        }
        catch (Exception e) {
            log.error("BatchGenIndexTask execute error {}", (Object)e.getMessage());
        }
        finally {
            cache.remove(cacheKey, this.taskId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPrompt() {
        try (InputStream stream = BatchGenIndexTask.class.getResourceAsStream("/" + BatchGenIndexTask.class.getPackage().getName().replace(".", "/") + "/prompt/GenQ.md");){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i, StandardCharsets.UTF_8));
            }
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void calSegCount(DynamicObject[] dynamicObjects) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection segmententity = (DynamicObjectCollection)dynamicObject.get("segmententity");
            this.totalSegCount.addAndGet(segmententity.size());
        }
    }

    private void genQindex(DynamicObject dynamicObject, int indexSpan, int maxQ, SubEntryType subEntryType) throws KDException {
        DynamicObjectCollection segmententity = (DynamicObjectCollection)dynamicObject.get("segmententity");
        if (segmententity.isEmpty()) {
            return;
        }
        StringBuilder finalPrompt = new StringBuilder();
        finalPrompt.append(PROMPT);
        int fixedLength = finalPrompt.length();
        HashMap<Long, DynamicObject> segmentMap = new HashMap<Long, DynamicObject>(segmententity.size());
        ArrayList<String> promptList = new ArrayList<String>(10);
        for (int i = 0; i < segmententity.size(); ++i) {
            DynamicObject segment = (DynamicObject)segmententity.get(i);
            segmentMap.put(segment.getLong("id"), segment);
            if (segment.getBoolean("hasgenindex")) continue;
            String segmentText = (String)segment.get("segment_tag");
            int questionCount = indexSpan != 0 ? (int)Math.min(Math.ceil((double)segmentText.length() / (double)indexSpan), (double)maxQ) : maxQ;
            String segPrompt = DYNAMIC_PROMPT.replace("{{id}}", String.valueOf(segment.getLong("id"))).replace("{{questionCount}}", String.valueOf(questionCount)).replace("{{content}}", segmentText);
            if (fixedLength + segPrompt.length() > 4000) {
                promptList.add(PROMPT + segPrompt);
                continue;
            }
            if (finalPrompt.length() + segPrompt.length() < 4000) {
                finalPrompt.append(segPrompt);
                continue;
            }
            promptList.add(finalPrompt.toString());
            if (finalPrompt.length() > 4000) {
                log.info("BatchGenIndexTask \u8d85\u957f\u4e86");
            }
            finalPrompt.delete(0, finalPrompt.length());
            finalPrompt.append(PROMPT).append(segPrompt);
        }
        if (finalPrompt.length() > fixedLength) {
            promptList.add(finalPrompt.toString());
            finalPrompt.delete(0, finalPrompt.length());
        }
        this.totalSegCount.addAndGet(-(segmententity.size() - promptList.size()));
        ArrayList<Future> futures = new ArrayList<Future>(10);
        for (String prompt : promptList) {
            Future f = SegmentHandleThreadPools.submit(() -> {
                try {
                    this.progressCount.incrementAndGet();
                    log.info("BatchGenIndexTask \u63d0\u793a\u8bed\u957f\u5ea6 " + prompt.length());
                    String content = LLMService.create().syncLLM(prompt, new HashMap(0));
                    for (int tryCount = 0; StringUtils.isBlank((CharSequence)content) && tryCount < 3; ++tryCount) {
                        content = LLMService.create().syncLLM(prompt, new HashMap(0));
                    }
                    this.progressPercent = 100 * this.progressCount.get() / this.totalSegCount.get();
                    this.feedbackProgress(this.progressPercent, String.format("\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\uff1a%3$s", this.progressCount, this.totalSegCount, ResManager.loadKDString((String)"\u77e5\u8bc6\u6b63\u5728\u751f\u6210\u7d22\u5f15", (String)"BatchGenIndexTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
                    if (StringUtils.isNotBlank((CharSequence)content)) {
                        content = content.replace("```json", "").replace("```", "");
                        log.info("BatchGenIndexTask Gen qindex content:" + content);
                        List qaList = SerializationUtils.fromJsonStringToList((String)content, Map.class);
                        for (Map qa : qaList) {
                            Object idObj = qa.get("id");
                            long id = idObj instanceof String ? Long.parseLong((String)idObj) : (Long)idObj;
                            DynamicObject seg = (DynamicObject)segmentMap.get(id);
                            if (seg == null) continue;
                            DynamicObjectCollection subEntryEntity = (DynamicObjectCollection)seg.get("subentryentity");
                            Object questObj = qa.get("questions");
                            if (questObj instanceof List) {
                                if (((List)questObj).isEmpty()) continue;
                                seg.set("hasgenindex", (Object)true);
                                int seq = 1;
                                for (Object quest : (List)questObj) {
                                    if (!(quest instanceof String) || StringUtils.isBlank(quest)) continue;
                                    DynamicObject subDynamicObject = new DynamicObject((DynamicObjectType)subEntryType);
                                    subDynamicObject.set("seq", (Object)seq);
                                    subDynamicObject.set("qindex", quest);
                                    subEntryEntity.add((Object)subDynamicObject);
                                    ++seq;
                                }
                                continue;
                            }
                            if (!(questObj instanceof String) || StringUtils.isBlank(questObj)) continue;
                            DynamicObject subDynamicObject = new DynamicObject((DynamicObjectType)subEntryType);
                            subDynamicObject.set("seq", (Object)1);
                            subDynamicObject.set("qindex", questObj);
                            subEntryEntity.add((Object)subDynamicObject);
                        }
                    } else {
                        log.error("BatchGenIndexTask gen qindex is blank, prompt is " + prompt);
                    }
                    return "ok";
                }
                catch (Exception e) {
                    log.error(String.format("BatchGenIndexTask gen qindex error, prompt is %1$s, error message is %2$s", prompt, e.getMessage()));
                    return "error";
                }
            });
            futures.add(f);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error("BatchGenIndexTask error ", (Throwable)e);
            }
        }
        dynamicObject.set("uploadstatus", (Object)"G");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }
}

