/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;

public class ChangeViewListPlugin
extends AbstractFormPlugin
implements TabSelectListener,
FilterContainerInitListener,
SearchClickListener {
    private static final Log logger = LogFactory.getLog(ChangeViewListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabap = (Tab)this.getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        filterContainer.addSearchClickListener((SearchClickListener)this);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        String billKey = ((ListView)this.getView()).getBillFormId();
        if ("tabdoc".equals(tabKey)) {
            if (billKey.endsWith("_qa")) {
                billKey = billKey.substring(0, billKey.length() - 3);
            }
        } else if (!billKey.endsWith("_qa")) {
            billKey = billKey + "_qa";
        }
        this.changeBillView(billKey);
    }

    private void changeBillView(String newBillFormId) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String billFormId = this.getPageCache().get("lastbill");
        if (billFormId == null) {
            billFormId = billList.getBillFormId();
        }
        if (billFormId.equals(newBillFormId)) {
            return;
        }
        ListView listView = (ListView)this.getView();
        billList.setEntryEntity(newBillFormId);
        billList.setEntityId(newBillFormId);
        listView.changeListView(newBillFormId);
        billList.setListViewDefaultView();
        Map listToolBar = FormMetadataCache.getListToolBar((String)newBillFormId);
        listToolBar.put("id", "toolbarap");
        this.getView().updateControlMetadata("toolbarap", listToolBar);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        formShowParameter.setBillFormId(newBillFormId);
        this.getView().cacheFormShowParameter();
        this.getPageCache().put("lastbill", newBillFormId);
        ((ListView)this.getView()).refresh();
        ((ListView)this.getView()).clearSelection();
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        String s = this.getView().getPageCache().get("km_customfilter");
        if (s != null) {
            List list = SerializationUtils.fromJsonStringToList((String)s, Map.class);
            logger.info("{},{}", (Object)s, (Object)list);
            block0: for (Map map : list) {
                String fieldName = ((List)map.get("FieldName")).isEmpty() ? "" : (String)((List)map.get("FieldName")).get(0);
                String compare = ((List)map.get("Compare")).isEmpty() ? "" : (String)((List)map.get("Compare")).get(0);
                List commonFilterColumns = evt.getCommonFilterColumns();
                for (FilterColumn commonFilterColumn : commonFilterColumns) {
                    CommonFilterColumn filterColumn = (CommonFilterColumn)commonFilterColumn;
                    if (!filterColumn.getFilterFieldName().equals(fieldName)) continue;
                    if (compare.isEmpty()) {
                        Object value = map.get("Value");
                        if (value instanceof Collection) {
                            filterColumn.setDefaultValues((List)value);
                            continue block0;
                        }
                        filterColumn.setDefaultValues(new Object[]{value});
                        continue block0;
                    }
                    filterColumn.setConstantDefaultValue(map.get("Value"));
                    continue block0;
                }
            }
        }
    }

    public void click(SearchClickEvent evt) {
        Map filterValues = evt.getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            String customfilter = SerializationUtils.toJsonString(filterValues.get("customfilter"));
            logger.info(customfilter);
            this.getView().getPageCache().put("km_customfilter", customfilter);
        } else {
            this.getView().getPageCache().remove("km_customfilter");
        }
    }
}

