/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kd.ai.km.utils.KMManager;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.dao.DesignerData;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.exception.ErrorInfo;
import kd.bos.metadata.form.BillFormAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.BillListAp;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.metadata.perm.PermissionDimension;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMDesignerData {
    private static final Log log = LogFactory.getLog(KMDesignerData.class);
    private static final String AI_KM = "ai-km";
    private static final String SUCCESS = "success";
    private static final String ERRORS = "errors";
    private static final String BIZAPP = "bizapp";
    private static final String BIZUNIT = "bizunit";
    private static final String BOS_DEVPORTAL_UNITRELFORM = "bos_devportal_unitrelform";
    private static final String UnitID_KM = "4NSVJKC9SPK4";
    private static final String UnitID_AIKM = "4TDIWEKF5+07";
    private static final String APPID_AIKM = "4MJZIAYJ1T0/";
    private static final String APPID_GAI = "3ACHGCGWU9MJ";
    private static final String ID_SEGMENTENTITY = "0RhH2YpTtnt2nJlSxe";
    private static final String ID_QAENTITY = "ZEomq4xkphzJ0xNGEe";
    private static final String ID_ASSOCIATEKNL = "GkD9rVF5jjgl1jaUx3";
    private static final String ParentID_KM = "4NX1I6743=Y9";
    private static final String ParentID_KM_QA = "4NCDEFLGH1EM";
    private static final String ParentID_KM_Group = "4NM3QW4=X0KY";
    private static final String BillListApID = "4MdZMJhcjqGC5Vz17C";
    private static final String ListGridViewID = "XznLeTy3M5";

    public static void upgrade(String number) {
        Map data = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (data.isEmpty()) {
            return;
        }
        DynamicObject first = (DynamicObject)data.values().iterator().next();
        KMManager kmManager = new KMManager(first.getLong("id"));
        KMDesignerData.modifyMetadata(kmManager.getKMEntityId(), (f, e) -> {
            List entitys = e.getEntitys();
            for (Entity entity : entitys) {
                if (!(entity instanceof SubEntryEntity) || !entity.getKey().equals("subentryentity") || !StringUtils.isBlank((CharSequence)entity.getTableName())) continue;
                entity.setTableName("t_" + e.getKey() + "_index");
            }
        });
    }

    public static void modify(String number, boolean isRight, LocaleString caption) {
        Map data = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (data != null && !data.isEmpty()) {
            DynamicObject first = (DynamicObject)data.values().iterator().next();
            String kmgroupentityid = first.getString("kmgroupentityid");
            KMDesignerData.modifyMetadata(kmgroupentityid, (formMetadata, entityMetadata) -> {
                entityMetadata.getRootEntity().getPermissionControl().setControlFunction(isRight);
                if (!isRight) {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_NULL", "");
                } else {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_ORG", "createorg");
                }
            });
            String kmentityid = first.getString("kmentityid");
            KMDesignerData.modifyMetadata(kmentityid, (formMetadata, entityMetadata) -> {
                entityMetadata.getRootEntity().getPermissionControl().setControlFunction(isRight);
                if (!isRight) {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_NULL", "");
                } else {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_ORG", "org");
                }
                formMetadata.setName(caption);
                BillFormAp rootAp = (BillFormAp)formMetadata.getRootAp();
                rootAp.getListMeta().setName(caption);
                entityMetadata.setName(caption);
            });
            String kmqaentityid = first.getString("kmqaentityid");
            KMDesignerData.modifyMetadata(kmqaentityid, (formMetadata, entityMetadata) -> {
                entityMetadata.getRootEntity().getPermissionControl().setControlFunction(isRight);
                if (!isRight) {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_NULL", "");
                } else {
                    KMDesignerData.setPermissionDimension(entityMetadata, "DIM_ORG", "org");
                }
                formMetadata.setName(caption);
                BillFormAp rootAp = (BillFormAp)formMetadata.getRootAp();
                rootAp.getListMeta().setName(caption);
                entityMetadata.setName(caption);
            });
        }
    }

    private static void setPermissionDimension(EntityMetadata entityMetadata, String dimension, String fieldKey) {
        PermissionDimension permissionDimension = entityMetadata.getRootEntity().getPermissionDimension();
        permissionDimension.setDimension(dimension);
        if (StringUtils.isNotBlank((CharSequence)fieldKey)) {
            String id = entityMetadata.getFieldByKey(fieldKey).getId();
            permissionDimension.setDataDimension(id);
            permissionDimension.setDataDimensionField(fieldKey);
        } else {
            permissionDimension.setDataDimension("");
            permissionDimension.setDataDimensionField("");
        }
    }

    public static Map<String, String> save(String number, ILocaleString name, boolean isRight, boolean orgIsolate, String orgFunc) {
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMDesignerData_2", (String)AI_KM, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)name.getLocaleValue())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMDesignerData_3", (String)AI_KM, (Object[])new Object[0]));
        }
        number = "aikm_" + number;
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        if (id != null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"KMDesignerData_4", (String)AI_KM, (Object[])new Object[0]));
        }
        String groupIdEntityId = null;
        String kmEntityId = null;
        String kmqaEntityId = null;
        try {
            String final_GroupId = groupIdEntityId = KMDesignerData.createNewMeta(number + "_group", (ILocaleString)new LocaleString(String.format(ResManager.loadKDString((String)"%s\u5206\u7ec4", (String)"KMDesignerData_1", (String)AI_KM, (Object[])new Object[0]), name)), "BaseFormModel", APPID_GAI, UnitID_AIKM, ParentID_KM_Group, o -> {
                EntityMetadata entityMetadata = o.getEntityMetadata();
                entityMetadata.getRootEntity().setTableName("t_" + entityMetadata.getKey());
                if (!isRight) {
                    entityMetadata.getRootEntity().getPermissionDimension().setDataDimension("DIM_NULL");
                    entityMetadata.getRootEntity().getPermissionControl().setControlFunction(false);
                }
            });
            String final_kmqaEntityId = kmqaEntityId = KMDesignerData.createNewMeta(number + "_qa", (ILocaleString)new LocaleString(name + "QA"), "KMModel", APPID_GAI, UnitID_AIKM, ParentID_KM_QA, o -> {
                EntityMetadata entityMetadata = o.getEntityMetadata();
                KMDesignerData.initEntityMeta(entityMetadata, final_GroupId, isRight, orgFunc);
                AttachmentField attachment = (AttachmentField)entityMetadata.getFieldByKey("attachment");
                attachment.setTableName("t_" + entityMetadata.getKey() + "a");
            });
            String finalKmEntityId = kmEntityId = KMDesignerData.createNewMeta(number, name, "KMModel", APPID_GAI, UnitID_AIKM, ParentID_KM, o -> {
                EntityMetadata entityMetadata = o.getEntityMetadata();
                KMDesignerData.initEntityMeta(entityMetadata, final_GroupId, isRight, orgFunc);
                List entitys = entityMetadata.getEntitys();
                for (Entity entity : entitys) {
                    if (!(entity instanceof SubEntryEntity) || !entity.getKey().equals("subentryentity")) continue;
                    entity.setTableName("t_" + entityMetadata.getKey() + "_index");
                }
                BillListAp item = (BillListAp)o.getItem(BillListApID);
                item.setEntityId(final_kmqaEntityId);
                ListColumnAp listColumnAp_Q = new ListColumnAp();
                listColumnAp_Q.setId(ID.genStringId());
                listColumnAp_Q.setKey("listq");
                listColumnAp_Q.setParentId(ListGridViewID);
                listColumnAp_Q.setName(new LocaleString(ResManager.loadKDString((String)"\u95ee\u9898", (String)"KMDesignerData_5", (String)AI_KM, (Object[])new Object[0])));
                listColumnAp_Q.setListFieldId("question");
                listColumnAp_Q.setHyperlink(true);
                o.getItems().add(listColumnAp_Q);
                ListColumnAp listColumnAp_A = new ListColumnAp();
                listColumnAp_A.setId(ID.genStringId());
                listColumnAp_A.setKey("lista");
                listColumnAp_A.setParentId(ListGridViewID);
                listColumnAp_A.setName(new LocaleString(ResManager.loadKDString((String)"\u7b54\u6848", (String)"KMDesignerData_6", (String)AI_KM, (Object[])new Object[0])));
                listColumnAp_A.setListFieldId("answer");
                o.getItems().add(listColumnAp_A);
                ListColumnAp listColumnAp_Status = new ListColumnAp();
                listColumnAp_Status.setId(ID.genStringId());
                listColumnAp_Status.setKey("liststatus");
                listColumnAp_Status.setParentId(ListGridViewID);
                listColumnAp_Status.setName(new LocaleString(ResManager.loadKDString((String)"\u72b6\u6001", (String)"KMDesignerData_7", (String)AI_KM, (Object[])new Object[0])));
                listColumnAp_Status.setListFieldId("status");
                o.getItems().add(listColumnAp_Status);
            });
            KMDesignerData.modifyMetadata(kmqaEntityId, (formMeta, entityMeta) -> {
                BasedataField basedataField = (BasedataField)entityMeta.getItemById(ID_ASSOCIATEKNL);
                basedataField.setBaseEntityId(finalKmEntityId);
            });
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("km", kmEntityId);
            result.put("kmqa", kmqaEntityId);
            result.put("group", groupIdEntityId);
            return result;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            KMDesignerData.deleteFormMetadataIfNotNull(kmqaEntityId);
            KMDesignerData.deleteFormMetadataIfNotNull(kmEntityId);
            KMDesignerData.deleteFormMetadataIfNotNull(groupIdEntityId);
            if (e instanceof KDBizException) {
                throw (KDBizException)e;
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8c03\u7528\u94fe\u3002%s", (String)"KMDesignerData_0", (String)AI_KM, (Object[])new Object[0]), e.getMessage()));
        }
    }

    public static Map<String, Object> deleteFormMetadataIfNotNull(String formID) {
        if (formID != null) {
            return MetadataDao.delFormMetadata((String)formID);
        }
        return Collections.emptyMap();
    }

    private static void initEntityMeta(EntityMetadata entityMetadata, String groupEntityId, boolean isRight, String orgFunc) {
        EntryEntity entryEntity = entityMetadata.getEntryById(ID_SEGMENTENTITY);
        String tableName = "t_" + entityMetadata.getKey();
        entryEntity.setTableName(tableName + "seq");
        entityMetadata.getRootEntity().setTableName(tableName);
        if (!isRight) {
            entityMetadata.getRootEntity().getPermissionDimension().setDimension("DIM_NULL");
            entityMetadata.getRootEntity().getPermissionControl().setControlFunction(false);
        }
        BasedataField group = (BasedataField)entityMetadata.getFieldByKey("group");
        group.setBaseEntityId(groupEntityId);
        if (StringUtils.isNotBlank((CharSequence)orgFunc)) {
            OrgField org = (OrgField)entityMetadata.getFieldByKey("org");
            org.setOrgFuncs(orgFunc);
        }
    }

    private static void modifyMetadata(String id, BiConsumer<FormMetadata, EntityMetadata> consumer) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)id, (MetaCategory)MetaCategory.Entity);
        formMetadata.bindEntityMetadata(entityMetadata);
        consumer.accept(formMetadata, entityMetadata);
        new KMCommonDesignerData().save(formMetadata.buildDesignMeta("zh_CN"));
    }

    private static String createNewMeta(String number, ILocaleString name, String modelType, String bizAppId, String bizUnitId, String parentId, Consumer<FormMetadata> consumer) {
        EntityItem entityItem;
        KMCommonDesignerData designerData = new KMCommonDesignerData();
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("id", number);
        params.put("name", (String)name);
        params.put("modelType", modelType);
        params.put("bizappid", bizAppId);
        params.put("parentId", parentId);
        FormMetadata formMetadata = designerData.createBlankMetadata(params);
        formMetadata.setIsv("kingdee");
        formMetadata.getEntityMetadata().setIsv("kingdee");
        List items = formMetadata.getEntityMetadata().getItems();
        if ("BaseFormModel".equals(modelType) && items != null && !items.isEmpty() && "8oq6R4m9CF".equals((entityItem = (EntityItem)items.get(items.size() - 1)).getId())) {
            items.remove(items.size() - 1);
        }
        if (!formMetadata.getItems().isEmpty() && formMetadata.getItems().get(0) instanceof FormAp) {
            FormAp rootAp = (FormAp)formMetadata.getItems().get(0);
            KMDesignerData.initializeJsPlugin(rootAp);
        }
        consumer.accept(formMetadata);
        Map content = formMetadata.buildDesignMeta("zh_CN");
        Map save = designerData.save(content);
        if (save.get(SUCCESS) != null && !((Boolean)save.get(SUCCESS)).booleanValue() && save.get(ERRORS) != null) {
            throw new KDBizException(((ErrorInfo)((ArrayList)save.get(ERRORS)).get(0)).getError());
        }
        String formId = formMetadata.getId();
        DynamicObject dObject = BusinessDataServiceHelper.newDynamicObject((String)BOS_DEVPORTAL_UNITRELFORM);
        dObject.set(BIZAPP, (Object)bizAppId);
        dObject.set(BIZUNIT, (Object)bizUnitId);
        dObject.set("form", (Object)formId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObject});
        return formId;
    }

    private static void initializeJsPlugin(FormAp rootAp) {
        try {
            Method initializeJsPlugin = FormAp.class.getDeclaredMethod("initializeJsPlugin", new Class[0]);
            initializeJsPlugin.setAccessible(true);
            initializeJsPlugin.invoke((Object)rootAp, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    static class KMCommonDesignerData
    extends DesignerData {
        KMCommonDesignerData() {
        }

        protected Map<String, Object> checkIsv(Map<String, Object> content, AbstractMetadata metadata, String currentIsv) {
            return null;
        }
    }
}

