/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.base.qa;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.base.qa.ExcelParserData;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelParserTool {
    public static ExcelParserData parse(InputStream in, String type) throws IOException {
        Workbook workBook = ExcelParserTool.getWorkbook(in, type);
        DataFormatter formatter = new DataFormatter();
        return ExcelParserTool.excelParse(formatter, workBook);
    }

    private static ExcelParserData excelParse(DataFormatter formatter, Workbook workbook) {
        JSONObject data = new JSONObject();
        HashMap<Integer, String> sheets = new HashMap<Integer, String>();
        ExcelParserData excelParserData = new ExcelParserData();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            boolean isSheetHidden = workbook.isSheetHidden(i);
            if (isSheetHidden) continue;
            sheets.put(i, workbook.getSheetName(i));
            int rowNumbers = sheet.getPhysicalNumberOfRows();
            if (rowNumbers <= 0) continue;
            JSONObject jsonSheetData = new JSONObject();
            Map<String, String> mergeCellRelation = ExcelParserTool.getMergeCellRelation(sheet, formatter);
            for (Row row : sheet) {
                if (row.getZeroHeight()) continue;
                JSONObject rowJson = new JSONObject(true);
                for (Cell cell : row) {
                    String cellValue;
                    if (sheet.isColumnHidden(cell.getColumnIndex()) || !StringUtils.isNotBlank((CharSequence)(cellValue = ExcelParserTool.getCellValue(cell, formatter, mergeCellRelation)))) continue;
                    rowJson.put(String.valueOf(cell.getColumnIndex()), (Object)cellValue);
                }
                if (rowJson.isEmpty()) continue;
                jsonSheetData.put(String.valueOf(row.getRowNum()), (Object)rowJson);
            }
            if (jsonSheetData.isEmpty()) continue;
            data.put(String.valueOf(i), (Object)jsonSheetData);
        }
        excelParserData.setData(data);
        excelParserData.setSheetNames(sheets);
        return excelParserData;
    }

    private static Workbook getWorkbook(InputStream in, String type) throws IOException {
        if ("xls".equals(type)) {
            return new HSSFWorkbook(in);
        }
        return new XSSFWorkbook(in);
    }

    private static Map<String, String> getMergeCellRelation(Sheet sheet, DataFormatter formatter) {
        List mergedRegions = sheet.getMergedRegions();
        if (CollectionUtils.isEmpty((Collection)mergedRegions)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> mergeCellRelation = new HashMap<String, String>(16);
        for (CellRangeAddress mergedRegion : mergedRegions) {
            int firstRow = mergedRegion.getFirstRow();
            int firstColumn = mergedRegion.getFirstColumn();
            String mergeRegionValue = formatter.formatCellValue(sheet.getRow(firstRow).getCell(firstColumn));
            int lastRow = mergedRegion.getLastRow();
            int lastColumn = mergedRegion.getLastColumn();
            for (int r = firstRow; r <= lastRow; ++r) {
                Row row = sheet.getRow(r);
                for (int c = firstColumn; c <= lastColumn; ++c) {
                    Cell cell = row.getCell(c);
                    mergeCellRelation.put(cell.getAddress().toString(), mergeRegionValue);
                }
            }
        }
        return mergeCellRelation;
    }

    private static String getCellValue(Cell cell, DataFormatter formatter, Map<String, String> mergeCellRelation) {
        String cellValue = formatter.formatCellValue(cell);
        if (mergeCellRelation.isEmpty()) {
            return cellValue;
        }
        String address = cell.getAddress().toString();
        if (StringUtils.isBlank((CharSequence)cellValue) && mergeCellRelation.containsKey(address)) {
            return mergeCellRelation.get(address);
        }
        return cellValue;
    }
}

