/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.km.base.KMDesignerData;
import kd.ai.km.management.model.ImageParam;
import kd.ai.km.management.model.KnowledgeCodeGenerator;
import kd.ai.km.management.model.PermAssign;
import kd.ai.km.management.model.PermData;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.servicehelper.AIServiceProxy;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMCreateFormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final Logger log = LoggerFactory.getLogger(KMCreateFormPlugin.class);
    private static final String SYSTEM = "ai-km";
    private static final String FOLDERPATH_FORM_NUMBER = "kmcreate";
    private static final String KNOWLEDGE_SCHEME_ENTITY_NUMBER = "aikm_repo_scheme";
    private static final String CACHE_KEY_PREFIX = "programme_images_cache";
    private static final String MANAGER_ENTITY = "aikm_knl_manager";
    private static final String SCHEME_ENTITY = "aikm_repo_scheme";
    private static final int PERM_USER_LIMIT = 100;
    private static final int PERM_ROLE_LIMIT = 100;
    private static final String CALLBACK_MANAGE_SCHEME = "callBackManagwScheme";
    private static final Gson gson = new Gson();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "programmelist"});
        ((Search)this.getControl("programme_search")).addEnterListener((SearchEnterListener)this);
        ((CardEntry)this.getControl("programme_entryentity")).addRowClickListener((RowClickEventListener)this);
        EntryGrid entry = (EntryGrid)this.getControl("programme_entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
        this.addAfterPermF7SelectListener();
    }

    public void afterCreateNewData(EventObject e) {
        this.initProgrammeConfig();
        this.searchProgrammeData(null);
        long currUserId = RequestContext.get().getCurrUserId();
        this.getModel().setValue("perm_admin_user", (Object)Collections.singletonList(currUserId).toArray());
    }

    public void afterBindData(EventObject e) {
        this.lockEdit();
        this.selectFirstRow();
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        this.lockEdit();
        this.searchProgrammeData(searchEnterEvent.getText());
    }

    public void entryRowClick(RowClickEvent evt) {
        this.unlockEdit();
        this.handleImageForSelectedProgramme(evt.getRow());
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("programme_name".equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            Object currentProgrammeId = this.getModel().getValue("programme_id", rowIndex);
            BillShowParameter bsp = new BillShowParameter();
            bsp.setFormId("aikm_repo_scheme");
            bsp.setPkId(currentProgrammeId);
            bsp.setBillStatus(BillOperationStatus.VIEW);
            bsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key) && !this.validateProggrammeMustInput()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u914d\u7f6e\u65b9\u6848\u5f02\u5e38\uff0c\u8bf7\u70b9\u51fb\u3010+\u3011\u8fdb\u5165\u77e5\u8bc6\u5e93\u65b9\u6848\u914d\u7f6e\uff0c\u68c0\u67e5\u5e76\u5b8c\u5584\u5fc5\u586b\u9879\u3002", (String)"KMCreateFormPlugin_7", (String)SYSTEM, (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            String key = ((Button)source).getKey();
            if ("btnok".equals(key)) {
                try {
                    this.handleFormSubmission();
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u521b\u5efa\u77e5\u8bc6\u5e93\u6210\u529f\u3002", (String)"KMCreateFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                    this.getView().sendFormAction(this.getView().getParentView());
                    this.getView().close();
                }
                catch (KDBizException e) {
                    this.getView().showTipNotification(e.getMessage());
                }
                catch (Exception e) {
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else if ("programmelist".equals(key)) {
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId("aikm_repo_scheme");
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_MANAGE_SCHEME));
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("enable_perm".equals(e.getProperty().getName())) {
            this.handlePermissionToggle(e.getChangeSet()[0]);
            return;
        }
        if ("knowledge_name".equals(e.getProperty().getName())) {
            this.handleImageForInputKnowledgeName(e.getChangeSet()[0]);
            this.handleGenerateKnowledgeCode(e.getChangeSet()[0]);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (CALLBACK_MANAGE_SCHEME.equals(actionId)) {
            this.searchProgrammeData(null);
        }
    }

    private void handleFormSubmission() {
        this.validateProgrammeSelect();
        this.validateKnowledgeNumber();
        HashMap<String, String> entityIds = new HashMap(3);
        boolean createConfig = false;
        Long managerId = -1L;
        try {
            entityIds = this.createKnowledgeBaseEntities();
            this.configureKnowledgeBase(entityIds);
            createConfig = true;
            managerId = this.saveKnowledgeBaseManager(entityIds);
            this.assignPermToKnowledgeEntity(managerId);
        }
        catch (Throwable e) {
            log.error("handleFormSubmission error, {}", (Object)e.getMessage());
            String kmEntityId = (String)entityIds.get("km");
            String kmqaEntityId = (String)entityIds.get("kmqa");
            String groupEntity = (String)entityIds.get("group");
            if (createConfig) {
                String kmEntityNumber = MetadataDao.getNumberById((String)kmEntityId);
                String kmqaEntityNumber = MetadataDao.getNumberById((String)kmqaEntityId);
                DeleteServiceHelper.delete((String)"bos_knl_kmconfig", (QFilter[])new QFilter("kmformid", "=", (Object)kmqaEntityNumber).toArray());
                DeleteServiceHelper.delete((String)"bos_knl_kmconfig", (QFilter[])new QFilter("kmformid", "=", (Object)kmEntityNumber).toArray());
            }
            if (managerId > 0L) {
                DeleteServiceHelper.delete((String)MANAGER_ENTITY, (QFilter[])new QFilter("number", "=", this.getModel().getValue("knowledge_number")).toArray());
            }
            KMDesignerData.deleteFormMetadataIfNotNull(kmqaEntityId);
            KMDesignerData.deleteFormMetadataIfNotNull(kmEntityId);
            KMDesignerData.deleteFormMetadataIfNotNull(groupEntity);
            throw new RuntimeException(e);
        }
    }

    private void validateProgrammeSelect() {
        int[] selectRows = ((CardEntry)this.getControl("programme_entryentity")).getSelectRows();
        if (selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u77e5\u8bc6\u5e93\u65b9\u6848\u3002", (String)"KMCreateFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
        }
    }

    private void validateKnowledgeNumber() {
        String number = this.getModel().getValue("knowledge_number").toString();
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMCreateFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]));
        }
        if (number.length() > 12) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc712\u4f4d\u3002", (String)"KMCreateFormPlugin_3", (String)SYSTEM, (Object[])new Object[0]));
        }
        if (!number.matches("^[a-z0-9]+$")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u7f16\u7801\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u3002", (String)"KMCreateFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]));
        }
    }

    private Map<String, String> createKnowledgeBaseEntities() {
        return KMDesignerData.save(this.getModel().getValue("knowledge_number").toString(), (ILocaleString)this.getModel().getValue("knowledge_name"), (Boolean)this.getModel().getValue("enable_perm"), false, null);
    }

    private void configureKnowledgeBase(Map<String, String> entityIds) {
        int[] selectRows = ((CardEntry)this.getControl("programme_entryentity")).getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        Object programmeId = this.getModel().getValue("programme_id", selectRows[0]);
        MainEntityType schemeEntityType = EntityMetadataCache.getDataEntityType((String)"aikm_repo_scheme");
        DynamicObject[] schemeEntityDataArr = BusinessDataServiceHelper.load((Object[])new Object[]{programmeId}, (DynamicObjectType)schemeEntityType);
        if (schemeEntityDataArr.length == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u65b9\u6848\u6570\u636e\u3002", (String)"KMCreateFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]));
        }
        DynamicObject schemeEntityData = schemeEntityDataArr[0];
        MainEntityType configType = EntityMetadataCache.getDataEntityType((String)"bos_knl_kmconfig");
        DynamicObject[] configs = new DynamicObject[]{this.createKnowledgeConfig(configType, MetadataDao.getNumberById((String)entityIds.get("km")), schemeEntityData), this.createKnowledgeConfig(configType, MetadataDao.getNumberById((String)entityIds.get("kmqa")), schemeEntityData)};
        SaveServiceHelper.save((DynamicObject[])configs);
    }

    private DynamicObject createKnowledgeConfig(MainEntityType configType, String formId, DynamicObject schemeData) {
        DynamicObject config = new DynamicObject((DynamicObjectType)configType);
        for (IDataEntityProperty property : schemeData.getDataEntityType().getProperties()) {
            if (!configType.getProperties().containsKey((Object)property.getName()) || !(property instanceof ISimpleProperty)) continue;
            config.set(property.getName(), schemeData.get(property.getName()));
        }
        config.set("id", (Object)ID.genLongId());
        config.set("number", (Object)formId);
        config.set("name", this.getModel().getValue("knowledge_name"));
        config.set("kmformid", (Object)formId);
        config.set("description", this.getModel().getValue("knowledge_desc"));
        config.set("status", (Object)"A");
        config.set("filetype", (Object)"word,pdf");
        return config;
    }

    private Long saveKnowledgeBaseManager(Map<String, String> entityIds) {
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY);
        DynamicObject managerData = new DynamicObject((DynamicObjectType)managerType);
        this.setBasicManagerInfo(managerData, entityIds);
        this.setManagerPermissions(managerData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{managerData});
        return (Long)managerData.getPkValue();
    }

    private void setBasicManagerInfo(DynamicObject managerData, Map<String, String> entityIds) {
        long pkId = ID.genLongId();
        managerData.set("id", (Object)pkId);
        managerData.set("masterid", (Object)pkId);
        managerData.set("ctrlstrategy", (Object)"5");
        managerData.set("picturefield", this.getModel().getValue("knowledge_image"));
        managerData.set("name", this.getModel().getValue("knowledge_name"));
        managerData.set("number", this.getModel().getValue("knowledge_number"));
        managerData.set("desc", this.getModel().getValue("knowledge_desc"));
        managerData.set("creator", (Object)RequestContext.get().getCurrUserId());
        managerData.set("createorg", this.getView().getFormShowParameter().getCustomParam("createorg"));
        managerData.set("group", this.getModel().getValue("knowledge_group"));
        managerData.set("status", (Object)"C");
        managerData.set("enable", (Object)"1");
        managerData.set("kmentityid", (Object)entityIds.get("km"));
        managerData.set("kmqaentityid", (Object)entityIds.get("kmqa"));
        managerData.set("kmgroupentityid", (Object)entityIds.get("group"));
    }

    private void setManagerPermissions(DynamicObject managerData) {
        int authorizeStatus;
        PermData permData = PermData.fromModel(this.getModel());
        boolean enablePerm = (Boolean)this.getModel().getValue("enable_perm");
        int n = authorizeStatus = enablePerm ? 2 : 0;
        if (authorizeStatus == 2 && permData.isAllEmpty()) {
            authorizeStatus = 1;
        }
        managerData.set("authorizestatus", (Object)authorizeStatus);
        if (enablePerm) {
            managerData.set("adminuser_tag", (Object)PermData.convertToString(permData.getAdminUsers()));
            managerData.set("adminrole_tag", (Object)PermData.convertToString(permData.getAdminRoles()));
            managerData.set("edituser_tag", (Object)PermData.convertToString(permData.getEditUsers()));
            managerData.set("editrole_tag", (Object)PermData.convertToString(permData.getEditRoles()));
            managerData.set("audituser_tag", (Object)PermData.convertToString(permData.getAuditUsers()));
            managerData.set("auditrole_tag", (Object)PermData.convertToString(permData.getAuditRoles()));
            managerData.set("viewuser_tag", (Object)PermData.convertToString(permData.getViewUsers()));
            managerData.set("viewrole_tag", (Object)PermData.convertToString(permData.getViewRoles()));
        }
    }

    private void assignPermToKnowledgeEntity(Long managerId) {
        Object enablePerm = this.getModel().getValue("enable_perm");
        if (enablePerm instanceof Boolean && !((Boolean)enablePerm).booleanValue()) {
            return;
        }
        MainEntityType managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY);
        DynamicObject managerData = BusinessDataServiceHelper.loadSingle((Object)managerId, (DynamicObjectType)managerType);
        if (managerData == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u5e93\u7ba1\u7406\u6570\u636e\u3002", (String)"KMCreateFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]));
        }
        String kmEntityNum = MetadataDao.getNumberById((String)managerData.get("kmentityid").toString());
        String kmqaEntityNum = MetadataDao.getNumberById((String)managerData.get("kmqaentityid").toString());
        List<String> entityIds = Arrays.asList(kmEntityNum, kmqaEntityNum);
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                PermData permData = PermData.fromModel(this.getModel());
                EnumMap<PermAssign.PermItemType, List> userPermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                userPermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminUsers());
                userPermMap.put(PermAssign.PermItemType.EDIT, permData.getEditUsers());
                userPermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditUsers());
                userPermMap.put(PermAssign.PermItemType.VIEW, permData.getViewUsers());
                userPermMap.forEach((permType, users) -> PermAssign.unAssignUser(entityIds, users));
                userPermMap.forEach((permType, users) -> PermAssign.assignUser(entityIds, users, permType));
                EnumMap<PermAssign.PermItemType, List> rolePermMap = new EnumMap<PermAssign.PermItemType, List>(PermAssign.PermItemType.class);
                rolePermMap.put(PermAssign.PermItemType.ADMIN, permData.getAdminRoles());
                rolePermMap.put(PermAssign.PermItemType.EDIT, permData.getEditRoles());
                rolePermMap.put(PermAssign.PermItemType.AUDIT, permData.getAuditRoles());
                rolePermMap.put(PermAssign.PermItemType.VIEW, permData.getViewRoles());
                rolePermMap.forEach((permType, roles) -> PermAssign.unAssignRole(entityIds, roles));
                rolePermMap.forEach((permType, roles) -> PermAssign.assignRole(entityIds, roles, permType));
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw new RuntimeException(e);
            }
        }
    }

    private void handleImageForSelectedProgramme(int row) {
        String programmeName = (String)this.getModel().getValue("programme_name", row);
        Optional<String> cachedImage = this.getImageFromCache(programmeName);
        if (cachedImage.isPresent()) {
            this.getModel().setValue("knowledge_image", (Object)cachedImage.get());
            return;
        }
        Optional<String> images = ImageParam.createImages(programmeName, FOLDERPATH_FORM_NUMBER);
        images.ifPresent(imagePath -> {
            this.saveImageToCache(programmeName, (String)imagePath);
            this.getModel().setValue("knowledge_image", imagePath);
        });
    }

    private void handleImageForInputKnowledgeName(ChangeData changeData) {
        Object knowledgeName = changeData.getNewValue();
        if (knowledgeName instanceof LocaleDynamicObjectCollection && ((LocaleDynamicObjectCollection)knowledgeName).size() > 0) {
            Optional<String> images = ImageParam.createImages(this.getModel().getValue("knowledge_name").toString(), FOLDERPATH_FORM_NUMBER);
            images.ifPresent(imagePath -> this.getModel().setValue("knowledge_image", imagePath));
        }
    }

    private void handleGenerateKnowledgeCode(ChangeData changeData) {
        Object knowledgeName = changeData.getNewValue();
        if (knowledgeName instanceof LocaleDynamicObjectCollection && ((LocaleDynamicObjectCollection)knowledgeName).size() > 0) {
            String name = this.getModel().getValue("knowledge_name").toString();
            if (name == null || name.trim().isEmpty()) {
                return;
            }
            String knowledgeCode = KnowledgeCodeGenerator.generateKnowledgeCode(name);
            this.getModel().setValue("knowledge_number", (Object)knowledgeCode);
        }
    }

    private Optional<String> getImageFromCache(String programmeName) {
        String cacheContent = this.getPageCache().get(CACHE_KEY_PREFIX);
        if (StringUtils.isEmpty((CharSequence)cacheContent)) {
            return Optional.empty();
        }
        try {
            Map imageMap = (Map)gson.fromJson(cacheContent, new TypeToken<HashMap<String, String>>(){}.getType());
            return Optional.ofNullable(imageMap.get(programmeName));
        }
        catch (Exception e) {
            log.error("Failed to deserialize image cache: cache_key={}, error={}", new Object[]{CACHE_KEY_PREFIX, e.getMessage(), e});
            return Optional.empty();
        }
    }

    private void saveImageToCache(String programmeName, String imagePath) {
        Map<String, String> imageMap;
        String cacheContent = this.getPageCache().get(CACHE_KEY_PREFIX);
        if (StringUtils.isEmpty((CharSequence)cacheContent)) {
            imageMap = new HashMap<String, String>();
        } else {
            try {
                imageMap = (Map)gson.fromJson(cacheContent, new TypeToken<HashMap<String, String>>(){}.getType());
            }
            catch (Exception e) {
                log.error("Failed to deserialize image cache while saving: cache_key={}, error={}", new Object[]{CACHE_KEY_PREFIX, e.getMessage(), e});
                imageMap = new HashMap();
            }
        }
        imageMap.put(programmeName, imagePath);
        this.getPageCache().put(CACHE_KEY_PREFIX, gson.toJson(imageMap));
    }

    private Set<String> getAllCachedImagePaths() {
        String cacheContent = this.getPageCache().get(CACHE_KEY_PREFIX);
        if (StringUtils.isEmpty((CharSequence)cacheContent)) {
            return Collections.emptySet();
        }
        try {
            Map imageMap = (Map)gson.fromJson(cacheContent, new TypeToken<HashMap<String, String>>(){}.getType());
            return new HashSet<String>(imageMap.values());
        }
        catch (Exception e) {
            log.error("Failed to get all cached image paths: cache_key={}, error={}", new Object[]{CACHE_KEY_PREFIX, e.getMessage(), e});
            return Collections.emptySet();
        }
    }

    private void handlePermissionToggle(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        if (newValue instanceof Boolean) {
            this.getView().setVisible((Boolean)newValue, new String[]{"perm_admin_user", "perm_admin_role", "perm_edit_user", "perm_edit_role", "perm_audit_user", "perm_audit_role", "perm_view_user", "perm_view_role"});
        }
    }

    private void lockEdit() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"flexpanelap_right"});
    }

    private void unlockEdit() {
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"flexpanelap_right"});
    }

    private void selectFirstRow() {
        int size;
        Object entryData = this.getModel().getValue("programme_entryentity");
        if (entryData instanceof DynamicObjectCollection && (size = ((DynamicObjectCollection)entryData).size()) > 0) {
            ((CardEntry)this.getControl("programme_entryentity")).selectRows(0);
            this.unlockEdit();
        }
    }

    private void searchProgrammeData(String programmeName) {
        Map result;
        this.getModel().deleteEntryData("programme_entryentity");
        if (StringUtils.isNotBlank((CharSequence)programmeName)) {
            QFilter qFilter = new QFilter("name", "like", (Object)("%" + programmeName + "%"));
            result = BusinessDataServiceHelper.loadFromCache((String)"aikm_repo_scheme", (String)"name, description,modifytime", (QFilter[])qFilter.toArray());
        } else {
            result = BusinessDataServiceHelper.loadFromCache((String)"aikm_repo_scheme", (String)"name, description,modifytime", null);
        }
        if (MapUtils.isEmpty((Map)result)) {
            return;
        }
        this.populateProgrammeEntries(result);
        this.getView().updateView("programme_entryentity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateProgrammeEntries(Map<Object, DynamicObject> result) {
        this.getModel().batchCreateNewEntryRow("programme_entryentity", result.size());
        List sortedSchemas = result.values().stream().sorted(Comparator.comparing(schema -> schema.getDate("modifytime"), Comparator.nullsLast(Comparator.reverseOrder()))).collect(Collectors.toList());
        int index = 0;
        for (DynamicObject dynamicObject : sortedSchemas) {
            try {
                ILocaleString name = dynamicObject.getLocaleString("name");
                String description = dynamicObject.getString("description");
                this.getModel().setValue("programme_id", dynamicObject.getPkValue(), index);
                this.getModel().setValue("programme_name", (Object)name, index);
                this.getModel().setValue("programme_desc", (Object)description, index);
            }
            finally {
                ++index;
            }
        }
    }

    private void initProgrammeConfig() {
        this.getModel().setValue("knowledge_group", this.getView().getFormShowParameter().getCustomParam("group"));
    }

    private void addAfterPermF7SelectListener() {
        String fieldType = ResManager.loadKDString((String)"\u7528\u6237", (String)"KMEditFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_user", fieldType, 100);
        this.validatePermCount("perm_edit_user", fieldType, 100);
        this.validatePermCount("perm_audit_user", fieldType, 100);
        this.validatePermCount("perm_view_user", fieldType, 100);
        fieldType = ResManager.loadKDString((String)"\u89d2\u8272", (String)"KMEditFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]);
        this.validatePermCount("perm_admin_role", fieldType, 100);
        this.validatePermCount("perm_edit_role", fieldType, 100);
        this.validatePermCount("perm_audit_role", fieldType, 100);
        this.validatePermCount("perm_view_role", fieldType, 100);
    }

    private void validatePermCount(String field, String type, int limit) {
        MulBasedataEdit permUser = (MulBasedataEdit)this.getControl(field);
        String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u9009%1$s\u6570\u91cf\u8d85\u8fc7\u9650\u5236\uff0c\u5c06\u53ea\u4fdd\u7559\u524d%2$s\u4e2a\u3002", (String)"KMEditFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]), type, limit);
        permUser.addAfterF7SelectListener(evt -> {
            ListSelectedRowCollection col = evt.getListSelectedRowCollection();
            if (col.size() > limit) {
                this.getView().showTipNotification(msg);
                this.getModel().setValue(field, (Object)col.stream().limit(5L).map(ListSelectedRow::getPrimaryKeyValue).toArray());
            }
        });
    }

    private boolean validateProggrammeMustInput() {
        Object proggrammeId = this.getModel().getValue("programme_id", this.getModel().getEntryCurrentRowIndex("programme_entryentity"));
        DynamicObject proggramme = QueryServiceHelper.queryOne((String)"aikm_repo_scheme", (String)"indexmethod,q,qa,chunksize", (QFilter[])new QFilter[]{new QFilter("id", "=", proggrammeId)});
        if (proggramme == null) {
            return false;
        }
        String indexMethod = proggramme.getString("indexmethod");
        if (!this.validateEmbeddingModelAvailable(indexMethod)) {
            return false;
        }
        String qa = proggramme.getString("qa");
        String q = proggramme.getString("q");
        int chunkSize = proggramme.getInt("chunksize");
        return !StringUtils.isBlank((CharSequence)indexMethod) && (!"0".equals(qa) || !"0".equals(q)) && chunkSize > 0;
    }

    private boolean validateEmbeddingModelAvailable(String embeddingModelNumber) {
        EmbeddingModel[] values = EmbeddingModel.values();
        Set modelNumbers = Arrays.stream(values).map(Enum::name).collect(Collectors.toSet());
        if (!modelNumbers.contains(embeddingModelNumber)) {
            return false;
        }
        List instanceList = (List)AIServiceProxy.invokeAICCServiceMethod((String)"AiccService", (String)"queryInstance", (Object[])new Object[]{null, null, null});
        if (null == instanceList || instanceList.isEmpty()) {
            return false;
        }
        Set instanceNumbers = instanceList.stream().map(map -> (String)map.get("service.number")).collect(Collectors.toSet());
        return instanceNumbers.contains(embeddingModelNumber);
    }

    private static final class Fields {
        static final String PROGRAMME_SEARCH = "programme_search";
        static final String PROGRAMME_ENTRYENTITY = "programme_entryentity";
        static final String PROGRAMME_ID = "programme_id";
        static final String PROGRAMME_NAME = "programme_name";
        static final String PROGRAMME_DESC = "programme_desc";
        static final String KNOWLEDGE_NAME = "knowledge_name";
        static final String KNOWLEDGE_NUMBER = "knowledge_number";
        static final String KNOWLEDGE_DESC = "knowledge_desc";
        static final String KNOWLEDGE_GROUP = "knowledge_group";
        static final String KNOWLEDGE_IMAGE = "knowledge_image";

        private Fields() {
        }
    }
}

