/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMMigrationFormPlugin
extends AbstractFormPlugin {
    private static final String BOS_GTPAS_QA = "bos-gptas-qa";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"run"});
        BasedataEdit gaikm = (BasedataEdit)this.getControl("gaikm");
        gaikm.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent evt) {
                ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
                formShowParameter.setShowApproved(false);
            }
        });
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        if (btn.getKey().equals("run")) {
            DynamicObject gaikm = (DynamicObject)this.getModel().getValue("gaikm");
            DynamicObject commonkm = (DynamicObject)this.getModel().getValue("commonkm");
            MainEntityType kmDataEntityType = KMMigrationFormPlugin.getKMGroupDataEntityType(commonkm.getString("id"));
            Long defaultGroupId = KMMigrationFormPlugin.getDefaultGroupId(kmDataEntityType);
            if (defaultGroupId == -1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u77e5\u8bc6\u5e93\u6ca1\u6709\u5206\u7ec4\uff0c\u8bf7\u81f3\u5c11\u521b\u5efa\u4e00\u4e2a\u5206\u7ec4\u3002", (String)"KMMigrationFormPlugin_3", (String)BOS_GTPAS_QA, (Object[])new Object[0]));
            }
            RunnerTask.startTask(this, "runner", gaikm.getLong("id"), commonkm.getLong("id"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if ("runner".equals(actionId) && (returnData = evt.getReturnData()) instanceof Map) {
            Map returnDataMap = (Map)returnData;
            if (!returnDataMap.containsKey("taskinfo")) {
                return;
            }
            String taskInfoStr = (String)returnDataMap.get("taskinfo");
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            int finishTaskCount = KMMigrationFormPlugin.getFinishTaskCount(taskInfo);
            if (finishTaskCount >= 0) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u5b8c\u6210\u3002\u5171\u5bfc\u5165%s\u7bc7\u6587\u7ae0\u3002", (String)"KMMigrationFormPlugin_1", (String)BOS_GTPAS_QA, (Object[])new Object[0]), finishTaskCount));
            }
        }
    }

    private static Long getDefaultGroupId(MainEntityType groupEntityType) {
        List id = QueryServiceHelper.queryPrimaryKeys((String)groupEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)}, (String)"id", (int)1);
        if (id.isEmpty()) {
            return -1L;
        }
        return (Long)id.get(0);
    }

    private static MainEntityType getKMDataEntityType(String kmid) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"aikm_knl_manager");
        Map map = BusinessDataReader.loadFromCache((Object[])new Object[]{Long.parseLong(kmid)}, (DynamicObjectType)dataEntityType);
        DynamicObject data = (DynamicObject)map.values().iterator().next();
        String kminstanceId = data.getString("kmentityid");
        String number = MetadataDao.getNumberById((String)kminstanceId);
        return EntityMetadataCache.getDataEntityType((String)number);
    }

    private static MainEntityType getKMGroupDataEntityType(String kmid) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"aikm_knl_manager");
        Map map = BusinessDataReader.loadFromCache((Object[])new Object[]{Long.parseLong(kmid)}, (DynamicObjectType)dataEntityType);
        DynamicObject data = (DynamicObject)map.values().iterator().next();
        String kminstanceId = data.getString("kmgroupentityid");
        String number = MetadataDao.getNumberById((String)kminstanceId);
        return EntityMetadataCache.getDataEntityType((String)number);
    }

    private static int getFinishTaskCount(TaskInfo taskInfo) {
        int count;
        if (StringUtils.isNotBlank((CharSequence)taskInfo.getData())) {
            Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
            count = Integer.parseInt(String.valueOf(data.get("cnt")));
        } else {
            count = -1;
        }
        return count;
    }

    public static class RunnerTaskClick
    extends AbstractTaskClick {
        public void click(ClickEventArgs e) {
            TaskInfo taskInfo = this.queryTask();
            if (taskInfo.isFailure()) {
                e.setClearTask(true);
                return;
            }
            IFormView parentView = this.getParentView();
            int count = KMMigrationFormPlugin.getFinishTaskCount(taskInfo);
            if (taskInfo.isTaskEnd()) {
                String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5df2\u5b8c\u6210\u3002\u5171\u5bfc\u5165%s\u7bc7\u6587\u7ae0\u3002", (String)"KMMigrationFormPlugin_1", (String)KMMigrationFormPlugin.BOS_GTPAS_QA, (Object[])new Object[0]);
                if (parentView == null) {
                    this.getMainView().showSuccessNotification(String.format(msg, count));
                } else {
                    parentView.showSuccessNotification(String.format(msg, count));
                    this.getMainView().sendFormAction(parentView);
                }
                e.setClearTask(true);
            } else if (parentView != null) {
                this.showProgressForm(parentView);
            }
        }

        private void showProgressForm(IFormView view) {
            if (this.isExistProgressForm()) {
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
                showParameter.setCaption(this.getJobFormInfo().getCaption());
            }
            showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
            String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
            showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
            view.showForm(showParameter);
            this.getMainView().sendFormAction(view);
            this.setProgressPageId(showParameter.getPageId());
        }
    }

    public static class RunnerTask
    extends AbstractTask {
        public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
            String gaiid = (String)map.get("gaiid");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_info");
            DynamicObject data = BusinessDataReader.loadSingle((Object)Long.parseLong(gaiid), (DynamicObjectType)dataEntityType);
            String kmid = (String)map.get("kmid");
            MainEntityType KMDataEntityType = KMMigrationFormPlugin.getKMDataEntityType(kmid);
            DynamicObjectCollection doc_manage = data.getDynamicObjectCollection("doc_manage");
            Object[] ids = new Object[doc_manage.size()];
            int i = 0;
            for (DynamicObject row : doc_manage) {
                long id = row.getLong("id");
                ids[i++] = id;
            }
            List exitsIds = QueryServiceHelper.queryPrimaryKeys((String)KMDataEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, (String)"id", (int)ids.length);
            HashSet existSet = new HashSet(exitsIds);
            ArrayList<DynamicObject> notExistsDoc = new ArrayList<DynamicObject>(16);
            for (DynamicObject row : doc_manage) {
                if (existSet.contains(row.get("id"))) continue;
                notExistsDoc.add(row);
            }
            if (notExistsDoc.isEmpty()) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("cnt", "0");
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u65e0\u5f85\u8fc1\u79fb\u6570\u636e\u3002", (String)"KMMigrationFormPlugin_4", (String)KMMigrationFormPlugin.BOS_GTPAS_QA, (Object[])new Object[0]), result);
                this.feedbackCustomdata(result);
                return;
            }
            Long groupId = KMMigrationFormPlugin.getDefaultGroupId(KMMigrationFormPlugin.getKMGroupDataEntityType(kmid));
            int count = 1;
            this.feedbackProgress(5, String.format(ResManager.loadKDString((String)"\u542f\u52a8\u5bfc\u5165,\u603b\u5171%s\u4e2a\u6587\u4ef6\u5f85\u8fc1\u79fb\u3002", (String)"KMMigrationFormPlugin_2", (String)KMMigrationFormPlugin.BOS_GTPAS_QA, (Object[])new Object[0]), notExistsDoc.size()), new HashMap());
            for (DynamicObject row : notExistsDoc) {
                this.feedbackProgress(5 + count * 95 / notExistsDoc.size(), "\u6b63\u5728\u8fc1\u79fb\u7b2c" + count + " \u4e2a\u6587\u4ef6,\u5269\u4f59" + (notExistsDoc.size() - count) + "\u4e2a\u6587\u4ef6\u5f85\u8fc1\u79fb\u3002", new HashMap());
                long id = row.getLong("id");
                DynamicObject newRow = new DynamicObject((DynamicObjectType)KMDataEntityType);
                newRow.set("id", (Object)id);
                newRow.set("number", (Object)("doc-" + id));
                String fileName = row.getString("file_name");
                newRow.set("name", (Object)fileName);
                if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
                    newRow.set("type", (Object)"excel");
                } else {
                    newRow.set("type", (Object)"common");
                }
                newRow.set("status", (Object)"A");
                newRow.set("group_id", (Object)groupId);
                newRow.set("org_id", data.get("useorg_id"));
                this.saveAttachmentInfo(KMDataEntityType.getName(), fileName, id, row.getString("file_path"), row.getLong("file_size"));
                StringBuilder content = new StringBuilder();
                try (DataSet chunkDatas = QueryServiceHelper.queryDataSet((String)"gai_text_chunk", (String)"gai_text_chunk", (String)"content_tag", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)Long.parseLong(gaiid)), new QFilter("fileid", "=", (Object)row.getLong("id"))}, (String)"order");){
                    DynamicObjectCollection rows = newRow.getDynamicObjectCollection("segmententity");
                    int seq = 1;
                    for (Row chunkData : chunkDatas) {
                        DynamicObject newSegRow = rows.addNew();
                        newSegRow.set("seq", (Object)seq++);
                        newSegRow.set("segment_tag", (Object)chunkData.getString("content_tag"));
                        newSegRow.set("creatway", (Object)"1");
                        newSegRow.set("segmenttype", (Object)"TEXT");
                        content.append(chunkData.getString("content_tag"));
                    }
                }
                newRow.set("inputcontent_tag", (Object)content.toString());
                SaveServiceHelper.save((IDataEntityType)KMDataEntityType, (Object[])new Object[]{newRow});
                ++count;
                this.checkIsStop();
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("cnt", count);
            this.feedbackCustomdata(result);
        }

        private void saveAttachmentInfo(String entityNumber, String fileName, Long knlPkId, String filePath, long size) {
            HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
            attachmentMap.put("name", fileName);
            attachmentMap.put("entityNum", entityNumber);
            attachmentMap.put("billPkId", knlPkId);
            attachmentMap.put("size", size);
            attachmentMap.put("status", "success");
            attachmentMap.put("lastModified", new Date().getTime());
            attachmentMap.put("url", filePath);
            AttachmentServiceHelper.upload((String)entityNumber, (Object)knlPkId, (String)"attachmentpanelap", Collections.singletonList(attachmentMap));
        }

        public static void startTask(AbstractFormPlugin plugin, String actionId, long gaiid, long kmid) {
            JobInfo jobInfo = new JobInfo();
            jobInfo.setAppId("bos");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setName(new LocaleString("KMMigrationRunnerTask").toString());
            jobInfo.setId(UUID.randomUUID().toString());
            jobInfo.setTaskClassname(RunnerTask.class.getName());
            jobInfo.setCanStop(Boolean.valueOf(true));
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            HashMap<String, String> params = new HashMap<String, String>(16);
            params.put("gaiid", String.valueOf(gaiid));
            params.put("kmid", String.valueOf(kmid));
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, actionId);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8fc1\u79fb\u4e2d", (String)"KMMigrationFormPlugin_0", (String)KMMigrationFormPlugin.BOS_GTPAS_QA, (Object[])new Object[0]));
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setClickClassName(RunnerTaskClick.class.getName());
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)plugin.getView());
        }
    }
}

