/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.km.utils.AppParameterUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public class UpgradeKMEntityPlugin
extends AbstractFormPlugin {
    private static final String SYSTEM_TYPE = "ai-km";
    private static final String CALLBACK_TASK_UPGREADE_KMENTITY = "taskUpgradeKmEntity";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btncancel", "btnok", "viewap"});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                this.upgradeEntity();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "viewap": {
                this.getView().openUrl("https://developer.kingdee.com/knowledge/690228071403767296");
            }
        }
    }

    private void upgradeEntity() {
        TaskInfo taskInfo = null;
        String cacheKey = CacheKeyUtil.getAcctId() + ".aikm_UpgradeKMEntityTask";
        if (cache.contains(cacheKey)) {
            String taskId = (String)cache.get(cacheKey);
            taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        }
        if (taskInfo == null || taskInfo.getStatus() == null || taskInfo.isTaskEnd()) {
            boolean needCompareVersion = this.getView().getFormShowParameter().getCustomParams().containsKey("needcompareversion");
            Map<String, Object> result = AppParameterUtils.getAppParam();
            int knlVersion = (Integer)result.get("knlversion");
            if (!needCompareVersion || knlVersion < 4) {
                this.startAddFieldTask();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u5df2\u7ecf\u5347\u7ea7\uff0c\u65e0\u9700\u518d\u5347\u7ea7\u3002", (String)"UpgradeKMEntityPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
                this.getView().close();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u6b63\u5728\u5347\u7ea7\u4e2d\u3002", (String)"UpgradeKMEntityPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(5000));
        }
    }

    private void startAddFieldTask() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String entityNumber = (String)fsp.getCustomParam("entityNumber");
        String appId = (String)fsp.getCustomParam("appid");
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        LocaleString jobName = new LocaleString(fsp.getFormConfig().getCaption().getLocaleValue());
        jobInfo.setName(jobName.toString());
        jobInfo.setNumber(entityNumber + "_adCol4KMEntity_Job");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.km.management.UpgradeKMEntityTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put("entityNumber", entityNumber);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack("kd.ai.km.management.UpgradeKMEntityPlugin", CALLBACK_TASK_UPGREADE_KMENTITY);
        IFormView parentView = this.getView().getParentView();
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"UpgradeKMEntityPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(false);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.ai.km.management.UpgradeKMEntityTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)parentView);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }
}

