/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.LLMService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGenQATask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(BatchGenQATask.class);
    private static final String SYSTEM_TYPE = "ai-km";
    private static final int DEFAULT_TOKEN_LIMIT = 4000;
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("GenQACache", new DistributeCacheHAPolicy(true, true));

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Map existData;
        HashMap<String, Object> returnData = new HashMap<String, Object>(3);
        this.checkIsStop();
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"KMGenQAFormTask_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), null);
        String prompt = (String)map.get("prompt");
        returnData.put("prompt", prompt);
        String entityNumber = (String)map.get("entityNumber");
        List ids = (List)map.get("ids");
        int genCount = 5;
        Object genCountParam = map.get("genCount");
        if (genCountParam != null) {
            genCount = Integer.parseInt(genCountParam.toString());
        }
        String pageId = (String)map.get("pageId");
        boolean isContinueGen = map.containsKey("isContinueGen");
        String securityPrompt = (String)map.get("securityPrompt");
        String msg = ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\u7b2c%1$s/%2$s\u4efd\u77e5\u8bc6\uff1a%3$s", (String)"KMGenQAFormTask_1", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        HashMap<String, List<Map<String, Object>>> data = new HashMap<String, List<Map<String, Object>>>(1);
        String existDataStr = (String)cache.get(pageId);
        if (StringUtils.isNotBlank((CharSequence)existDataStr) && (existData = (Map)SerializationUtils.fromJsonString((String)existDataStr, Map.class)) != null && !existData.isEmpty()) {
            data.putAll(existData);
        }
        List<GenQAContent> contentDatas = this.getContentListByKnlId(entityNumber, ids);
        int progressCount = 1;
        int successCount = 0;
        ArrayList<String> errorInfos = new ArrayList<String>(10);
        int fileCount = ids.size();
        while (progressCount <= fileCount) {
            this.checkIsStop();
            int progressPercent = 10 + 80 * progressCount / fileCount;
            this.feedbackProgress(progressPercent, String.format(msg, progressCount, fileCount, ResManager.loadKDString((String)"\u83b7\u53d6\u95ee\u7b54", (String)"KMGenQAFormTask_2", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
            GenQAContent contentData = contentDatas.get(progressCount - 1);
            Object pk = contentData.getKnlId();
            String subject = contentData.getKnlName();
            Object groupId = contentData.getGroupId();
            ++progressCount;
            long startTime = new Date().getTime();
            try {
                List<Map<String, Object>> qaList = this.getGenQAList(entityNumber, prompt, contentData, genCount, securityPrompt, isContinueGen, (List)data.get(pk.toString()));
                long currentTime = new Date().getTime();
                long timeCost = currentTime - startTime;
                log.info("GenQA time cost:{}", (Object)timeCost);
                this.feedbackProgress(progressPercent, String.format(msg, progressCount - 1, fileCount, ResManager.loadKDString((String)"\u6682\u5b58\u95ee\u7b54", (String)"KMGenQAFormTask_3", (String)SYSTEM_TYPE, (Object[])new Object[0])), null);
                if (!qaList.isEmpty()) {
                    qaList.forEach(q -> q.put("groupId", groupId));
                }
                if (data.containsKey(pk.toString())) {
                    qaList.addAll((Collection)data.get(pk.toString()));
                }
                data.put(pk.toString(), qaList);
                ++successCount;
            }
            catch (KDException e) {
                long stopCost = new Date().getTime() - startTime;
                log.info("Stop gen cost:{}", (Object)stopCost);
                throw e;
            }
            catch (Exception e) {
                errorInfos.add(subject + ":" + e.getMessage());
                log.error(subject + " GenQA error:", (Throwable)e);
            }
        }
        cache.put(pageId, (Object)SerializationUtils.toJsonString(data));
        if (successCount > 0) {
            returnData.put("success", "true");
        } else {
            returnData.put("success", "false");
        }
        returnData.put("fileCount", fileCount);
        returnData.put("genCount", genCount);
        returnData.put("successCount", successCount);
        returnData.put("errorInfos", SerializationUtils.toJsonString(errorInfos));
        returnData.put("securityPrompt", securityPrompt);
        returnData.put("lastConfigs", map.get("lastConfigs"));
        this.feedbackCustomdata(returnData);
    }

    private String getFinalPrompt(String prompt, String entityNumber, String subject, String article, String securityPrompt, int genCount, boolean isContinueGen, List<Map<String, Object>> existQAList) {
        StringBuilder finalPrompt = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)securityPrompt)) {
            finalPrompt.append(securityPrompt).append("\n");
        }
        finalPrompt.append(prompt);
        finalPrompt.append(isContinueGen ? this.getContinueGenQAPrompt() : this.getFirstGenQAPrompt());
        String finalPromptContent = finalPrompt.toString();
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        int chunkSize = splitConfig.getChunkSize() != 0 ? splitConfig.getChunkSize() : 200;
        finalPromptContent = finalPromptContent.replace("{{content}}", article);
        if (isContinueGen) {
            finalPromptContent = finalPromptContent.replace("{{existQA}}", this.formatExistQAList(existQAList));
        }
        finalPromptContent = finalPromptContent.replace("{{subject}}", subject);
        finalPromptContent = finalPromptContent.replace("{{chunkSize}}", chunkSize + "");
        finalPromptContent = finalPromptContent.replace("{{count}}", genCount + "");
        return finalPromptContent;
    }

    private String getFirstGenQAPrompt() {
        String builder = "\n\u8bf7\u6839\u636e\u6587\u7ae0\u5185\u5bb9\uff0c\u751f\u6210\u5173\u4e8e<<{{subject}}>>\u7684\u95ee\u7b54\u5bf9\u3002\n# \u8f93\u51fa\u8981\u6c42:\n\u4e25\u683c\u6309\u7167\u4ee5 `[{\"question\":?,\"answer\":?}]` \u7684json\u5217\u8868\u683c\u5f0f\u8f93\u51fa\u7ed3\u679c\u3002question\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7{{chunkSize}}\u5b57\u3002\n\u82e5\u6307\u5b9a\u4e86\u751f\u6210\u6570\u91cf\uff0c\u5219\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u6570\u91cf\u8f93\u51fa\uff0c\u82e5\u6587\u6863\u5185\u5bb9\u4e0d\u8db3\u4ee5\u76f4\u63a5\u63d0\u53d6\u8db3\u591f\u7684\u95ee\u9898\uff0c\u8bf7\u5408\u7406\u6269\u5c55\u6216\u4e3e\u4f8b\u3002\n\n# \u6587\u7ae0\u5185\u5bb9:\n {{content}}";
        return builder;
    }

    private String getContinueGenQAPrompt() {
        String builder = "\n\u8bf7\u6839\u636e\u6587\u7ae0\u5185\u5bb9\u4ee5\u53ca\u5df2\u6709\u95ee\u7b54\u5bf9\uff0c\u751f\u6210\u5173\u4e8e<<{{subject}}>>\u7684\u95ee\u7b54\u5bf9\u3002\n# \u8f93\u51fa\u8981\u6c42:\n\u4e25\u683c\u6309\u7167\u4ee5 `[{\"question\":?,\"answer\":?}]` \u7684json\u5217\u8868\u683c\u5f0f\u8f93\u51fa\u7ed3\u679c\u3002question\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7{{chunkSize}}\u5b57\u3002\n\u751f\u6210\u7684\u95ee\u7b54\u5bf9\u4e0d\u80fd\u4e0e\u5df2\u6709\u95ee\u7b54\u5bf9\u91cd\u590d\u3002\n\n# \u6587\u7ae0\u5185\u5bb9:\n {{content}}\n\n#\u5df2\u6709\u95ee\u7b54\u5bf9:\n {{existQA}}";
        return builder;
    }

    private String formatExistQAList(List<Map<String, Object>> existQAList) {
        StringBuilder sb = new StringBuilder();
        if (existQAList == null || existQAList.isEmpty()) {
            return sb.toString();
        }
        int index = 1;
        for (Map<String, Object> qa : existQAList) {
            sb.append("Q").append(index).append("\uff1a").append(qa.get("question")).append("\n");
            sb.append("A").append(index).append("\uff1a").append(qa.get("answer")).append("\n\n");
            ++index;
        }
        return sb.toString();
    }

    private String getSeparator(String entityNumber) {
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        String separators = splitConfig.getSeparators();
        String defaultSeparators = "\n";
        if (StringUtils.isBlank((CharSequence)separators)) {
            return defaultSeparators;
        }
        String[] separatorArray = separators.split(",");
        if (separatorArray.length > 0 && StringUtils.isNotBlank((CharSequence)separatorArray[0])) {
            return separatorArray[0];
        }
        return defaultSeparators;
    }

    private List<GenQAContent> getContentListByKnlId(String entityNumber, List<Long> knlIds) {
        DynamicObject[] knlDatas = BusinessDataServiceHelper.load((String)entityNumber, (String)"id,name,inputcontent_tag,segmententity,segmententity.segment_tag,group.id", (QFilter[])new QFilter[]{new QFilter("id", "in", knlIds)});
        if (knlDatas == null || knlDatas.length == 0) {
            return new ArrayList<GenQAContent>(0);
        }
        ArrayList<GenQAContent> result = new ArrayList<GenQAContent>(knlDatas.length);
        for (DynamicObject knlData : knlDatas) {
            GenQAContent contentObj = new GenQAContent();
            contentObj.setKnlId(knlData.get("id"));
            contentObj.setKnlName(knlData.getString("name"));
            contentObj.setGroupId(knlData.getLong("group.id"));
            String content = knlData.getString("inputcontent_tag");
            if (content.length() > 4000) {
                List<String> chunks = knlData.getDynamicObjectCollection("segmententity").stream().map(s -> s.getString("segment_tag")).collect(Collectors.toList());
                contentObj.setContent(this.getChunks(entityNumber, chunks));
            } else {
                contentObj.setContent(Collections.singletonList(content));
            }
            result.add(contentObj);
        }
        return result;
    }

    private List<String> getChunks(String entityNumber, List<String> chunkContents) {
        String separator = this.getSeparator(entityNumber);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (String chunkContent : chunkContents) {
            int extraLength;
            if (chunkContent == null) {
                chunkContent = "";
            }
            int n = extraLength = current.length() == 0 ? chunkContent.length() : separator.length() + chunkContent.length();
            if (current.length() + extraLength > 4000) {
                result.add(current.toString());
                current = new StringBuilder(chunkContent);
                continue;
            }
            if (current.length() > 0) {
                current.append(separator);
            }
            current.append(chunkContent);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    private List<Map<String, Object>> getGenQAList(String entityNumber, String prompt, GenQAContent contentObj, int genCount, String securityPrompt, boolean isContinueGen, List<Map<String, Object>> existQAList) throws Exception {
        List<String> knlContents = contentObj.getContent();
        if (CollectionUtils.isEmpty(knlContents)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        String subject = contentObj.getKnlName();
        int[] genCounts = BatchGenQATask.distributeQA(genCount, knlContents.size());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int seq = 0;
        for (String knlContent : knlContents) {
            List qaList;
            this.checkIsStop();
            if (seq >= genCount) break;
            int currentSeq = seq;
            List<Map<String, Object>> existParaQAList = existQAList;
            if (existQAList != null && !existQAList.isEmpty()) {
                existParaQAList = existQAList.stream().filter(qa -> Objects.equals(currentSeq, qa.get("seq"))).collect(Collectors.toList());
            }
            String finalPrompt = this.getFinalPrompt(prompt, entityNumber, subject, knlContent, securityPrompt, genCounts[seq], isContinueGen, existParaQAList);
            String content = LLMService.create().syncLLM(finalPrompt, new HashMap(0));
            if (StringUtils.isBlank((CharSequence)content)) {
                throw new Exception(ResManager.loadKDString((String)"\u751f\u6210\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6a21\u578b\u670d\u52a1\u540e\u91cd\u8bd5\u3002", (String)"KMGenQAFormTask_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            content = content.replace("```json", "").replace("```", "");
            log.info("GenQA result content:" + content);
            try {
                qaList = SerializationUtils.fromJsonStringToList((String)content, Map.class);
                qaList.forEach(qa -> qa.put("seq", currentSeq));
            }
            catch (Exception e) {
                throw new Exception(ResManager.loadKDString((String)"\u751f\u6210\u95ee\u7b54\u5bf9\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMGenQAFormTask_4", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            result.addAll(qaList);
            ++seq;
        }
        return result;
    }

    public static int[] distributeQA(int genCount, int paraCount) {
        int[] counts = new int[paraCount];
        if (genCount <= paraCount) {
            for (int i = 0; i < genCount; ++i) {
                counts[i] = 1;
            }
            return counts;
        }
        int base = genCount / paraCount;
        int remainder = genCount % paraCount;
        for (int i = 0; i < paraCount; ++i) {
            counts[i] = base + (i < remainder ? 1 : 0);
        }
        return counts;
    }

    private static class GenQAContent {
        private Object knlId;
        private String knlName;
        private List<String> content;
        private Object groupId;

        public Object getKnlId() {
            return this.knlId;
        }

        public void setKnlId(Object knlId) {
            this.knlId = knlId;
        }

        public String getKnlName() {
            return this.knlName;
        }

        public void setKnlName(String knlName) {
            this.knlName = knlName;
        }

        public List<String> getContent() {
            return this.content;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }

        public Object getGroupId() {
            return this.groupId;
        }

        public void setGroupId(Object groupId) {
            this.groupId = groupId;
        }
    }
}

