/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.management.genqa.model.KMGenQAConfig;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.utils.IFrameUtil;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class KMGenQAConfigFormPlugin
extends AbstractFormPlugin
implements ListboxClickListener,
TabSelectListener {
    private static final String SYSTEM = "ai-km";
    private static final String BTN_PROMPT = "btn_prompt";
    private static final String BTN_CONFIG = "btn_config";
    private static final String BTN_GENERATE = "btngenqa";
    private static final String BTN_RESET = "btn_reset";
    private static final String BTN_SHOW_SCHEME = "btn_showscheme";
    private static final String CONTROL_SCENE_TYPE = "scenetype";
    private static final String CONTROL_TAB = "tabap";
    private static final String TAB_CONFIG = "tabconfigap";
    private static final String TAB_PROMPT = "tabpromptap";
    private static final String ENTRY_MODEL = "modelentry";
    private static final String PROP_COVERAGE_AREA = "coverarea";
    private static final String PROP_QUESTION_TYPE_CONCEPTUAL = "conceptual";
    private static final String PROP_QUESTION_TYPE_PROCEDURAL = "procedural";
    private static final String PROP_QUESTION_TYPE_CONTEXTUAL = "contextual";
    private static final String PROP_GEN_COUNT = "gencount";
    private static final String PROP_PROMPT = "prompt";
    private static final String PROP_MODEL_NAME = "modelname";
    private static final String PROP_MODEL_IMAGE = "modeimg";
    private static final String PROP_SAVE_SCHEME = "savescheme";
    private static final String FLEX_SCHEME_LIST = "schemelistap";
    private static final String PARAM_QA_ENTITY = "qaEntityNumber";
    private static final String PARAM_ENTITY_NUMBER = "entityNumber";
    private static final String CACHE_CUSTOM_PROMPT = "customPrompt";
    private static final String CACHE_SCENE_TYPE = "sceneType";
    private static final String CACHE_TEMPLATE_PROMPT = "templatePrompt";
    private static final String CACHE_CHUNK_SIZE = "chunkSize";
    private static final String CALLBACK_TASK_GEN_QA = "taskGenQA";
    private static final String CALLBACK_SELECT_TAB_CONFIG = "selectTabConfig";
    private static final String CALLBACK_RESET_PROMPT = "resetPrompt";
    private static final String IMAGE_URL_MODE_BRIEF = "/kingdee/gptas/images/pc/aikm_genqa_config_brief.png";
    private static final String IMAGE_URL_MODE_STEP = "/kingdee/gptas/images/pc/aikm_genqa_config_step.png";
    private static final String IMAGE_URL_MODE_EXAMPLE = "/kingdee/gptas/images/pc/aikm_genqa_config_example.png";
    private static final Log log = LogFactory.getLog(KMGenQAConfigFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_PROMPT, BTN_CONFIG, BTN_GENERATE, BTN_RESET, BTN_SHOW_SCHEME});
        Listbox box = (Listbox)this.getControl(CONTROL_SCENE_TYPE);
        box.addListboxClickListener((ListboxClickListener)this);
        Tab tab = (Tab)this.getControl(CONTROL_TAB);
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Listbox box = (Listbox)this.getControl(CONTROL_SCENE_TYPE);
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>(3);
        String sceneType1 = ResManager.loadKDString((String)"\u5236\u5ea6\u89e3\u8bfb", (String)"KMGenQAConfigFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]);
        String sceneType2 = ResManager.loadKDString((String)"\u4f7f\u7528\u573a\u666f", (String)"KMGenQAConfigFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]);
        String sceneType3 = ResManager.loadKDString((String)"\u64cd\u4f5c\u624b\u518c", (String)"KMGenQAConfigFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]);
        itemlist.add(new ListboxItem(sceneType1, sceneType1));
        itemlist.add(new ListboxItem(sceneType2, sceneType2));
        itemlist.add(new ListboxItem(sceneType3, sceneType3));
        box.addItems(itemlist);
        this.cacheTemplatePrompt();
        this.getPageCache().put(CACHE_SCENE_TYPE, sceneType1);
        this.loadContentModelCardEntry();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CONFIG});
    }

    public void afterBindData(EventObject e) {
        if (this.loadSchemeConfig()) {
            return;
        }
        EntryGrid modelEntry = (EntryGrid)this.getControl(ENTRY_MODEL);
        modelEntry.selectRows(0);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_SCHEME_LIST});
        this.loadLastConfig();
    }

    public void beforeClick(BeforeClickEvent evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_GENERATE.equals(key)) {
            this.buildPromptByConfig();
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (BTN_PROMPT.equals(key)) {
            Tab tab = (Tab)this.getControl(CONTROL_TAB);
            String currentTab = tab.getCurrentTab();
            if (TAB_CONFIG.equals(currentTab)) {
                tab.activeTab(TAB_PROMPT);
            }
        } else if (BTN_CONFIG.equals(key)) {
            Tab tab = (Tab)this.getControl(CONTROL_TAB);
            String currentTab = tab.getCurrentTab();
            if (!TAB_PROMPT.equals(currentTab)) {
                return;
            }
            String isCustomPrompt = this.getPageCache().get(CACHE_CUSTOM_PROMPT);
            if ("true".equals(isCustomPrompt)) {
                String msg = ResManager.loadKDString((String)"\u5207\u6362\u65b9\u6848\u4f1a\u6e05\u7a7a\u5f53\u524d\u7f16\u8f91\u5185\u5bb9\uff0c\u662f\u5426\u7ee7\u7eed\u5207\u6362\uff1f", (String)"KMGenQAConfigFormPlugin_3", (String)SYSTEM, (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_SELECT_TAB_CONFIG));
            } else {
                tab.activeTab(TAB_CONFIG);
            }
        } else if (BTN_GENERATE.equals(key)) {
            FormShowParameter fsp = this.getView().getFormShowParameter();
            List knlIds = (List)fsp.getCustomParam("knlIds");
            this.dispatchGenQATask(knlIds);
            this.saveScheme();
            this.getView().close();
        } else if (BTN_RESET.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u91cd\u7f6e\u914d\u7f6e\u5417\uff1f", (String)"KMGenQAConfigFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_RESET_PROMPT));
        } else if (BTN_SHOW_SCHEME.equals(key)) {
            String schemeVisible = this.getPageCache().get("schemeVisible");
            if ("true".equals(schemeVisible)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_SCHEME_LIST});
                this.getPageCache().remove("schemeVisible");
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_SCHEME_LIST});
                this.getPageCache().put("schemeVisible", "true");
            }
        }
    }

    public void listboxClick(ListboxEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Listbox) {
            String itemId = evt.getItemId();
            this.getPageCache().put(CACHE_SCENE_TYPE, itemId);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if (TAB_PROMPT.equals(tabKey)) {
            this.buildPromptByConfig();
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_CONFIG});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_PROMPT});
        } else if (TAB_CONFIG.equals(tabKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_CONFIG});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_PROMPT});
        }
        String schemeVisible = this.getPageCache().get("schemeVisible");
        if ("true".equals(schemeVisible)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_SCHEME_LIST});
            this.getPageCache().remove("schemeVisible");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (PROP_PROMPT.equals(propName)) {
            this.getPageCache().put(CACHE_CUSTOM_PROMPT, "true");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (CALLBACK_SELECT_TAB_CONFIG.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().remove(CACHE_CUSTOM_PROMPT);
            Tab tab = (Tab)this.getControl(CONTROL_TAB);
            tab.activeTab(TAB_CONFIG);
        } else if (CALLBACK_RESET_PROMPT.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getPageCache().remove(CACHE_CUSTOM_PROMPT);
            this.buildPromptByConfig();
        }
    }

    private void buildPromptByConfig() {
        Object contextual;
        Object procedural;
        if ("true".equals(this.getPageCache().get(CACHE_CUSTOM_PROMPT))) {
            return;
        }
        String prompt = this.cacheTemplatePrompt();
        if (StringUtils.isBlank((CharSequence)prompt)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u63d0\u793a\u8bcd\u6a21\u677f\u3002", (String)"KMGenQAConfigFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object subject = fsp.getCustomParam("subject");
        if (StringUtils.isNotBlank((Object)subject)) {
            prompt = prompt.replace("{{subject}}", subject.toString());
        }
        prompt = prompt.replace("{{chunkSize}}", this.getQAChunkSize());
        String sceneType = this.getPageCache().get(CACHE_SCENE_TYPE);
        if (StringUtils.isNotBlank((CharSequence)sceneType)) {
            prompt = prompt.replace("{{scene}}", sceneType);
        }
        prompt = prompt.replace("{{field}}", this.getModel().getValue(PROP_COVERAGE_AREA).toString());
        ArrayList<String> questionType = new ArrayList<String>(3);
        Object conceptual = this.getModel().getValue(PROP_QUESTION_TYPE_CONCEPTUAL);
        if (Boolean.TRUE.equals(conceptual)) {
            questionType.add(((FieldEdit)this.getControl(PROP_QUESTION_TYPE_CONCEPTUAL)).getDisplayName().getLocaleValue());
        }
        if (Boolean.TRUE.equals(procedural = this.getModel().getValue(PROP_QUESTION_TYPE_PROCEDURAL))) {
            questionType.add(((FieldEdit)this.getControl(PROP_QUESTION_TYPE_PROCEDURAL)).getDisplayName().getLocaleValue());
        }
        if (Boolean.TRUE.equals(contextual = this.getModel().getValue(PROP_QUESTION_TYPE_CONTEXTUAL))) {
            questionType.add(((FieldEdit)this.getControl(PROP_QUESTION_TYPE_CONTEXTUAL)).getDisplayName().getLocaleValue());
        }
        prompt = prompt.replace("{{qtype}}", String.join((CharSequence)",", questionType));
        int selectedRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_MODEL);
        if (selectedRowIndex >= 0) {
            prompt = prompt.replace("{{format}}", this.getModel().getValue(PROP_MODEL_NAME, selectedRowIndex).toString());
        }
        this.getModel().beginInit();
        this.getModel().setValue(PROP_PROMPT, (Object)prompt);
        this.getView().updateView(PROP_PROMPT);
        this.getModel().endInit();
    }

    private String cacheTemplatePrompt() {
        String promptTpl = this.getPageCache().get(CACHE_TEMPLATE_PROMPT);
        if (StringUtils.isNotBlank((CharSequence)promptTpl)) {
            return promptTpl;
        }
        return this.getPrompt("GenQA.md");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getPrompt(String promptFileName) {
        try (InputStream stream = KMGenQAConfigFormPlugin.class.getResourceAsStream("/" + KMGenQAConfigFormPlugin.class.getPackage().getName().replace(".", "/") + "/prompt/" + promptFileName);){
            int i;
            if (stream == null) {
                String string = "";
                return string;
            }
            StringBuilder s = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((i = stream.read(buf, 0, buf.length)) != -1) {
                s.append(new String(buf, 0, i, StandardCharsets.UTF_8));
            }
            this.getPageCache().put(CACHE_TEMPLATE_PROMPT, s.toString());
            String string = s.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadContentModelCardEntry() {
        this.getModel().batchCreateNewEntryRow(ENTRY_MODEL, 3);
        this.getModel().setValue(PROP_MODEL_NAME, (Object)ResManager.loadKDString((String)"\u7b80\u660e\u627c\u8981", (String)"KMGenQAConfigFormPlugin_6", (String)SYSTEM, (Object[])new Object[0]), 0);
        this.getModel().setValue(PROP_MODEL_NAME, (Object)ResManager.loadKDString((String)"\u8be6\u7ec6\u6b65\u9aa4", (String)"KMGenQAConfigFormPlugin_7", (String)SYSTEM, (Object[])new Object[0]), 1);
        this.getModel().setValue(PROP_MODEL_NAME, (Object)ResManager.loadKDString((String)"\u4e3e\u4f8b\u8bf4\u660e", (String)"KMGenQAConfigFormPlugin_8", (String)SYSTEM, (Object[])new Object[0]), 2);
        this.getModel().setValue(PROP_MODEL_IMAGE, (Object)IFrameUtil.buildImageUrl((String)IMAGE_URL_MODE_BRIEF, (boolean)true), 0);
        this.getModel().setValue(PROP_MODEL_IMAGE, (Object)IFrameUtil.buildImageUrl((String)IMAGE_URL_MODE_STEP, (boolean)true), 1);
        this.getModel().setValue(PROP_MODEL_IMAGE, (Object)IFrameUtil.buildImageUrl((String)IMAGE_URL_MODE_EXAMPLE, (boolean)true), 2);
    }

    private void dispatchGenQATask(List<Long> knlIds) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object entityNumber = fsp.getCustomParam(PARAM_ENTITY_NUMBER);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber.toString());
        String appId = entityType.getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(entityType.getDisplayName().getLocaleValue());
        jobInfo.setNumber(entityNumber + "_genQAJob");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.km.management.genqa.BatchGenQATask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        IFormView parentView = this.getView().getParentView();
        String pageId = parentView.getPageId();
        params.put("pageId", pageId);
        params.put(PARAM_ENTITY_NUMBER, entityNumber);
        params.put(PROP_PROMPT, this.getModel().getValue(PROP_PROMPT));
        params.put("genCount", this.getModel().getValue(PROP_GEN_COUNT));
        params.put("ids", knlIds);
        params.put("securityPrompt", this.getPrompt("SecurityPrompt.md"));
        params.put("lastConfigs", SerializationUtils.toJsonString((Object)this.getConfigs()));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack(fsp.getCustomParam("callBackPlugin").toString(), CALLBACK_TASK_GEN_QA);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fdb\u5ea6", (String)"KMGenQAConfigFormPlugin_9", (String)SYSTEM, (Object[])new Object[0]));
        jobFormInfo.setCanBackground("true".equals(fsp.getCustomParam("canBackground")));
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.ai.km.management.genqa.BatchGenQATaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)parentView);
        this.getView().sendFormAction(parentView);
    }

    private String getQAChunkSize() {
        String chunkSize = this.getPageCache().get(CACHE_CHUNK_SIZE);
        if (StringUtils.isNotBlank((CharSequence)chunkSize)) {
            return chunkSize;
        }
        String QAEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_QA_ENTITY);
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(QAEntityNumber);
        chunkSize = splitConfig.getChunkSize() != 0 ? String.valueOf(splitConfig.getChunkSize()) : "200";
        return chunkSize;
    }

    private KMGenQAConfig getConfigs() {
        KMGenQAConfig config = new KMGenQAConfig();
        Tab tab = (Tab)this.getControl(CONTROL_TAB);
        String currentTab = tab.getCurrentTab();
        if (TAB_PROMPT.equals(currentTab)) {
            config.setPrompt(this.getModel().getValue(PROP_PROMPT).toString());
            return config;
        }
        String sceneType = this.getPageCache().get(CACHE_SCENE_TYPE);
        config.setSceneType(sceneType);
        config.setCoverArea(this.getModel().getValue(PROP_COVERAGE_AREA).toString());
        config.setConceptual(Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_CONCEPTUAL).toString()));
        config.setProcedural(Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_PROCEDURAL).toString()));
        config.setContextual(Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_CONTEXTUAL).toString()));
        config.setContentMode(this.getModel().getEntryCurrentRowIndex(ENTRY_MODEL));
        config.setGenCount(Integer.parseInt(this.getModel().getValue(PROP_GEN_COUNT).toString()));
        return config;
    }

    private void loadLastConfig() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams || customParams.isEmpty()) {
            return;
        }
        Object lastConfigInfo = customParams.get("lastConfigs");
        if (null == lastConfigInfo) {
            return;
        }
        KMGenQAConfig lastConfig = (KMGenQAConfig)SerializationUtils.fromJsonString((String)lastConfigInfo.toString(), KMGenQAConfig.class);
        this.loadConfig(lastConfig);
    }

    private boolean loadSchemeConfig() {
        KMGenQAConfig config;
        String loadConfigStr = this.getPageCache().get("loadConfig");
        if (StringUtils.isBlank((CharSequence)loadConfigStr)) {
            return false;
        }
        try {
            config = (KMGenQAConfig)SerializationUtils.fromJsonString((String)loadConfigStr, KMGenQAConfig.class);
        }
        catch (Exception e) {
            log.error("Config format is incorrect.");
            return false;
        }
        this.loadConfig(config);
        this.getPageCache().remove("loadConfig");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_SCHEME_LIST});
        this.getPageCache().remove("schemeVisible");
        return true;
    }

    private void loadConfig(KMGenQAConfig config) {
        Tab tab = (Tab)this.getControl(CONTROL_TAB);
        String prompt = config.getPrompt();
        if (StringUtils.isNotBlank((CharSequence)prompt)) {
            this.getPageCache().put(CACHE_CUSTOM_PROMPT, "true");
            this.getModel().setValue(PROP_PROMPT, (Object)prompt);
            tab.activeTab(TAB_PROMPT);
            return;
        }
        this.getPageCache().remove(CACHE_CUSTOM_PROMPT);
        Listbox listbox = (Listbox)this.getControl(CONTROL_SCENE_TYPE);
        listbox.activeItem(config.getSceneType());
        this.getModel().setValue(PROP_COVERAGE_AREA, (Object)config.getCoverArea());
        this.getView().updateView(PROP_COVERAGE_AREA);
        this.getModel().setValue(PROP_QUESTION_TYPE_CONCEPTUAL, (Object)config.isConceptual());
        this.getView().updateView(PROP_QUESTION_TYPE_CONCEPTUAL);
        this.getModel().setValue(PROP_QUESTION_TYPE_PROCEDURAL, (Object)config.isProcedural());
        this.getView().updateView(PROP_QUESTION_TYPE_PROCEDURAL);
        this.getModel().setValue(PROP_QUESTION_TYPE_CONTEXTUAL, (Object)config.isContextual());
        this.getView().updateView(PROP_QUESTION_TYPE_CONTEXTUAL);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_MODEL);
        entryGrid.selectRows(config.getContentMode());
        this.getModel().setValue(PROP_GEN_COUNT, (Object)config.getGenCount());
        this.getView().updateView(PROP_GEN_COUNT);
        this.getModel().setValue(PROP_SAVE_SCHEME, (Object)false);
        tab.activeTab(TAB_CONFIG);
    }

    private void saveScheme() {
        if (this.getModel().getValue(PROP_SAVE_SCHEME).equals(false)) {
            return;
        }
        DynamicObject config = BusinessDataServiceHelper.newDynamicObject((String)"aikm_genqa_scheme", (boolean)true, (OperateOption)OperateOption.create());
        Tab tab = (Tab)this.getControl(CONTROL_TAB);
        String currentTab = tab.getCurrentTab();
        String customPrompt = this.getPageCache().get(CACHE_CUSTOM_PROMPT);
        if (TAB_PROMPT.equals(currentTab) && StringUtils.isNotBlank((CharSequence)customPrompt)) {
            config.set(PROP_PROMPT, this.getModel().getValue(PROP_PROMPT));
            config.set("name", (Object)this.getSchemeName(true));
        } else {
            config.set(CONTROL_SCENE_TYPE, (Object)this.getPageCache().get(CACHE_SCENE_TYPE));
            config.set(PROP_COVERAGE_AREA, (Object)this.getModel().getValue(PROP_COVERAGE_AREA).toString());
            config.set(PROP_QUESTION_TYPE_CONCEPTUAL, (Object)Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_CONCEPTUAL).toString()));
            config.set(PROP_QUESTION_TYPE_PROCEDURAL, (Object)Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_PROCEDURAL).toString()));
            config.set(PROP_QUESTION_TYPE_CONTEXTUAL, (Object)Boolean.parseBoolean(this.getModel().getValue(PROP_QUESTION_TYPE_CONTEXTUAL).toString()));
            config.set("contentmodel", (Object)this.getModel().getEntryCurrentRowIndex(ENTRY_MODEL));
            config.set(PROP_GEN_COUNT, (Object)Integer.parseInt(this.getModel().getValue(PROP_GEN_COUNT).toString()));
            config.set("name", (Object)this.getSchemeName(false));
        }
        config.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{config});
    }

    private String getSchemeName(boolean isCustomPrompt) {
        if (isCustomPrompt) {
            return String.format(ResManager.loadKDString((String)"[\u63cf\u8ff0] \u81ea\u5b9a\u4e49\u63cf\u8ff0%s", (String)"KMGenQAConfigFormPlugin_10", (String)SYSTEM, (Object[])new Object[0]), new Date());
        }
        StringBuilder name = new StringBuilder();
        name.append(ResManager.loadKDString((String)"[\u914d\u7f6e]", (String)"KMGenQAConfigFormPlugin_11", (String)SYSTEM, (Object[])new Object[0])).append(" ");
        if (Boolean.TRUE.equals(this.getModel().getValue(PROP_QUESTION_TYPE_CONCEPTUAL))) {
            name.append(ResManager.loadKDString((String)"\u6982\u5ff5\u6027", (String)"KMGenQAConfigFormPlugin_12", (String)SYSTEM, (Object[])new Object[0]));
        } else if (Boolean.TRUE.equals(this.getModel().getValue(PROP_QUESTION_TYPE_PROCEDURAL))) {
            name.append(ResManager.loadKDString((String)"\u64cd\u4f5c\u6027", (String)"KMGenQAConfigFormPlugin_13", (String)SYSTEM, (Object[])new Object[0]));
        } else if (Boolean.TRUE.equals(this.getModel().getValue(PROP_QUESTION_TYPE_CONTEXTUAL))) {
            name.append(ResManager.loadKDString((String)"\u573a\u666f\u5316", (String)"KMGenQAConfigFormPlugin_14", (String)SYSTEM, (Object[])new Object[0]));
        }
        name.append(this.getPageCache().get(CACHE_SCENE_TYPE));
        return name.toString();
    }
}

