/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.genqa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.km.management.genqa.model.KMGenQAConfig;
import kd.ai.km.service.KMDataService;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;

public class KMGenQAResultFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String SYSTEM = "ai-km";
    private static final String CALLBACK_TASK_GEN_QA = "taskGenQA";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("GenQACache", new DistributeCacheHAPolicy(true, true));
    private static final String FLEX_KNL_AP = "knlap";
    private static final String PARAM_ENTITY_NUMBER = "entityNumber";
    private static final Log log = LogFactory.getLog(KMGenQAResultFormPlugin.class);

    public void registerListener(EventObject e) {
        EntryGrid knlEntry = (EntryGrid)this.getControl("knlentry");
        knlEntry.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"btnok", "continue_genqa", "btnreset"});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadQAResult("");
        DynamicObjectCollection qaEntry = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection knlEntry = this.getModel().getEntryEntity("knlentry");
        for (int i = 0; i < knlEntry.size(); ++i) {
            Object knlId = this.getModel().getValue("knlid", i);
            this.getModel().setValue("qacount", (Object)qaEntry.stream().filter(k -> k.getString("associateknlid").equals(knlId)).count(), i);
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object fileCount = fsp.getCustomParam("fileCount");
        if (null != fileCount && 1 == (Integer)fileCount) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEX_KNL_AP});
        }
        EntryGrid knlEntry = (EntryGrid)this.getControl("knlentry");
        knlEntry.selectRows(0);
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid source = (EntryGrid)evt.getSource();
        String key = source.getKey();
        if ("knlentry".equals(key)) {
            int rowIndex = evt.getRow();
            Object knlId = this.getModel().getValue("knlid", rowIndex);
            this.filterQAList(knlId.toString());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int currentKnlIndex;
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        if ("selectstatus".equals(propName) && (currentKnlIndex = this.getModel().getEntryCurrentRowIndex("knlentry")) != -1) {
            DynamicObject currentKnl = this.getModel().getEntryRowEntity("knlentry", currentKnlIndex);
            String knlId = currentKnl.getString("knlid");
            this.updateQACount(knlId, currentKnlIndex);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.saveQAKnl();
        } else if ("continue_genqa".equals(key)) {
            this.dispatchContinueGenQATask();
        } else if ("btnreset".equals(key)) {
            this.reopenConfigForm();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        cache.remove(this.getView().getFormShowParameter().getParentPageId());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (CALLBACK_TASK_GEN_QA.equals(actionId)) {
            int knlEntryRow = this.getModel().getEntryCurrentRowIndex("knlentry");
            knlEntryRow = Math.max(knlEntryRow, 0);
            this.loadQAResult(this.getModel().getValue("knlid", knlEntryRow).toString());
        }
    }

    private void loadQAResult(String knlId) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String parentPageId = fsp.getParentPageId();
        String resultStr = (String)cache.get(parentPageId);
        if (StringUtils.isBlank((CharSequence)resultStr)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u751f\u6210\u7684\u95ee\u7b54\u5bf9\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMGenQAResultFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
        }
        Map qaMap = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
        this.loadKnlList((String)fsp.getCustomParam("kmEntityNumber"), qaMap);
        this.loadAllQAList(qaMap);
        if (StringUtils.isNotBlank((CharSequence)knlId)) {
            this.filterQAList(knlId);
        } else {
            DynamicObject firstRow = this.getModel().getEntryRowEntity("knlentry", 0);
            this.filterQAList(firstRow.getString("knlid"));
        }
    }

    private void loadKnlList(String kmEntityNumber, Map<Object, List<Map<String, Object>>> qaMap) {
        if (qaMap.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u751f\u6210\u7684\u95ee\u7b54\u5bf9\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMGenQAResultFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
        }
        this.getModel().deleteEntryData("knlentry");
        List knlIds = qaMap.keySet().stream().map(k -> Long.parseLong(k.toString())).collect(Collectors.toList());
        DynamicObjectCollection knlDatas = QueryServiceHelper.query((String)kmEntityNumber, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", knlIds)});
        if (null == knlDatas || knlDatas.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u751f\u6210\u7684\u95ee\u7b54\u5bf9\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMGenQAResultFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
        }
        Map<String, String> knlIdNameMap = knlDatas.stream().collect(Collectors.toMap(k -> k.getString("id"), k -> k.getString("name")));
        for (Map.Entry<String, String> entry : knlIdNameMap.entrySet()) {
            String knlId = entry.getKey();
            String knlName = entry.getValue();
            List<Map<String, Object>> qas = qaMap.get(knlId);
            int qaCount = null == qas || qas.isEmpty() ? 0 : qas.size();
            int rowIndex = this.getModel().createNewEntryRow("knlentry");
            this.getModel().setValue("knlname", (Object)knlName, rowIndex);
            this.getModel().setValue("knlid", (Object)knlId, rowIndex);
            this.getModel().setValue("qacount", (Object)qaCount, rowIndex);
        }
        this.getView().updateView("knlentry");
    }

    private void loadAllQAList(Map<Object, List<Map<String, Object>>> qaMap) {
        this.getModel().deleteEntryData("entryentity");
        for (Map.Entry<Object, List<Map<String, Object>>> entry : qaMap.entrySet()) {
            Object knlId = entry.getKey();
            List<Map<String, Object>> qaList = entry.getValue();
            for (Map<String, Object> qaInfo : qaList) {
                int rowIndex = this.getModel().createNewEntryRow("entryentity");
                this.getModel().setValue("associateknlid", knlId, rowIndex);
                this.getModel().setValue("groupid", qaInfo.get("groupId"), rowIndex);
                this.getModel().setValue("question", qaInfo.get("question"), rowIndex);
                this.getModel().setValue("answer", qaInfo.get("answer"), rowIndex);
            }
        }
        this.getView().updateView("entryentity");
    }

    private void filterQAList(String knlId) {
        EntryQueryParam entryQueryParam = new EntryQueryParam();
        ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(1);
        if (StringUtils.isBlank((CharSequence)knlId)) {
            entryQueryParam.setFilterItems(filterItems);
            this.getModel().filterEntry("entryentity", entryQueryParam);
            this.getView().updateView("entryentity");
            return;
        }
        filterItems.add(new EntryFilterItemInfo("associateknlid", (Object)knlId, "67"));
        entryQueryParam.setFilterItems(filterItems);
        this.getModel().filterEntry("entryentity", entryQueryParam);
        this.getView().updateView("entryentity");
    }

    private void updateQACount(String knlId, int rowIndex) {
        if (StringUtils.isBlank((CharSequence)knlId) || rowIndex < 0) {
            return;
        }
        DynamicObjectCollection qaEntryDatas = this.getModel().getEntryEntity("entryentity");
        if (null == qaEntryDatas || qaEntryDatas.isEmpty()) {
            this.getModel().setValue("qacount", (Object)0, rowIndex);
            return;
        }
        this.getModel().setValue("qacount", (Object)qaEntryDatas.stream().filter(k -> k.getString("associateknlid") != null && k.getString("associateknlid").equals(knlId) && k.getBoolean("selectstatus")).count(), rowIndex);
    }

    private void saveQAKnl() {
        DynamicObjectCollection qaEntryDatas = this.getModel().getEntryEntity("entryentity");
        if (null == qaEntryDatas || qaEntryDatas.isEmpty()) {
            return;
        }
        Object useOrg = this.getView().getFormShowParameter().getCustomParam("useOrg");
        ArrayList<Map<String, Object>> qaKnlList = new ArrayList<Map<String, Object>>(qaEntryDatas.size());
        int seq = 0;
        for (DynamicObject qaEntryData : qaEntryDatas) {
            if (!qaEntryData.getBoolean("selectstatus")) continue;
            String knlId = qaEntryData.getString("associateknlid");
            Long groupId = qaEntryData.getLong("groupid");
            String question = qaEntryData.getString("question");
            String answer = qaEntryData.getString("answer");
            if (StringUtils.isBlank((CharSequence)knlId) || StringUtils.isBlank((Object)groupId) || StringUtils.isBlank((CharSequence)question)) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
            hashMap.put("Q", question);
            hashMap.put("A", answer);
            hashMap.put("groupId", groupId);
            hashMap.put("associateKnlId", knlId);
            hashMap.put("seq", seq++);
            hashMap.put("useOrg", useOrg);
            qaKnlList.add(hashMap);
        }
        String kmEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("kmEntityNumber");
        if (StringUtils.isBlank((CharSequence)kmEntityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u77e5\u8bc6\u5e93\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMGenQAResultFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
        }
        String qaEntityNumber = kmEntityNumber + "_qa";
        Map<Integer, String> saveResult = KMDataService.create().batchCreateQAKMObject(qaEntityNumber, qaKnlList);
        IFormView parentView = this.getView().getParentView();
        if (!saveResult.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry entry : saveResult.entrySet()) {
                builder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1s\u884c\u4fdd\u5b58\u5931\u8d25\uff1a%2s", (String)"KMGenQAResultFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]), (Integer)entry.getKey() + 1, entry.getValue()));
                builder.append("\n");
            }
            parentView.showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"KMGenQAResultFormPlugin_3", (String)SYSTEM, (Object[])new Object[0]), builder.toString(), MessageTypes.Default);
            this.getView().sendFormAction(parentView);
        } else {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("aikm_genqa_success");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("qaCount", (Object)qaKnlList.size());
            fsp.setCustomParam("knlNames", this.getKnlNames());
            Object lastConfigs = this.getView().getFormShowParameter().getCustomParam("lastConfigs");
            if (StringUtils.isNotBlank((Object)lastConfigs)) {
                try {
                    KMGenQAConfig kMGenQAConfig = (KMGenQAConfig)SerializationUtils.fromJsonString((String)lastConfigs.toString(), KMGenQAConfig.class);
                    fsp.setCustomParam("questionType", (Object)this.getQuestionType(kMGenQAConfig));
                    fsp.setCustomParam("contentFormat", (Object)kMGenQAConfig.getContentMode());
                }
                catch (Exception e) {
                    log.error("Config format is incorrect.");
                }
            }
            fsp.setCustomParam("kmEntityNumber", (Object)kmEntityNumber);
            parentView.showForm(fsp);
            this.getView().sendFormAction(parentView);
        }
        this.getView().close();
    }

    private void dispatchContinueGenQATask() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Object entityNumber = fsp.getCustomParam("kmEntityNumber");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber.toString());
        String appId = entityType.getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(entityType.getDisplayName().getLocaleValue());
        jobInfo.setNumber(entityNumber + "_genQAJob");
        jobInfo.setId(ID.genStringId());
        jobInfo.setTaskClassname("kd.ai.km.management.genqa.BatchGenQATask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        IFormView parentView = this.getView().getParentView();
        String pageId = parentView.getPageId();
        params.put("pageId", pageId);
        params.put(PARAM_ENTITY_NUMBER, entityNumber);
        params.put("prompt", fsp.getCustomParam("prompt"));
        int knlEntryRowIndex = this.getModel().getEntryCurrentRowIndex("knlentry");
        knlEntryRowIndex = Math.max(knlEntryRowIndex, 0);
        Long knlId = Long.valueOf(this.getModel().getValue("knlid", knlEntryRowIndex).toString());
        params.put("ids", Collections.singletonList(knlId));
        params.put("securityPrompt", fsp.getCustomParam("securityPrompt"));
        params.put("isContinueGen", "1");
        params.put("genCount", fsp.getCustomParam("genCount"));
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_TASK_GEN_QA);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u6b63\u5728\u751f\u6210", (String)"KMGenQAResultFormPlugin_4", (String)SYSTEM, (Object[])new Object[0]));
        jobFormInfo.setCanBackground(false);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName("kd.ai.km.management.genqa.BatchGenQATaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private List<String> getKnlNames() {
        ArrayList<String> knlNames = new ArrayList<String>();
        DynamicObjectCollection knlEntry = this.getModel().getEntryEntity("knlentry");
        for (DynamicObject knlInfo : knlEntry) {
            int qaCount = knlInfo.getInt("qacount");
            if (qaCount <= 0) continue;
            knlNames.add(knlInfo.getString("knlname"));
        }
        return knlNames;
    }

    private void reopenConfigForm() {
        Object lastConfigs = this.getView().getFormShowParameter().getCustomParam("lastConfigs");
        if (StringUtils.isBlank((Object)lastConfigs)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u751f\u6210\u914d\u7f6e\u9875\u9762\u3002", (String)"KMGenQAResultFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]));
            return;
        }
        IFormView parentView = this.getView().getParentView();
        String parentPageId = parentView.getPageId();
        String configParamStr = parentView.getPageCache().get("genQAConfigParams_" + parentPageId);
        if (StringUtils.isBlank((CharSequence)configParamStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u751f\u6210\u914d\u7f6e\u9875\u9762\u3002", (String)"KMGenQAResultFormPlugin_5", (String)SYSTEM, (Object[])new Object[0]));
            return;
        }
        Map configParams = (Map)SerializationUtils.fromJsonString((String)configParamStr, Map.class);
        FormShowParameter fsp = new FormShowParameter();
        fsp.getCustomParams().putAll(configParams);
        fsp.setCustomParam("lastConfigs", lastConfigs);
        fsp.setFormId("aikm_genqa_config");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        parentView.showForm(fsp);
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private String getQuestionType(KMGenQAConfig config) {
        ArrayList<String> result = new ArrayList<String>(3);
        if (config.isConceptual()) {
            result.add("conceptual");
        }
        if (config.isProcedural()) {
            result.add("procedural");
        }
        if (config.isContextual()) {
            result.add("contextual");
        }
        return String.join((CharSequence)",", result);
    }
}

