/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.index;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.Chunk;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.VectorStorePlugin;
import kd.bos.gptas.common.vectordb.model.VectorChunk;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class KMIndexStorePlugin
implements VectorStorePlugin {
    public List<VectorResult> postSearch(List<VectorResult> results) {
        this.fillChunkText(results);
        return results;
    }

    private void fillChunkText(List<VectorResult> vectorResults) {
        if (CollectionUtils.isEmpty(vectorResults)) {
            return;
        }
        HashMap<String, Map> chunkOfIdOfEntityId = new HashMap<String, Map>();
        for (VectorResult vectorResult : vectorResults) {
            if (vectorResult == null || vectorResult.getChunk() == null) continue;
            Chunk chunk = vectorResult.getChunk();
            String entityId = chunk.getEntityId();
            if (!entityId.endsWith("_index")) {
                throw new RuntimeException("entity invalide." + entityId);
            }
            entityId = entityId.substring(0, entityId.length() - 6);
            chunkOfIdOfEntityId.computeIfAbsent(entityId, k -> new HashMap()).put(chunk.getId(), chunk);
        }
        for (Map.Entry entry : chunkOfIdOfEntityId.entrySet()) {
            String entityId = (String)entry.getKey();
            Map chunkOfId = (Map)entry.getValue();
            if (StringUtils.isBlank((CharSequence)entityId) || MapUtils.isEmpty((Map)chunkOfId)) continue;
            String selectFields = "name,segmententity.subentryentity.id ,segmententity.id,segmententity.segment_tag,id,segmententity.extendcontent_tag, segmententity.seq,segmententity.segmenttype,segmententity.subentryentity.qindex";
            boolean isGroupKM = EntityMetadataCache.getDataEntityType((String)entityId).getProperties().containsKey((Object)"group");
            if (isGroupKM) {
                selectFields = selectFields + ",group.id";
            }
            QFilter qFilter = new QFilter("segmententity.subentryentity.id", "in", (Object)chunkOfId.keySet().toArray(new Long[0]));
            DataSet ds = QueryServiceHelper.queryDataSet((String)"km", (String)entityId, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"id");
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    Long id = row.getLong("segmententity.subentryentity.id");
                    Chunk chunk = (Chunk)chunkOfId.get(id);
                    if (chunk == null) continue;
                    chunk.setContent(this.convertCVPIMGToPreviewUrl(row.getString("segmententity.segment_tag")));
                    chunk.setKnowledgeId(row.getLong("id"));
                    chunk.setKnowledgeName(row.getString("name"));
                    chunk.setChunkSeq(row.getInteger("segmententity.seq").intValue());
                    chunk.setEntityId(entityId);
                    chunk.setChunkType(row.getString("segmententity.segmenttype"));
                    chunk.setExtendContent(this.convertCVPIMGToPreviewUrl(row.getString("segmententity.extendcontent_tag")));
                    chunk.setId(row.getLong("segmententity.id"));
                    if (!isGroupKM) continue;
                    chunk.setGroupId(row.getLong("group.id"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
    }

    private String convertCVPIMGToPreviewUrl(String content) {
        String patternString = "(?s)<cvp.img>(.*?)</cvp.img>";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = this.convertToPreviewUrl(matcher.group(1));
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String convertToPreviewUrl(String url) {
        String attUrl = UrlService.getAttachmentPreviewUrl((String)url);
        attUrl = EncreptSessionUtils.encryptSession((String)attUrl);
        return attUrl;
    }

    public List<VectorChunk> preStore(List<VectorChunk> vectorChunks) {
        return vectorChunks;
    }

    public SplitConfig getSplitConfig(String entityId) {
        if (!entityId.endsWith("_index")) {
            throw new RuntimeException("entity invalid." + entityId);
        }
        entityId = entityId.substring(0, entityId.length() - 6);
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityId);
        splitConfig.setEnableFullText(false);
        return splitConfig;
    }
}

