/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.kmreimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.ai.km.utils.KMManager;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.AbstractTaskClick;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.event.ClickEventArgs;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.io.FilenameUtils;

public class KMReimportTask
extends AbstractTask {
    private static final String AI_KM = "ai-km";
    private static final Log logger = LogFactory.getLog(KMReimportTask.class);
    public static final String KNLID = "knlid";
    public static final String TARGETKNLID = "targetknlid";
    private FileService fileService = FileServiceFactory.getAttachmentFileService();
    private int currentProgress = 0;
    private String currentMsg = "";

    public static void start(AbstractFormPlugin formPlugin, String actionId, Long knlId, Long targetKnlId, Object[] ids, boolean needSplit) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put(KNLID, knlId);
        if (targetKnlId == null) {
            targetKnlId = knlId;
        }
        params.put(TARGETKNLID, targetKnlId);
        if (ids != null) {
            params.put("ids", SerializationUtils.toJsonString((Object)ids));
        }
        params.put("needsplit", needSplit);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("aikm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(new LocaleString("KMReimportTask").toString());
        jobInfo.setNumber("KMReimportTask_" + knlId);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(KMReimportTask.class.getName());
        jobInfo.setCanStop(Boolean.FALSE);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)formPlugin, actionId);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption("\u91cd\u65b0\u5bfc\u5165");
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setClickClassName(RunnerTaskClick.class.getName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)formPlugin.getView());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long knlId = (Long)map.get(KNLID);
        Long targetKnlId = (Long)map.get(TARGETKNLID);
        KMManager kmManager = new KMManager(knlId);
        List ids = map.get("ids") != null ? SerializationUtils.fromJsonStringToList((String)((String)map.get("ids")), Long.class) : QueryServiceHelper.queryPrimaryKeys((String)kmManager.getKMEntityNumber(), (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"A")}, (String)"id", (int)1000000);
        Object[] datas = BusinessDataReader.load((Object[])ids.toArray(), (IDataEntityType)kmManager.getKMEntityType());
        if (datas.length == 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("cnt", "0");
            this.feedbackProgress(100, "no data.", result);
            this.feedbackCustomdata(result);
            return;
        }
        this.feedbackProgress(5, String.format(ResManager.loadKDString((String)"\u542f\u52a8\u91cd\u65b0\u5bfc\u5165,\u603b\u5171%s\u4e2a\u6587\u4ef6\u5f85\u5bfc\u5165\u3002", (String)"KMReimportTask_0", (String)AI_KM, (Object[])new Object[0]), datas.length), new HashMap());
        kmManager.setParseListener(new ParseListener(){

            public boolean getStop() {
                return KMReimportTask.this.isStop();
            }

            public void updateProgress(String progress) {
                KMReimportTask.this.feedbackProgress(KMReimportTask.this.currentProgress, KMReimportTask.this.currentMsg + progress, new HashMap());
            }
        });
        boolean needSplit = map.get("needsplit") == null ? false : (Boolean)map.get("needsplit");
        int count = 1;
        ArrayList<String> errors = new ArrayList<String>(16);
        for (Object data : datas) {
            this.currentProgress = 5 + (count - 1) * 95 / datas.length;
            this.currentMsg = String.format(ResManager.loadKDString((String)"\u6b63\u5728%1s/%2s\u5bfc\u5165\u4e2a\u6587\u4ef6\u3002", (String)"KMReimportTask_1", (String)AI_KM, (Object[])new Object[0]), count, datas.length);
            this.feedbackProgress(this.currentProgress, this.currentMsg, new HashMap());
            if (targetKnlId == null) {
                this.doReimport((DynamicObject)data, kmManager, needSplit, errors);
            } else {
                KMManager targetKM = new KMManager(targetKnlId);
                DynamicObject target = new DynamicObject((DynamicObjectType)targetKM.getKMEntityType());
                target.set("id", (Object)ID.genLongId());
                DynamicObject src = (DynamicObject)data;
                List attachments = AttachmentServiceHelper.getAttachments((String)kmManager.getKMEntityNumber(), (Object)src.getLong("id"), (String)"attachmentpanelap");
                if (!attachments.isEmpty()) {
                    this.saveAttachmentInfo(targetKM.getKMEntityNumber(), target.getLong("id"), attachments);
                }
                this.copyDynamicObject((DynamicObject)data, target);
                SaveServiceHelper.save((IDataEntityType)targetKM.getKMEntityType(), (Object[])new DynamicObject[]{target});
                Long srcGroupId = target.getLong("group_id");
                this.createGroupIfNotExist(targetKM, srcGroupId, kmManager);
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("cnt", count);
            this.feedbackCustomdata(result);
            ++count;
            this.checkIsStop();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cnt", count - 1);
        result.put("errors", String.join((CharSequence)"\n", errors));
        this.feedbackCustomdata(result);
    }

    private void createGroupIfNotExist(KMManager kmManager, Long id, KMManager srcKMManager) {
        Object[] data = BusinessDataReader.load((Object[])new Object[]{id}, (IDataEntityType)kmManager.getKMGroupEntityType());
        if (data.length > 0) {
            return;
        }
        DynamicObject groupData = new DynamicObject((DynamicObjectType)kmManager.getKMGroupEntityType());
        groupData.set("id", (Object)id);
        DynamicObject srcGroup = BusinessDataReader.loadSingle((Object)id, (DynamicObjectType)srcKMManager.getKMGroupEntityType());
        this.copyDynamicObject(srcGroup, groupData);
        SaveServiceHelper.save((IDataEntityType)kmManager.getKMGroupEntityType(), (Object[])new Object[]{groupData});
    }

    private void saveAttachmentInfo(String entityNumber, Long knlPkId, List<Map<String, Object>> attachments) {
        ArrayList attachmentList = new ArrayList(attachments.size());
        for (Map<String, Object> attachment : attachments) {
            HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
            attachmentMap.put("name", attachment.get("name"));
            attachmentMap.put("entityNum", entityNumber);
            attachmentMap.put("billPkId", knlPkId);
            attachmentMap.put("size", attachment.get("size"));
            attachmentMap.put("status", "success");
            attachmentMap.put("lastModified", new Date().getTime());
            attachmentMap.put("url", attachment.get("relativeUrl"));
            attachmentList.add(attachmentMap);
        }
        AttachmentServiceHelper.upload((String)entityNumber, (Object)knlPkId, (String)"attachmentpanelap", attachmentList);
    }

    private void doReimport(DynamicObject data, KMManager kmManager, boolean needSplit, List<String> errors) {
        OperationResult operationResult;
        List attachments = AttachmentServiceHelper.getAttachments((String)kmManager.getKMEntityNumber(), (Object)data.get("id"), (String)"attachmentpanelap");
        if (attachments == null || attachments.size() == 0) {
            return;
        }
        String url = ((Map)attachments.get(0)).get("relativeUrl").toString();
        InputStream inputStream = this.fileService.getInputStream(url);
        String fileName = (String)((Map)attachments.get(0)).get("name");
        String fileType = FilenameUtils.getExtension((String)fileName);
        String content = kmManager.parseFileContent(fileType, inputStream, url, kmManager.getKMEntityNumber(), false);
        data.set("inputcontent_tag", (Object)content);
        if (needSplit) {
            data.getDynamicObjectCollection("segmententity").clear();
        }
        if (!(operationResult = OperationServiceHelper.executeOperate((String)"save", (String)kmManager.getKMEntityNumber(), (DynamicObject[])new DynamicObject[]{data}, (OperateOption)OperateOption.create())).isSuccess()) {
            StringBuilder errorMessage = new StringBuilder();
            operationResult.getAllErrorOrValidateInfo().forEach(info -> errorMessage.append(info.getMessage()).append("\n"));
            logger.error(errorMessage.toString());
            errors.add(errorMessage.toString());
        }
    }

    private void copyDynamicObject(DynamicObject src, DynamicObject target) {
        DynamicObjectType type = target.getDynamicObjectType();
        ISimpleProperty primaryKey = type.getPrimaryKey();
        for (IDataEntityProperty property : type.getProperties()) {
            if (property == primaryKey) continue;
            if (property instanceof ISimpleProperty || property instanceof IComplexProperty) {
                target.set(property.getName(), src.get(property.getName()));
                continue;
            }
            if (!(property instanceof ICollectionProperty) || property instanceof DynamicLocaleProperty) continue;
            ICollectionProperty collectionProperty = (ICollectionProperty)property;
            DynamicObjectCollection srcCollection = src.getDynamicObjectCollection(property.getName());
            if (srcCollection == null) continue;
            DynamicObjectCollection targetCollection = new DynamicObjectCollection((DynamicObjectType)collectionProperty.getItemType(), (Object)target);
            target.set(property.getName(), (Object)targetCollection);
            for (DynamicObject srcRow : srcCollection) {
                DynamicObject targetRow = targetCollection.addNew();
                this.copyDynamicObject(srcRow, targetRow);
            }
        }
    }

    public static class RunnerTaskClick
    extends AbstractTaskClick {
        private Map<String, Object> getTaskData(TaskInfo taskInfo) {
            if (StringUtils.isNotBlank((CharSequence)taskInfo.getData())) {
                Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                return data;
            }
            HashMap<String, Object> data = new HashMap<String, Object>(16);
            data.put("cnt", -1);
            data.put("errors", "");
            return data;
        }

        public void click(ClickEventArgs e) {
            TaskInfo taskInfo = this.queryTask();
            if (taskInfo.isFailure()) {
                e.setClearTask(true);
                return;
            }
            IFormView parentView = this.getParentView();
            if (taskInfo.isTaskEnd()) {
                Map<String, Object> taskData = this.getTaskData(taskInfo);
                int count = taskData.get("cnt") == null ? -1 : Integer.parseInt(String.valueOf(taskData.get("cnt")));
                String errors = taskData.get("errors") == null ? "" : String.valueOf(taskData.get("errors"));
                String msg = "import finished\u3002%s files.%s";
                if (parentView == null) {
                    this.getMainView().showSuccessNotification(String.format(msg, count, errors));
                } else {
                    parentView.showSuccessNotification(String.format(msg, count, errors));
                    this.getMainView().sendFormAction(parentView);
                }
                e.setClearTask(true);
            } else if (parentView != null) {
                this.showProgressForm(parentView);
            }
        }

        private void showProgressForm(IFormView view) {
            if (this.isExistProgressForm()) {
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("sch_taskprogress");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            if (StringUtils.isBlank((CharSequence)this.getJobFormInfo().getCaption())) {
                showParameter.setCaption(this.getJobFormInfo().getCaption());
            }
            showParameter.getCustomParams().put("ServiceAppId", this.getJobFormInfo().getJobInfo().getAppId());
            String jobInfoStr = SerializationUtils.toJsonString((Object)this.getJobFormInfo());
            showParameter.getCustomParams().put("sch_clientjobinfo", jobInfoStr);
            showParameter.getCustomParams().put("sch_taskid", this.getTaskId());
            showParameter.setCloseCallBack(this.getJobFormInfo().getCloseCallBack());
            view.showForm(showParameter);
            this.getMainView().sendFormAction(view);
            this.setProgressPageId(showParameter.getPageId());
        }
    }
}

