/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.model;

import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class KnowledgeCodeGenerator {
    private static final Log logger = LogFactory.getLog(KnowledgeCodeGenerator.class);
    private static final HanyuPinyinOutputFormat PINYIN_FORMAT = new HanyuPinyinOutputFormat();

    public static String generateKnowledgeCode(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("\u8f93\u5165\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder result = new StringBuilder();
        name = name.toLowerCase();
        for (char c : name.toCharArray()) {
            if (KnowledgeCodeGenerator.isChineseChar(c)) {
                try {
                    String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)PINYIN_FORMAT);
                    if (pinyinArray == null || pinyinArray.length <= 0) continue;
                    result.append(pinyinArray[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            if (!Character.isLetterOrDigit(c)) continue;
            result.append(c);
        }
        String code = result.toString();
        if (code.isEmpty()) {
            code = "kb" + System.currentTimeMillis() % 100000L;
        }
        if (code.length() > 12) {
            code = code.substring(0, 12);
        }
        return code;
    }

    private static boolean isChineseChar(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS;
    }

    static {
        PINYIN_FORMAT.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        PINYIN_FORMAT.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
    }
}

