/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.similar;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.entryfilter.EntryFilterItemInfo;
import kd.bos.entity.property.entryfilter.EntryQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.VectorService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class SimilarQaFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
SearchEnterListener {
    private static final String SYSTEM = "ai-km";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"settingap", "settinglabel"});
        CardEntry cardEntry = (CardEntry)this.getControl("selectedrowentry");
        cardEntry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List selectedIds = (List)this.getView().getFormShowParameter().getCustomParams().get("selectedids");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entitynumber");
        if (entityNumber == null) {
            return;
        }
        this.fillCardEntry(selectedIds.toArray(), entityNumber);
    }

    public void afterBindData(EventObject e) {
        CardEntry cardEntry = (CardEntry)this.getControl("selectedrowentry");
        cardEntry.selectCard(Integer.valueOf(0));
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "settingap": 
            case "settinglabel": {
                String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entitynumber");
                if (entityNumber == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u5b9e\u4f53\u7f16\u7801\u3002", (String)"SimilarQaFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                    return;
                }
                Map result = BusinessDataReader.loadFromCache((String)"aikm_similar_setting", (QFilter[])new QFilter[]{new QFilter("associatekm", "=", (Object)entityNumber)});
                BaseShowParameter formShowParameter = new BaseShowParameter();
                if (!result.isEmpty()) {
                    formShowParameter.setPkId(((DynamicObject)result.values().stream().findFirst().get()).get("id"));
                }
                formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
                formShowParameter.setFormId("aikm_similar_setting");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entitynumber");
        if (entityNumber == null) {
            args.setCancel(true);
            return;
        }
        AbstractGrid.GridState state = ((EntryGrid)this.getControl("similarentry")).getEntryState();
        int[] selectedRow = state.getSelectedRows();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("similarentry");
        ArrayList<Long> deleteRow = new ArrayList<Long>(10);
        for (int index : selectedRow) {
            DynamicObject dynamicObject = (DynamicObject)entry.get(index);
            deleteRow.add(dynamicObject.getLong("id"));
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entityNumber, (Object[])deleteRow.toArray(), (OperateOption)OperateOption.create());
        ArrayList<Integer> deleteCardRowIndex = new ArrayList<Integer>(10);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("selectedrowentry");
        for (DynamicObject dyn : dynamicObjects) {
            Long qaId = dyn.getLong("qaid");
            if (!deleteRow.contains(qaId)) continue;
            deleteCardRowIndex.add(dyn.getInt("seq") - 1);
        }
        int[] deleteCardRowArray = deleteCardRowIndex.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().deleteEntryRows("selectedrowentry", deleteCardRowArray);
    }

    public void search(SearchEnterEvent evt) {
        String searchContent = evt.getText();
        EntryQueryParam entryQueryParam = new EntryQueryParam();
        ArrayList<EntryFilterItemInfo> filterItems = new ArrayList<EntryFilterItemInfo>(1);
        if (StringUtils.isBlank((CharSequence)searchContent)) {
            entryQueryParam.setFilterItems(filterItems);
            this.getModel().filterEntry("selectedrowentry", entryQueryParam);
            this.getView().updateView("selectedrowentry");
            return;
        }
        filterItems.add(new EntryFilterItemInfo("question", (Object)searchContent, CompareTypeEnum.LIKE.getId()));
        entryQueryParam.setFilterItems(filterItems);
        this.getModel().filterEntry("selectedrowentry", entryQueryParam);
        this.getView().updateView("selectedrowentry");
    }

    public void entryRowClick(RowClickEvent evt) {
        EntryGrid entry = (EntryGrid)evt.getSource();
        String entryKey = entry.getEntryKey();
        int row = evt.getRow();
        if ("selectedrowentry".equals(entryKey)) {
            String question = (String)this.getModel().getValue("question", row);
            Object qaId = this.getModel().getValue("qaid", row);
            this.fillSimilarEntry(question, qaId);
        }
    }

    private void fillCardEntry(Object[] selectedIds, String entityNumber) {
        Map result = BusinessDataReader.loadFromCache((Object[])selectedIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        this.getModel().batchCreateNewEntryRow("selectedrowentry", result.size());
        int row = 0;
        for (DynamicObject dynamicObject : result.values()) {
            this.getModel().setValue("qaid", dynamicObject.get("id"), row);
            this.getModel().setValue("question", dynamicObject.get("question_tag"), row);
            ++row;
        }
    }

    private void fillSimilarEntry(String question, Object qaId) {
        Object deleteItemObj;
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entitynumber");
        if (entityNumber == null) {
            return;
        }
        Map similarSetting = BusinessDataReader.loadFromCache((String)"aikm_similar_setting", (String)"deleteitem", (QFilter[])new QFilter[]{new QFilter("associatekm", "=", (Object)entityNumber)});
        float similarScore = !similarSetting.isEmpty() ? (StringUtils.isNotBlank((Object)(deleteItemObj = ((DynamicObject)similarSetting.values().stream().findFirst().get()).get("deleteitem"))) ? Float.parseFloat((String)deleteItemObj) : 0.8f) : 0.8f;
        SplitConfig splitConfig = KMConfigService.create().getSplitConfig(entityNumber);
        VectorService vectorService = VectorService.create((EmbeddingModel)splitConfig.getEmbeddingModel());
        ArrayList<String> entityIds = new ArrayList<String>();
        entityIds.add(entityNumber);
        List result = vectorService.search(entityIds, question, 100);
        this.getModel().deleteEntryData("similarentry");
        result = result.stream().filter(vectorResult -> {
            String similarityType = vectorResult.getSimilarityType();
            if ("L2".equals(similarityType)) {
                return 1.0f - vectorResult.getScore() >= similarScore;
            }
            if ("COSINE".equals(similarityType)) {
                return vectorResult.getScore() >= similarScore;
            }
            return true;
        }).collect(Collectors.toList());
        result = result.stream().filter(vectorResult -> {
            Long knowledgeId = vectorResult.getChunk().getKnowledgeId();
            return !knowledgeId.equals(qaId);
        }).collect(Collectors.toList());
        if (result.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u76f8\u4f3c\u7684\u6570\u636e\u3002", (String)"SimilarQaFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]), Integer.valueOf(800));
            return;
        }
        this.getModel().batchCreateNewEntryRow("similarentry", result.size());
        int row = 0;
        DecimalFormat df = new DecimalFormat("0.00%");
        for (VectorResult vectorResult2 : result) {
            String similarityType;
            float actulScore;
            Long knowledgeId = vectorResult2.getChunk().getKnowledgeId();
            if (knowledgeId.equals(qaId) || (actulScore = "L2".equals(similarityType = vectorResult2.getSimilarityType()) ? 1.0f - vectorResult2.getScore() : ("COSINE".equals(similarityType) ? vectorResult2.getScore() : 0.0f)) < similarScore) continue;
            this.getModel().setValue("id", (Object)knowledgeId, row);
            this.getModel().setValue("similarityscore", (Object)df.format(actulScore), row);
            this.getModel().setValue("actualscore", (Object)Float.valueOf(actulScore), row);
            this.getModel().setValue("similar_question", (Object)vectorResult2.getChunk().getContent(), row);
            ++row;
        }
        this.getView().updateView("similarentry");
    }
}

