/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.management.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.ai.km.base.KMDesignerData;
import kd.ai.km.management.model.PermAssign;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMManagerExtListPlugin
extends AbstractListPlugin {
    private static final Logger log = LoggerFactory.getLogger(KMManagerExtListPlugin.class);
    private static final String MANAGER_ENTITY = "aikm_knl_manager";

    public void itemClick(ItemClickEvent evt) {
        MainEntityType managerType;
        Object[] pkIds;
        DynamicObject[] dynamicObjects;
        ListSelectedRowCollection selectedRows;
        if ("deleteentity".equals(evt.getItemKey()) && (selectedRows = this.getSelectedRows()).size() > 0 && (dynamicObjects = BusinessDataServiceHelper.load((Object[])(pkIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray()), (DynamicObjectType)(managerType = EntityMetadataCache.getDataEntityType((String)MANAGER_ENTITY)))).length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Object kmentityid = dynamicObject.get("kmentityid");
                Object kmqaentityid = dynamicObject.get("kmqaentityid");
                Object kmgroupentityid = dynamicObject.get("kmgroupentityid");
                this.deleteKMConfig(kmentityid, kmqaentityid);
                this.unAssignPerm(dynamicObject, kmentityid, kmqaentityid);
                this.deleteFormMetadata(kmentityid, kmqaentityid, kmgroupentityid);
            }
            this.getView().showSuccessNotification("\u5220\u9664\u5b9e\u4f53\u6210\u529f");
        }
    }

    private void deleteFormMetadata(Object kmentityid, Object kmqaentityid, Object kmgroupentityid) {
        KMDesignerData.deleteFormMetadataIfNotNull(kmqaentityid.toString());
        KMDesignerData.deleteFormMetadataIfNotNull(kmentityid.toString());
        KMDesignerData.deleteFormMetadataIfNotNull(kmgroupentityid.toString());
    }

    private void deleteKMConfig(Object kmentityid, Object kmqaentityid) {
        String kmEntityNum = MetadataDao.getNumberById((String)kmentityid.toString());
        String kmqaEntityNum = MetadataDao.getNumberById((String)kmqaentityid.toString());
        DeleteServiceHelper.delete((String)"bos_knl_kmconfig", (QFilter[])new QFilter("kmformid", "=", (Object)kmEntityNum).toArray());
        DeleteServiceHelper.delete((String)"bos_knl_kmconfig", (QFilter[])new QFilter("kmformid", "=", (Object)kmqaEntityNum).toArray());
    }

    private void unAssignPerm(DynamicObject dynamicObject, Object kmentityid, Object kmqaentityid) {
        List<Long> adminuser = this.getUserPermissions(dynamicObject, "adminuser_tag");
        List<Long> edituser = this.getUserPermissions(dynamicObject, "edituser_tag");
        List<Long> audituser = this.getUserPermissions(dynamicObject, "audituser_tag");
        List<Long> viewuser = this.getUserPermissions(dynamicObject, "viewuser_tag");
        List<String> adminrole = this.getRolePermissions(dynamicObject, "adminrole_tag");
        List<String> editrole = this.getRolePermissions(dynamicObject, "editrole_tag");
        List<String> auditrole = this.getRolePermissions(dynamicObject, "auditrole_tag");
        List<String> viewrole = this.getRolePermissions(dynamicObject, "viewrole_tag");
        String kmEntityNum = MetadataDao.getNumberById((String)kmentityid.toString());
        String kmqaEntityNum = MetadataDao.getNumberById((String)kmqaentityid.toString());
        List<String> entityIds = Arrays.asList(kmEntityNum, kmqaEntityNum);
        PermAssign.unAssignUser(entityIds, adminuser);
        PermAssign.unAssignUser(entityIds, edituser);
        PermAssign.unAssignUser(entityIds, audituser);
        PermAssign.unAssignUser(entityIds, viewuser);
        PermAssign.unAssignRole(entityIds, adminrole);
        PermAssign.unAssignRole(entityIds, editrole);
        PermAssign.unAssignRole(entityIds, auditrole);
        PermAssign.unAssignRole(entityIds, viewrole);
    }

    private List<Long> getUserPermissions(DynamicObject managerData, String sourceField) {
        Object fieldValue = managerData.get(sourceField);
        if (fieldValue == null || StringUtils.isBlank((CharSequence)fieldValue.toString())) {
            return new ArrayList<Long>(1);
        }
        String[] userIds = fieldValue.toString().split(",");
        Long[] convertedIds = new Long[userIds.length];
        for (int i = 0; i < userIds.length; ++i) {
            try {
                if (userIds[i].trim().isEmpty()) continue;
                convertedIds[i] = Long.parseLong(userIds[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                log.warn("Failed to convert user ID: {}", (Object)userIds[i]);
            }
        }
        return Arrays.asList(convertedIds);
    }

    private List<String> getRolePermissions(DynamicObject managerData, String sourceField) {
        Object fieldValue = managerData.get(sourceField);
        if (fieldValue == null || StringUtils.isBlank((CharSequence)fieldValue.toString())) {
            return new ArrayList<String>(1);
        }
        String[] roleIds = fieldValue.toString().split(",");
        String[] trimmedRoles = new String[roleIds.length];
        for (int i = 0; i < roleIds.length; ++i) {
            trimmedRoles[i] = roleIds[i].trim();
        }
        return Arrays.asList(trimmedRoles);
    }
}

