/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.openapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.ai.km.search.model.KMSearchResult;
import kd.ai.km.search.utils.KMSearchUtils;
import kd.ai.km.service.AIKMServiceImpl;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

@ApiController(value="aikm", desc="\u901a\u7528\u77e5\u8bc6\u5e93\u7ba1\u7406")
public class AIKMAPIService {
    private static final Log logger = LogFactory.getLog(AIKMAPIService.class);
    private static final String SYSTEM_TYPE = "ai-km";

    private void checkViewPermission() {
        boolean hasCreateRight = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"gai", (String)"aikm_knl_manager", (String)"47150e89000000ac");
        if (!hasCreateRight) {
            throw new KDBizException(new ErrorCode("109", ResManager.loadKDString((String)"\u6ca1\u6709\u901a\u7528\u77e5\u8bc6\u5e93\u7684\u3010\u67e5\u8be2\u3011\u6743\u9650\u3002", (String)"AIKMAPI_1", (String)SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiPostMapping(value="aikm/getlist")
    public CustomApiResult<List<Map<String, String>>> getList() {
        try {
            this.checkViewPermission();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"aikm_knl_manager", (String)"aikm_knl_manager", (String)"id,number,name,desc,group.id,group.number,group.name,enable ", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0)}, (String)"number");){
                ArrayList list = new ArrayList(16);
                for (Row row : ds) {
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", row.getString("id"));
                    map.put("number", row.getString("number"));
                    map.put("name", row.getString("name"));
                    map.put("desc", row.getString("desc"));
                    map.put("enable", row.getString("enable"));
                    map.put("group_id", row.getString("group.id"));
                    map.put("group_number", row.getString("group.number"));
                    map.put("group_name", row.getString("group.name"));
                    list.add(map);
                }
                Iterator iterator = CustomApiResult.success(list);
                return iterator;
            }
            catch (Exception ex) {
                logger.error("getList", (Throwable)ex);
                return CustomApiResult.fail((String)"1001", (String)ex.getMessage());
            }
        }
        catch (KDBizException ex) {
            logger.error("getList", (Throwable)ex);
            return CustomApiResult.fail((String)"1002", (String)ex.getMessage());
        }
    }

    @ApiPostMapping(value="aikm/retrieval")
    public CustomApiResult<List<KMSearchResult>> retrieval(@ApiParam(value="\u95ee\u9898") @ApiParam(value="\u95ee\u9898") String query, @ApiParam(value="\u77e5\u8bc6\u5e93Id") @ApiParam(value="\u77e5\u8bc6\u5e93Id") List<Long> knowledgeIds, @ApiParam(value="\u68c0\u7d22\u6a21\u5f0f") @ApiParam(value="\u68c0\u7d22\u6a21\u5f0f") String searchMode, @ApiParam(value="TopK") @ApiParam(value="TopK") Integer topK, @ApiParam(value="\u9608\u503c") @ApiParam(value="\u9608\u503c") Float threshold, @ApiParam(value="\u662f\u5426\u542f\u7528\u91cd\u6392") @ApiParam(value="\u662f\u5426\u542f\u7528\u91cd\u6392") Boolean rerank, @ApiParam(value="\u91cd\u6392\u670d\u52a1\u7f16\u7801") @ApiParam(value="\u91cd\u6392\u670d\u52a1\u7f16\u7801") String rerankNumber) {
        try {
            this.checkViewPermission();
            AIKMServiceImpl aikmService = new AIKMServiceImpl();
            List<VectorResult> retrievalList = aikmService.retrieval(query, knowledgeIds, searchMode, topK, threshold, rerank, rerankNumber);
            boolean isQContentOnly = "Q_CONTENT_ONLY".equals(searchMode);
            List<KMSearchResult> result = KMSearchUtils.getKMSearchResultByVector(retrievalList, true, true, isQContentOnly);
            return CustomApiResult.success(result);
        }
        catch (KDBizException ex) {
            logger.error("retrieval", (Throwable)ex);
            return CustomApiResult.fail((String)"1002", (String)ex.getMessage());
        }
    }
}

