/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ai.km.management.index.KMIndexServiceImpl;
import kd.ai.km.search.model.KMSearchResult;
import kd.ai.km.search.utils.KMSearchUtils;
import kd.ai.km.service.AIKMService;
import kd.ai.km.service.KMDataService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.gptas.api.KMConfigService;
import kd.bos.gptas.api.RerankService;
import kd.bos.gptas.api.km.split.SplitConfig;
import kd.bos.gptas.api.vector.EmbeddingModel;
import kd.bos.gptas.api.vector.SimilarityType;
import kd.bos.gptas.api.vector.VectorResult;
import kd.bos.gptas.common.embedding.EmbeddingFactory;
import kd.bos.gptas.common.embedding.model.EmbeddingVector;
import kd.bos.gptas.common.embedding.service.EmbeddingService;
import kd.bos.gptas.common.vectordb.model.VectorQuery;
import kd.bos.gptas.kmbase.service.KnowledgeVectorServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AIKMServiceImpl
implements AIKMService {
    private static final Log logger = LogFactory.getLog(AIKMServiceImpl.class);
    private static final String RESULTS_KEY = "results";
    private static final int RERANK_MULTIPLIER = 3;
    private final KMConfigService kmConfigService = KMConfigService.create();
    private final KMDataService kmDataService = KMDataService.create();
    private EmbeddingService embeddingService;

    @Override
    public List<VectorResult> retrieval(String query, List<Long> knowledgeIds, String searchMode, Integer topK, Float threshold, Boolean rerank, String rerankNumber) {
        return this.getVectorResults(query, knowledgeIds, searchMode, topK, threshold, rerank, rerankNumber, null);
    }

    private List<VectorResult> getVectorResults(String query, List<Long> knowledgeIds, String searchMode, Integer topK, Float threshold, Boolean rerank, String rerankNumber, Map<String, Map<String, Object>> knowledgeWithGroupMap) {
        logger.info("Starting retrieval with query: {}, knowledgeIds: {}, mode: {}, topK: {}, threshold: {}, rerank: {}, rerankNumber: {}, knowledgeWithGroupMap:{}", new Object[]{query, knowledgeIds, searchMode, topK, threshold, rerank, rerankNumber, knowledgeWithGroupMap});
        this.validateParameters(query, knowledgeIds, searchMode, topK, threshold, rerank, rerankNumber);
        RetrievalParam retrievalParam = new RetrievalParam();
        retrievalParam.setQuery(query);
        retrievalParam.setSearchMode(RetrievalParam.SearchMode.valueOf(searchMode));
        retrievalParam.setTopK(topK);
        retrievalParam.setThreshold(threshold != null ? threshold.floatValue() : -1.0f);
        retrievalParam.setRerank(rerank != null ? rerank : false);
        retrievalParam.setRerankNumber(rerankNumber);
        Map<Long, KnowledgeEntity> entityIdsMap = this.getEntityIdsForKnowledges(knowledgeIds);
        List<KnowledgeEntity> entityIds = this.prepareEntityIds(knowledgeIds, entityIdsMap, retrievalParam.getSearchMode());
        if (knowledgeWithGroupMap != null) {
            for (KnowledgeEntity entityId : entityIds) {
                Map<String, Object> map = knowledgeWithGroupMap.get(String.valueOf(entityId.getKnowledgeId()));
                if (map == null) continue;
                entityId.setGroupNumbers((String[])map.get("g"));
            }
        }
        retrievalParam.setKnowledgeEntities(entityIds);
        List<VectorResult> vectorResults = this.searchByMode(retrievalParam);
        List<VectorResult> filteredResults = this.filterEmptyResults(vectorResults);
        List<VectorResult> finalResults = retrievalParam.isRerank() ? this.handleRerank(filteredResults, retrievalParam) : this.applyThresholdAndTopK(filteredResults, retrievalParam);
        logger.info("Retrieval completed. Final results count: {}", (Object)finalResults.size());
        return finalResults;
    }

    @Override
    public List<VectorResult> retrievalWithGroups(String query, List<Map<String, Object>> knowledgeIds, String searchMode, Integer topK, Float threshold, Boolean rerank, String rerankNumber) {
        logger.info("Starting retrieval with groups with query: {}, knowledgeIds: {}, mode: {}, topK: {}, threshold: {}, rerank: {}, rerankNumber: {}", new Object[]{query, knowledgeIds, searchMode, topK, threshold, rerank, rerankNumber});
        ArrayList<Long> k = new ArrayList<Long>(16);
        HashMap<String, Map<String, Object>> mapWithGroup = new HashMap<String, Map<String, Object>>(16);
        for (Map<String, Object> knowledgeId : knowledgeIds) {
            k.add((Long)knowledgeId.get("k"));
            mapWithGroup.put(String.valueOf(knowledgeId.get("k")), knowledgeId);
        }
        return this.getVectorResults(query, k, searchMode, topK, threshold, rerank, rerankNumber, mapWithGroup);
    }

    @Override
    public Map<String, Object> convertToKMSearchResults(List<VectorResult> results, String searchMode) {
        if (results == null) {
            return Collections.singletonMap(RESULTS_KEY, Collections.emptyList());
        }
        logger.info("Converting {} vector results to KMSearchResult objects", (Object)results.size());
        boolean isQContentOnly = RetrievalParam.SearchMode.Q_CONTENT_ONLY.name().equals(searchMode);
        List<KMSearchResult> kmSearchResults = KMSearchUtils.getKMSearchResultByVector(results, true, true, isQContentOnly);
        String jsonString = JSON.toJSONString(kmSearchResults, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        List resultMaps = JSON.parseArray((String)jsonString, Map.class);
        return Collections.singletonMap(RESULTS_KEY, resultMaps);
    }

    private List<KnowledgeEntity> prepareEntityIds(List<Long> knowledgeIds, Map<Long, KnowledgeEntity> entityIdsMap, RetrievalParam.SearchMode searchMode) {
        List<KnowledgeEntity> entityIds;
        if (searchMode == RetrievalParam.SearchMode.TEXT_QA) {
            entityIds = new ArrayList<KnowledgeEntity>();
            for (Long id : knowledgeIds) {
                KnowledgeEntity entity2 = entityIdsMap.get(id);
                if (entity2 == null) continue;
                if (StringUtils.isNotBlank((CharSequence)entity2.getEntityNumber())) {
                    KnowledgeEntity textEntity = new KnowledgeEntity(id, entity2.getEntityNumber(), entity2.getQaEntityNumber(), entity2.getGroupEntityNumber());
                    textEntity.setUseEntityNumber(entity2.getEntityNumber());
                    entityIds.add(textEntity);
                }
                if (!StringUtils.isNotBlank((CharSequence)entity2.getQaEntityNumber())) continue;
                KnowledgeEntity qaEntity = new KnowledgeEntity(id, entity2.getEntityNumber(), entity2.getQaEntityNumber(), entity2.getGroupEntityNumber());
                qaEntity.setUseEntityNumber(entity2.getQaEntityNumber());
                entityIds.add(qaEntity);
            }
        } else {
            entityIds = knowledgeIds.stream().map(entityIdsMap::get).filter(Objects::nonNull).map(knowledgeEntity -> {
                switch (searchMode) {
                    case Q_CONTENT_ONLY: 
                    case Q_ONLY: 
                    case QA_ONLY: {
                        knowledgeEntity.setUseEntityNumber(knowledgeEntity.getQaEntityNumber());
                        break;
                    }
                    case TEXT_ONLY: {
                        knowledgeEntity.setUseEntityNumber(knowledgeEntity.getEntityNumber());
                        break;
                    }
                }
                return knowledgeEntity;
            }).filter(entity -> StringUtils.isNotBlank((CharSequence)entity.getUseEntityNumber())).collect(Collectors.toList());
        }
        return entityIds;
    }

    private Map<Long, KnowledgeEntity> getEntityIdsForKnowledges(List<Long> knowledgeIds) {
        HashMap<Long, KnowledgeEntity> entityIdsMap = new HashMap<Long, KnowledgeEntity>();
        try {
            Map result = BusinessDataReader.loadFromCache((String)"aikm_knl_manager", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("id", "in", knowledgeIds)});
            for (DynamicObject dynamicObject : result.values()) {
                try {
                    Long id = dynamicObject.getLong("id");
                    String entityId = dynamicObject.getString("kmentityid");
                    String qaEntityId = dynamicObject.getString("kmqaentityid");
                    String kmgroupEntityId = dynamicObject.getString("kmgroupentityid");
                    String entityNumber = MetadataDao.getNumberById((String)entityId);
                    String qaEntityNumber = MetadataDao.getNumberById((String)qaEntityId);
                    String groupEntityNumber = MetadataDao.getNumberById((String)kmgroupEntityId);
                    entityIdsMap.put(id, new KnowledgeEntity(id, entityNumber, qaEntityNumber, groupEntityNumber));
                }
                catch (Exception e) {
                    logger.error("Error processing knowledge entity IDs for record: " + dynamicObject, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error loading knowledge entities from cache", (Throwable)e);
            throw new RuntimeException(e);
        }
        return entityIdsMap;
    }

    private void validateParameters(String query, List<Long> knowledgeIds, String searchMode, Integer topK, Float threshold, Boolean rerank, String rerankNumber) {
        ArrayList<String> errors = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)query)) {
            errors.add("query cannot be null or empty");
        }
        if (knowledgeIds == null || knowledgeIds.isEmpty()) {
            errors.add("knowledgeIds cannot be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)searchMode)) {
            errors.add("searchMode cannot be null or empty");
        } else {
            try {
                RetrievalParam.SearchMode.valueOf(searchMode);
            }
            catch (IllegalArgumentException e) {
                errors.add("invalid searchMode: " + searchMode);
            }
        }
        if (topK == null || topK <= 0) {
            errors.add("topK must be greater than 0");
        }
        if (threshold != null && (threshold.floatValue() < 0.0f || threshold.floatValue() > 1.0f)) {
            errors.add("threshold must be between 0 and 1");
        }
        if (Boolean.TRUE.equals(rerank) && StringUtils.isBlank((CharSequence)rerankNumber)) {
            errors.add("rerankNumber is required when rerank is true");
        }
        if (!errors.isEmpty()) {
            String errorMessage = String.join((CharSequence)"; ", errors);
            logger.error("Parameter validation failed: {}", (Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private List<VectorResult> searchByMode(RetrievalParam param) {
        switch (param.getSearchMode()) {
            case Q_CONTENT_ONLY: 
            case Q_ONLY: {
                return this.doSearch(param, Collections.singletonList("Q"));
            }
            case QA_ONLY: {
                return this.doSearch(param, Collections.singletonList("QA"));
            }
            case TEXT_ONLY: {
                return this.doSearch(param, Collections.singletonList("TEXT"));
            }
            case TEXT_QA: {
                return this.searchTextQA(param);
            }
        }
        throw new IllegalArgumentException("Unsupported search mode: " + (Object)((Object)param.getSearchMode()));
    }

    private List<VectorResult> searchTextQA(RetrievalParam param) {
        logger.info("Executing search for TEXT_QA mode");
        Map<Boolean, List<KnowledgeEntity>> entities = param.getKnowledgeEntities().stream().collect(Collectors.partitioningBy(e -> e.getUseEntityNumber().equals(e.getEntityNumber())));
        List<KnowledgeEntity> textEntities = entities.get(Boolean.TRUE);
        List<KnowledgeEntity> qaEntities = entities.get(Boolean.FALSE);
        ArrayList<VectorResult> results = new ArrayList<VectorResult>();
        if (!textEntities.isEmpty()) {
            RetrievalParam textParam = this.createParamCopy(param);
            textParam.setKnowledgeEntities(textEntities);
            results.addAll(this.doSearch(textParam, Collections.singletonList("TEXT")));
        }
        if (!qaEntities.isEmpty()) {
            RetrievalParam qaParam = this.createParamCopy(param);
            qaParam.setKnowledgeEntities(qaEntities);
            results.addAll(this.doSearch(qaParam, Collections.singletonList("QA")));
        }
        logger.info("TEXT_QA search completed. Total results after merging: {}", (Object)results.size());
        return results;
    }

    private RetrievalParam createParamCopy(RetrievalParam original) {
        RetrievalParam copy = new RetrievalParam();
        copy.setQuery(original.getQuery());
        copy.setSearchMode(original.getSearchMode());
        copy.setTopK(original.getTopK());
        copy.setThreshold(original.getThreshold());
        copy.setRerank(original.isRerank());
        copy.setRerankNumber(original.getRerankNumber());
        return copy;
    }

    private List<VectorResult> doSearch(RetrievalParam param, List<String> collectionTypes) {
        List<String> useKnowledgeEntities = param.getKnowledgeEntities().stream().map(KnowledgeEntity::getUseEntityNumber).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (useKnowledgeEntities.isEmpty()) {
            logger.warn("No valid knowledge entities found for search");
            return Collections.emptyList();
        }
        Map<EmbeddingModel, List<SplitConfig>> configsByModel = this.getConfigsByModel(useKnowledgeEntities);
        int searchTopK = param.isRerank() ? param.getTopK() * 3 : param.getTopK();
        return this.executeSearchByModels(configsByModel, param, collectionTypes, searchTopK);
    }

    private Map<EmbeddingModel, List<SplitConfig>> getConfigsByModel(List<String> entityIds) {
        return entityIds.stream().map(arg_0 -> ((KMConfigService)this.kmConfigService).getSplitConfig(arg_0)).filter(Objects::nonNull).collect(Collectors.groupingBy(SplitConfig::getEmbeddingModel));
    }

    private List<VectorResult> executeSearchByModels(Map<EmbeddingModel, List<SplitConfig>> configsByModel, RetrievalParam param, List<String> collectionTypes, int searchTopK) {
        ArrayList<VectorResult> results = new ArrayList<VectorResult>();
        for (Map.Entry<EmbeddingModel, List<SplitConfig>> entry : configsByModel.entrySet()) {
            results.addAll(this.searchByEmbeddingModel(entry.getKey(), entry.getValue(), param, collectionTypes, searchTopK));
        }
        return results;
    }

    private List<VectorResult> searchByEmbeddingModel(EmbeddingModel model, List<SplitConfig> configs, RetrievalParam param, List<String> chunkTypes, int searchTopK) {
        logger.info("Searching with model: {}, query: '{}', topK: {}", new Object[]{model.getModelName(), param.getQuery(), searchTopK});
        KnowledgeVectorServiceImpl vectorService = new KnowledgeVectorServiceImpl(model);
        Map<String, String> groupNumberByEntity = param.getKnowledgeEntities().stream().collect(Collectors.toMap(KnowledgeEntity::getUseEntityNumber, KnowledgeEntity::getGroupEntityNumber, (v1, v2) -> v1));
        ArrayList<VectorResult> results = new ArrayList<VectorResult>();
        for (SplitConfig config : configs) {
            try {
                List<Long> accessibleGroupIds;
                String groupNumber = groupNumberByEntity.get(config.getFormId());
                KnowledgeEntity knowledgeEntity = param.getKnowledgeEntityWithFormID(config.getFormId());
                if (knowledgeEntity != null && knowledgeEntity.getGroupNumbers() != null && knowledgeEntity.getGroupNumbers().length > 0) {
                    try (DataSet rows = QueryServiceHelper.queryDataSet((String)"", (String)groupNumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)knowledgeEntity.getGroupNumbers())}, (String)"id", (int)1000);){
                        accessibleGroupIds = new ArrayList<Long>(16);
                        for (Row row : rows) {
                            accessibleGroupIds.add(row.getLong("id"));
                        }
                    }
                    if (accessibleGroupIds.isEmpty()) {
                        logger.info("group not exists.");
                        return Collections.emptyList();
                    }
                } else {
                    accessibleGroupIds = this.kmDataService.getAccessibleGroupIds(groupNumber);
                }
                VectorQuery query = new VectorQuery();
                query.setRepositoryIds(Collections.singletonList(config.getFormId()));
                query.setQueryVector(param.getVectors(config));
                if (CollectionUtils.isNotEmpty(chunkTypes)) {
                    query.setChunkTypes(chunkTypes);
                }
                if (CollectionUtils.isNotEmpty(accessibleGroupIds)) {
                    query.setGroupIds(accessibleGroupIds);
                }
                query.setQueryText(param.getQuery());
                query.setTopK(searchTopK);
                List<VectorResult> search = vectorService.searchByVector(query);
                results.addAll((Collection<VectorResult>)search);
                if (!chunkTypes.contains("TEXT") || !config.isEnableIndex()) continue;
                HashMap<Long, VectorResult> map = new HashMap<Long, VectorResult>(16);
                results.forEach(vectorResult -> {
                    if (vectorResult.getChunk() != null) {
                        map.put(vectorResult.getChunk().getId(), (VectorResult)vectorResult);
                    }
                });
                search = new KMIndexServiceImpl(model).searchByVector(query);
                for (VectorResult vectorResult2 : search) {
                    if (vectorResult2.getChunk() == null) continue;
                    VectorResult existVectorResult = (VectorResult)map.get(vectorResult2.getChunk().getId());
                    if (existVectorResult == null) {
                        results.add(vectorResult2);
                        map.put(vectorResult2.getChunk().getId(), vectorResult2);
                        continue;
                    }
                    boolean isHigher = SimilarityType.COSINE.name().equals(existVectorResult.getSimilarityType()) ? existVectorResult.getScore() > vectorResult2.getScore() : existVectorResult.getScore() < vectorResult2.getScore();
                    if (isHigher) continue;
                    results.remove(existVectorResult);
                    map.put(vectorResult2.getChunk().getId(), vectorResult2);
                    results.add(vectorResult2);
                }
            }
            catch (Exception e) {
                logger.error("Error searching with model: " + model.getModelName() + " and config: " + config.getFormId(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return results;
    }

    private List<VectorResult> filterEmptyResults(List<VectorResult> results) {
        List<VectorResult> filtered = results.stream().filter(result -> result.getChunk() != null && StringUtils.isNotBlank((CharSequence)result.getChunk().getContent())).collect(Collectors.toList());
        logger.info("Search completed. Total results: {}, after filtering: {}", (Object)results.size(), (Object)filtered.size());
        return filtered;
    }

    private List<VectorResult> applyThresholdAndTopK(List<VectorResult> results, RetrievalParam param) {
        return results.stream().filter(result -> this.isPassingThreshold((VectorResult)result, param)).sorted((a, b) -> this.compareResults((VectorResult)a, (VectorResult)b, param)).limit(param.getTopK()).collect(Collectors.toList());
    }

    private boolean isPassingThreshold(VectorResult result, RetrievalParam param) {
        if (param.getThreshold() <= 0.0f) {
            return true;
        }
        boolean isHigherBetter = this.isHigherBetterScenario(result, param);
        if (isHigherBetter) {
            return result.getScore() >= param.getThreshold();
        }
        double invertedThreshold = 1.0f - param.getThreshold();
        return (double)result.getScore() <= invertedThreshold;
    }

    private int compareResults(VectorResult a, VectorResult b, RetrievalParam param) {
        boolean aIsHigherBetter = this.isHigherBetterScenario(a, param);
        boolean bIsHigherBetter = this.isHigherBetterScenario(b, param);
        if (aIsHigherBetter && bIsHigherBetter) {
            return Double.compare(b.getScore(), a.getScore());
        }
        if (!aIsHigherBetter && !bIsHigherBetter) {
            return Double.compare(a.getScore(), b.getScore());
        }
        double normalizedScoreA = aIsHigherBetter ? (double)a.getScore() : (double)(1.0f - a.getScore());
        double normalizedScoreB = bIsHigherBetter ? (double)b.getScore() : (double)(1.0f - b.getScore());
        return Double.compare(normalizedScoreB, normalizedScoreA);
    }

    private boolean isHigherBetterScenario(VectorResult result, RetrievalParam param) {
        return param.isRerank() || SimilarityType.COSINE.name().equals(result.getSimilarityType());
    }

    private List<VectorResult> handleRerank(List<VectorResult> vectorResults, RetrievalParam param) {
        logger.info("Starting rerank for {} results", (Object)vectorResults.size());
        if (StringUtils.isBlank((CharSequence)param.getRerankNumber())) {
            logger.info("No rerank number provided, returning original results");
            RetrievalParam noRerankParam = this.createParamCopy(param);
            noRerankParam.setRerank(false);
            return this.applyThresholdAndTopK(vectorResults, noRerankParam);
        }
        List rerankedResults = RerankService.create((String)param.getRerankNumber()).rerankSearchResults(param.getQuery(), vectorResults, param.getTopK());
        return rerankedResults.stream().filter(result -> result.getScore() >= param.getThreshold()).collect(Collectors.toList());
    }

    private static class RetrievalParam {
        private String query;
        private List<KnowledgeEntity> knowledgeEntities;
        private SearchMode searchMode;
        private int topK;
        private float threshold;
        private boolean rerank;
        private String rerankNumber;
        private static final ThreadLocal<Map<EmbeddingModel, List<Float>>> vectors = ThreadLocal.withInitial(() -> new HashMap(16));

        private RetrievalParam() {
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public List<KnowledgeEntity> getKnowledgeEntities() {
            return this.knowledgeEntities;
        }

        public void setKnowledgeEntities(List<KnowledgeEntity> knowledgeEntities) {
            this.knowledgeEntities = knowledgeEntities;
        }

        public SearchMode getSearchMode() {
            return this.searchMode;
        }

        public void setSearchMode(SearchMode searchMode) {
            this.searchMode = searchMode;
        }

        public int getTopK() {
            return this.topK;
        }

        public void setTopK(int topK) {
            this.topK = topK;
        }

        public float getThreshold() {
            return this.threshold;
        }

        public void setThreshold(float threshold) {
            this.threshold = threshold;
        }

        public boolean isRerank() {
            return this.rerank;
        }

        public void setRerank(boolean rerank) {
            this.rerank = rerank;
        }

        public String getRerankNumber() {
            return this.rerankNumber;
        }

        public void setRerankNumber(String rerankNumber) {
            this.rerankNumber = rerankNumber;
        }

        public KnowledgeEntity getKnowledgeEntityWithFormID(String formId) {
            for (KnowledgeEntity knowledgeEntity : this.knowledgeEntities) {
                if (!formId.equals(knowledgeEntity.getEntityNumber()) && !formId.equals(knowledgeEntity.getQaEntityNumber())) continue;
                return knowledgeEntity;
            }
            return null;
        }

        public List<Float> getVectors(SplitConfig config) {
            if (!config.isEnableVector()) {
                return Collections.emptyList();
            }
            List vector = vectors.get().get(config.getEmbeddingModel());
            if (vector == null) {
                EmbeddingService embeddingService = EmbeddingFactory.create((EmbeddingModel)config.getEmbeddingModel());
                EmbeddingVector embeddingVector = embeddingService.embed(this.getQuery());
                vector = embeddingVector.getVector();
                vectors.get().put(config.getEmbeddingModel(), vector);
            }
            return vector;
        }

        public static enum SearchMode {
            Q_CONTENT_ONLY,
            Q_ONLY,
            QA_ONLY,
            TEXT_ONLY,
            TEXT_QA;

        }
    }

    private static class KnowledgeEntity {
        private final Long knowledgeId;
        private final String entityNumber;
        private final String qaEntityNumber;
        private final String groupEntityNumber;
        private String useEntityNumber;
        private String[] groupNumbers;

        public KnowledgeEntity(Long knowledgeId, String entityNumber, String qaEntityNumber, String groupEntityNumber) {
            this.knowledgeId = knowledgeId;
            this.entityNumber = entityNumber;
            this.qaEntityNumber = qaEntityNumber;
            this.groupEntityNumber = groupEntityNumber;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public String getQaEntityNumber() {
            return this.qaEntityNumber;
        }

        public String getGroupEntityNumber() {
            return this.groupEntityNumber;
        }

        public String getUseEntityNumber() {
            return this.useEntityNumber;
        }

        public Long getKnowledgeId() {
            return this.knowledgeId;
        }

        public void setUseEntityNumber(String useEntityNumber) {
            this.useEntityNumber = useEntityNumber;
        }

        public String[] getGroupNumbers() {
            return this.groupNumbers;
        }

        public void setGroupNumbers(String[] groupNumbers) {
            this.groupNumbers = groupNumbers;
        }
    }
}

