/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.ai.km.service.KMDataService;
import kd.ai.km.utils.KMManageUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.base.BaseModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;

public class KMDataServiceImpl
implements KMDataService {
    private static final Log log = LogFactory.getLog(KMDataServiceImpl.class);
    private static final String SYSTEM = "ai-km";
    private static final String ENTITY_KM_MANAGER = "aikm_knl_manager";
    private static final String PROP_ID = "id";
    private static final String PROP_NUMBER = "number";
    private static final String PROP_NAME = "name";
    private static final String PROP_CREATEORG_ID = "createorg.id";
    private static final String PROP_CREATEORG = "org_id";
    private static final String PROP_CREATOR = "creator_id";
    private static final String PROP_GROUP_ID = "group_id";
    private static final String PROP_ENABLE = "enable";
    private static final String PROP_STATUS = "status";
    private static final String PROP_UPLOAD_STATUS = "uploadstatus";
    private static final String PROP_TYPE = "type";
    private static final String PROP_QUESTION = "question";
    private static final String PROP_QUESTION_TAG = "question_tag";
    private static final String PROP_ANSWER = "answer";
    private static final String PROP_ANSWER_TAG = "answer_tag";
    private static final String PROP_ASSOCIATE_KNL = "associateknl_id";
    private static final String PROP_INPUT_CONTENT = "inputcontent_tag";
    private static final String DEFAULT_ORG_VIEW_NUMBER = "15";

    @Override
    public QFilter getKMGroupFilter(String viewNumber, Long orgId) {
        List allSuperiorOrgs;
        if (StringUtils.isBlank((CharSequence)viewNumber)) {
            viewNumber = DEFAULT_ORG_VIEW_NUMBER;
        }
        if (CollectionUtils.isEmpty((Collection)(allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)viewNumber, (long)orgId)))) {
            return new QFilter(PROP_CREATEORG_ID, "=", (Object)orgId);
        }
        allSuperiorOrgs.add(orgId);
        return new QFilter(PROP_CREATEORG_ID, "in", (Object)allSuperiorOrgs);
    }

    @Override
    public String createQAKMObject(String entityNumber, Long createOrgId, Object groupId, String question, String answer, Object associateKnlId) {
        JSONArray qaArray = new JSONArray();
        JSONObject qaJson = new JSONObject();
        qaJson.put("Q", (Object)question);
        qaJson.put("A", (Object)answer);
        qaJson.put("seq", (Object)0);
        qaArray.add((Object)qaJson);
        Map<Integer, String> errorInfos = this.batchCreateQAKMObject(entityNumber, createOrgId, groupId, qaArray, associateKnlId);
        if (errorInfos.isEmpty()) {
            return "";
        }
        return errorInfos.get(0);
    }

    @Override
    public Map<Integer, String> batchCreateQAKMObject(String entityNumber, Long createOrgId, Object groupId, JSONArray qaCol, Object associateKnlId) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMDataServiceImpl_1", (String)SYSTEM, (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)groupId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMDataServiceImpl_2", (String)SYSTEM, (Object[])new Object[0]));
        }
        if (null == qaCol || qaCol.isEmpty()) {
            return new HashMap<Integer, String>(0);
        }
        ArrayList<DynamicObject> qaKMObjs = new ArrayList<DynamicObject>(qaCol.size());
        int seq = 0;
        HashMap<Integer, String> errorInfos = new HashMap<Integer, String>(16);
        HashMap<Long, Integer> dataIdToSeqMap = new HashMap<Long, Integer>(qaCol.size());
        String questionEmptyMsg = ResManager.loadKDString((String)"\u95ee\u9898\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"KMDataServiceImpl_0", (String)SYSTEM, (Object[])new Object[0]);
        long userId = RequestContext.get().getCurrUserId();
        BaseModel baseModel = new BaseModel(entityNumber, "", new HashMap(0));
        for (Object qa : qaCol) {
            String answer_tag;
            DynamicObject obj = (DynamicObject)baseModel.createNewData();
            long id = ID.genLongId();
            obj.set(PROP_ID, (Object)id);
            String number = "QA-" + id;
            obj.set(PROP_NUMBER, (Object)number);
            obj.set(PROP_ENABLE, (Object)"1");
            obj.set(PROP_STATUS, (Object)"A");
            obj.set(PROP_UPLOAD_STATUS, (Object)"I");
            obj.set(PROP_CREATEORG, (Object)createOrgId);
            obj.set(PROP_GROUP_ID, groupId);
            obj.set(PROP_CREATOR, (Object)userId);
            obj.set(PROP_TYPE, (Object)"qa");
            JSONObject qaJson = (JSONObject)qa;
            String question_tag = (String)qaJson.getOrDefault((Object)"Q", (Object)"");
            Integer qaSeq = qaJson.getInteger("seq");
            if (null == qaSeq) {
                qaSeq = seq;
            }
            if (StringUtils.isBlank((CharSequence)question_tag)) {
                errorInfos.put(qaSeq, questionEmptyMsg);
                ++seq;
                continue;
            }
            dataIdToSeqMap.put(id, qaSeq);
            String question = question_tag;
            if (question_tag.length() > 200) {
                question = question_tag.substring(0, 200);
            }
            obj.set(PROP_NAME, (Object)question);
            obj.set(PROP_QUESTION_TAG, (Object)question_tag);
            obj.set(PROP_QUESTION, (Object)question);
            String answer = answer_tag = (String)qaJson.getOrDefault((Object)"A", (Object)"");
            if (answer.length() > 200) {
                answer = answer_tag.substring(0, 200);
            }
            obj.set(PROP_ANSWER_TAG, (Object)answer_tag);
            obj.set(PROP_ANSWER, (Object)answer);
            obj.set(PROP_ASSOCIATE_KNL, associateKnlId);
            qaJson.remove((Object)"seq");
            obj.set(PROP_INPUT_CONTENT, (Object)Collections.singletonList(qaJson).toString());
            qaKMObjs.add(obj);
            ++seq;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isNeedSplit", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])qaKMObjs.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!result.isSuccess()) {
            result.getAllErrorOrValidateInfo().stream().filter(info -> dataIdToSeqMap.containsKey(info.getPkValue())).forEach(info -> {
                int qaSeq = (Integer)dataIdToSeqMap.get(info.getPkValue());
                errorInfos.put(qaSeq, info.getMessage());
            });
        }
        return errorInfos;
    }

    @Override
    public Map<Integer, String> batchCreateQAKMObject(String QAEntityNumber, List<Map<String, Object>> qas) {
        ArrayList<DynamicObject> qaKMObjs = new ArrayList<DynamicObject>(qas.size());
        int seq = 0;
        HashMap<Integer, String> errorInfos = new HashMap<Integer, String>(16);
        HashMap<Long, Integer> dataIdToSeqMap = new HashMap<Long, Integer>(qas.size());
        long userId = RequestContext.get().getCurrUserId();
        for (Map<String, Object> qa : qas) {
            String answer_tag;
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)QAEntityNumber);
            long id = ID.genLongId();
            obj.set(PROP_ID, (Object)id);
            String number = "QA-" + id;
            obj.set(PROP_NUMBER, (Object)number);
            obj.set(PROP_ENABLE, (Object)"1");
            obj.set(PROP_STATUS, (Object)"A");
            obj.set(PROP_UPLOAD_STATUS, (Object)"I");
            obj.set(PROP_CREATEORG, qa.get("useOrg"));
            obj.set(PROP_GROUP_ID, qa.get("groupId"));
            obj.set(PROP_CREATOR, (Object)userId);
            obj.set(PROP_TYPE, (Object)"qa");
            String question_tag = (String)qa.get("Q");
            Integer qaSeq = (Integer)qa.get("seq");
            if (null == qaSeq) {
                qaSeq = seq;
            }
            dataIdToSeqMap.put(id, qaSeq);
            String question = question_tag;
            if (question_tag.length() > 200) {
                question = question_tag.substring(0, 200);
            }
            obj.set(PROP_NAME, (Object)question);
            obj.set(PROP_QUESTION_TAG, (Object)question_tag);
            obj.set(PROP_QUESTION, (Object)question);
            String answer = answer_tag = (String)qa.get("A");
            if (answer.length() > 200) {
                answer = answer_tag.substring(0, 200);
            }
            obj.set(PROP_ANSWER_TAG, (Object)answer_tag);
            obj.set(PROP_ANSWER, (Object)answer);
            obj.set(PROP_ASSOCIATE_KNL, qa.get("associateKnlId"));
            ArrayList qaList = new ArrayList(1);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("Q", question);
            map.put("A", answer);
            qaList.add(map);
            obj.set(PROP_INPUT_CONTENT, (Object)SerializationUtils.toJsonString(qaList));
            qaKMObjs.add(obj);
            ++seq;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isNeedSplit", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)QAEntityNumber, (DynamicObject[])qaKMObjs.toArray(new DynamicObject[0]), (OperateOption)option);
        if (!result.isSuccess()) {
            result.getAllErrorOrValidateInfo().stream().filter(info -> dataIdToSeqMap.containsKey(info.getPkValue())).forEach(info -> {
                int qaSeq = (Integer)dataIdToSeqMap.get(info.getPkValue());
                errorInfos.put(qaSeq, info.getMessage());
            });
        }
        return errorInfos;
    }

    @Override
    public boolean isKnlExsit(String kmNumber, Long groupId) {
        QFilter groupFilter;
        if (groupId == 0L) {
            groupFilter = null;
        } else {
            String groupEntityNumber = KMManageUtils.getKMGroupEntityNumber(kmNumber);
            List<Long> allGroupIds = this.getAllSubGroupIds(groupEntityNumber, groupId);
            groupFilter = new QFilter("group.id", "in", allGroupIds);
        }
        String docKMEntityNumber = KMManageUtils.getKMEntityNumber(kmNumber);
        if (StringUtils.isNotBlank((CharSequence)docKMEntityNumber) && QueryServiceHelper.exists((String)docKMEntityNumber, (QFilter[])new QFilter[]{groupFilter})) {
            return true;
        }
        String qaKMEntityNumber = KMManageUtils.getKMQAEntityNumber(kmNumber);
        return StringUtils.isNotBlank((CharSequence)qaKMEntityNumber) && QueryServiceHelper.exists((String)qaKMEntityNumber, (QFilter[])new QFilter[]{groupFilter});
    }

    @Override
    public DynamicObject getManagerByKMEntityNumber(String kmEntityNumber) {
        String kmEntityId = MetadataDao.getIdByNumber((String)kmEntityNumber, (MetaCategory)MetaCategory.Entity);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_KM_MANAGER, (QFilter[])new QFilter[]{new QFilter("kmentityid", "=", (Object)kmEntityId)});
    }

    @Override
    public DynamicObject getManagerByQAEntityNumber(String qaEntityNumber) {
        String qaEntityId = MetadataDao.getIdByNumber((String)qaEntityNumber, (MetaCategory)MetaCategory.Entity);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_KM_MANAGER, (QFilter[])new QFilter[]{new QFilter("kmqaentityid", "=", (Object)qaEntityId)});
    }

    @Override
    public DynamicObject getManagerByGroupEntityNumber(String groupEntityNumber) {
        String groupEntityId = MetadataDao.getIdByNumber((String)groupEntityNumber, (MetaCategory)MetaCategory.Entity);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_KM_MANAGER, (QFilter[])new QFilter[]{new QFilter("kmgroupentityid", "=", (Object)groupEntityId)});
    }

    @Override
    public List<Long> getAllSubGroupIds(String groupEntityNumber, Long groupId) {
        DynamicObject queryGroup = QueryServiceHelper.queryOne((String)groupEntityNumber, (String)"longnumber", (QFilter[])new QFilter[]{new QFilter(PROP_ID, "=", (Object)groupId)});
        if (null == queryGroup) {
            return new ArrayList<Long>(0);
        }
        String longNumber = queryGroup.getString("longnumber");
        String longNumberDLM = this.getLongNumberDLM(groupEntityNumber);
        QFilter filter = new QFilter("longnumber", "like", (Object)(longNumber + longNumberDLM + "%"));
        DynamicObjectCollection subGroups = QueryServiceHelper.query((String)groupEntityNumber, (String)PROP_ID, (QFilter[])new QFilter[]{filter});
        ArrayList<Long> result = new ArrayList<Long>(subGroups.size() + 1);
        result.add(groupId);
        if (!subGroups.isEmpty()) {
            result.addAll(subGroups.stream().map(g -> g.getLong(PROP_ID)).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public List<Long> getAccessibleGroupIds(String groupEntityNumber) {
        long userId = RequestContext.get().getCurrUserId();
        List userOrgIds = UserServiceHelper.getOrgsUserJoin((long)userId);
        Set userRoleIds = PermissionServiceHelper.getRolesByUser((Long)userId);
        log.info(String.format("current user: id:%1s,userOrgIds:%2s,userRoleIds:%2s", userId, userOrgIds, userRoleIds));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)groupEntityNumber, (String)"visiblerole_tag, visibleorg_tag, visibleuser_tag, effectivelogic, visiblerange", null);
        ArrayList<Long> accessibleGroupIds = new ArrayList<Long>();
        for (DynamicObject group : dynamicObjects) {
            boolean hasAccess;
            Long groupId = group.getLong(PROP_ID);
            String visibleRange = group.getString("visiblerange");
            if ("public".equals(visibleRange)) {
                accessibleGroupIds.add(groupId);
                continue;
            }
            String visibleRoles = group.getString("visiblerole_tag");
            String visibleOrgs = group.getString("visibleorg_tag");
            String visibleUsers = group.getString("visibleuser_tag");
            String effectiveLogic = group.getString("effectivelogic");
            log.info(String.format("visible: visibleRoles:%1s,visibleOrgs:%2s,visibleUsers:%2s", visibleRoles, visibleOrgs, visibleUsers));
            if (!(visibleRoles != null && !visibleRoles.isEmpty() || visibleOrgs != null && !visibleOrgs.isEmpty() || visibleUsers != null && !visibleUsers.isEmpty())) continue;
            boolean userMatch = false;
            boolean orgMatch = false;
            boolean roleMatch = false;
            if (visibleUsers != null && !visibleUsers.isEmpty()) {
                for (String userIdStr : visibleUsers.split(",")) {
                    try {
                        if (Long.parseLong(userIdStr.trim()) != userId) continue;
                        userMatch = true;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (visibleOrgs != null && !visibleOrgs.isEmpty()) {
                String[] orgIdArray;
                for (String orgIdStr : orgIdArray = visibleOrgs.split(",")) {
                    try {
                        Long orgId = Long.parseLong(orgIdStr.trim());
                        if (!userOrgIds.contains(orgId)) continue;
                        orgMatch = true;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (visibleRoles != null && !visibleRoles.isEmpty()) {
                String[] roleIdArray;
                for (String roleIdStr : roleIdArray = visibleRoles.split(",")) {
                    try {
                        if (!userRoleIds.contains(roleIdStr.trim())) continue;
                        roleMatch = true;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if ("1".equals(effectiveLogic)) {
                hasAccess = true;
                if (visibleUsers != null && !visibleUsers.isEmpty() && !userMatch) {
                    hasAccess = false;
                }
                if (hasAccess && visibleOrgs != null && !visibleOrgs.isEmpty() && !orgMatch) {
                    hasAccess = false;
                }
                if (hasAccess && visibleRoles != null && !visibleRoles.isEmpty() && !roleMatch) {
                    hasAccess = false;
                }
            } else {
                boolean bl = hasAccess = userMatch || orgMatch || roleMatch;
            }
            if (!hasAccess) continue;
            accessibleGroupIds.add(groupId);
        }
        log.info(String.format("accessibleGroupIds: %1s,", accessibleGroupIds));
        if (accessibleGroupIds.isEmpty()) {
            accessibleGroupIds.add(-1L);
        }
        return accessibleGroupIds;
    }

    private String getLongNumberDLM(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (entityType.getProperties().containsKey((Object)"parent")) {
            ParentBasedataProp parentProp = (ParentBasedataProp)entityType.getProperty("parent");
            return parentProp.getLongNumberDLM();
        }
        return ".";
    }
}

