/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.ai.km.service.KMDataService;
import kd.ai.km.utils.EntityUtils;
import kd.ai.km.utils.KMJobTaskUtils;
import kd.ai.km.utils.KMManageUtils;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.FilterControlContext;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;

public class KMBaseListPlugin
extends AbstractTreeListPlugin {
    private static final String SYSTEM = "ai-km";
    private static final String ENTITY_KM_MANAGER = "aikm_knl_manager";
    private static final String CUSTOMFILTER = "customfilter";
    private static final String FILTER_COLUMN_USEORG_FIELD = "org.id";
    private static final String BTN_QA_NEW = "tblqanew";
    private static final String BTN_ASSOCIATE_KNL = "associateknl";
    private static final String BTN_IMPORT_KNL = "importknl";
    private static final String BTN_IMPORT_QA = "importkmqa";
    private static final String BTN_GEN_QA = "genqa";
    private static final String TREE_BTN_NEW = "btngroupnew";
    private static final String TREE_BTN_EDIT = "btngroupedit";
    private static final String TREE_BTN_DELETE = "btngroupdel";
    private static final String FORM_KNL_GROUP_EDIT = "aikm_knl_menutree_edit";
    private static final String PARAM_USEORG = "useOrg";
    private static final String PARAM_GROUP_ID = "groupId";
    private static final String PARAM_CURRENT_GROUP_ID = "currentGroupId";
    private static final String PARAM_GROUP_STATUS = "status";
    private static final String PARAM_GROUP_ENTITY = "groupEntity";
    private static final String OPERATE_GROUP_NEW = "new";
    private static final String OPERATE_GROUP_EDIT = "edit";
    private static final String IMPORT_KNL = "importknl";
    private static final String IMPORTKMQA = "importkmqa";
    private static final String AIKM_KNL_QA_IMPORT = "aikm_knl_qa_import";
    private static final String PROP_ASSOCIATE_ID = "associateknl.id";
    private static final String COLUMN_ASSOCIATE_NAME = "associateknl_name";
    private static final String BILLLISTAP = "billlistap";
    private static final String CALLBACK_GROUP_EDIT = "callBackGroupEdit";
    private static final String CALLBACK_QA_EDIT = "callBackQAEdit";
    private static final String CALLBACK_ASSOCIATE_KNL = "callBackAssociateKnl";
    private static final String CALLBACK_DELETE_TREE_NODE = "callBackDeleteTreeNode";
    private static final String CALLBACK_TASK_GEN_QA = "taskGenQA";
    private static final String CACHE_OPENED_QA_DATA_ID = "openedQADataId";
    private static final String SIMDETECT = "simidetect";
    private static final String CALLBACK_TASK_GEN_INDEX = "CALLBACK_TASK_GENINDEX";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{TREE_BTN_NEW, TREE_BTN_EDIT, TREE_BTN_DELETE});
        this.addItemClickListeners(new String[]{BTN_QA_NEW, "importkmqa", BTN_QA_NEW, BTN_GEN_QA, SIMDETECT});
    }

    public void afterCreateNewData(EventObject e) {
        boolean selectQATab = this.getView().getFormShowParameter().getCustomParams().containsKey("showQAList");
        if (selectQATab) {
            Tab tab = (Tab)this.getControl("tabap");
            tab.activeTab("tabqa");
        }
    }

    public void afterBindData(EventObject e) {
        ITreeModel treeModel = this.getTreeModel();
        String groupEntity = treeModel.getGroupProp().getBaseEntityId();
        TreeNode root = treeModel.getRoot();
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(10);
        this.collectChildrenNodes(root, children);
        List<TreeNodeLabel> publicTreeNodeLabel = Collections.singletonList(new TreeNodeLabel(ResManager.loadKDString((String)"\u516c\u5f00", (String)"KMBaseListPlugin_11", (String)SYSTEM, (Object[])new Object[0]), "#26B175"));
        List<TreeNodeLabel> specifyTreeNodeLabel = Collections.singletonList(new TreeNodeLabel(ResManager.loadKDString((String)"\u6307\u5b9a", (String)"KMBaseListPlugin_12", (String)SYSTEM, (Object[])new Object[0]), "#FF991C"));
        List<String> publicGroupIds = this.getPublicGroupIds(groupEntity);
        for (TreeNode treeNode : children) {
            String id = treeNode.getId();
            List labelPara = treeNode.getLabelPara();
            if (CollectionUtils.isNotEmpty((Collection)labelPara)) continue;
            treeNode.setLabelShowType(1);
            treeNode.setLabelPara(publicGroupIds.contains(id) ? publicTreeNodeLabel : specifyTreeNodeLabel);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.getTreeListView().focusRootNode();
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        FilterControlContext context = filterContainer.getContext().getFilterControlContext();
        if (context.isTriggerSearch()) {
            this.getTreeListView().refreshTreeView();
        }
    }

    public void setFilter(SetFilterEvent e) {
        String useOrg;
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        if (lsp.isLookUp() && StringUtils.isNotBlank((CharSequence)(useOrg = (String)lsp.getCustomParam(PARAM_USEORG)))) {
            Long useOrgId = Long.parseLong(useOrg);
            e.addCustomQFilter(new QFilter(FILTER_COLUMN_USEORG_FIELD, "=", (Object)useOrgId));
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String useOrg;
        TreeListModel treeModel = (TreeListModel)this.getTreeModel();
        treeModel.getQueryParas().put("order", "id");
        ListShowParameter lsp = (ListShowParameter)this.getView().getFormShowParameter();
        Long useOrgId = RequestContext.get().getOrgId();
        if (lsp.isLookUp()) {
            useOrg = (String)lsp.getCustomParam(PARAM_USEORG);
            if (StringUtils.isNotBlank((CharSequence)useOrg)) {
                useOrgId = Long.parseLong(useOrg);
            }
        } else {
            useOrg = this.getPageCache().get(PARAM_USEORG);
            useOrgId = StringUtils.isBlank((CharSequence)useOrg) ? RequestContext.get().getOrgId() : Long.parseLong(useOrg);
        }
        QFilter groupFilter = new QFilter("createorg.id", "=", (Object)useOrgId);
        this.getTreeModel().getTreeFilter().add(groupFilter);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String formId;
        BillShowParameter parameter = e.getParameter();
        TreeView treeView = this.getTreeListView().getTreeView();
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isNotBlank((CharSequence)focusNodeId) && !StringUtils.equals((CharSequence)focusNodeId, (CharSequence)this.getTreeModel().getRoot().getId())) {
            parameter.setCustomParam(PARAM_GROUP_ID, (Object)focusNodeId);
        }
        if (StringUtils.isNotBlank((CharSequence)(formId = parameter.getFormId())) && formId.endsWith("_qa")) {
            String openedQAId = (String)cache.get("openedQADataId_" + this.getView().getPageId());
            Object currentQAId = parameter.getPkId();
            if (StringUtils.isNotBlank((CharSequence)openedQAId) && StringUtils.isNotBlank((Object)currentQAId) && StringUtils.equals((CharSequence)openedQAId, (CharSequence)currentQAId.toString())) {
                e.setCancel(true);
                return;
            }
            cache.put("openedQADataId_" + this.getView().getPageId(), (Object)(StringUtils.isBlank((Object)currentQAId) ? "0" : currentQAId.toString()));
            parameter.getOpenStyle().setShowType(ShowType.PageDrawer);
            StyleCss css = new StyleCss();
            css.setWidth("30%");
            parameter.getOpenStyle().setInlineStyleCss(css);
            parameter.getOpenStyle().setPlaceholder(false);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_QA_EDIT));
            parameter.setCaption(ResManager.loadKDString((String)"\u95ee\u7b54\u5bf9", (String)"KMBaseListPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Vector) {
            String key = ((Vector)source).getKey();
            String rootId = this.getTreeModel().getRoot().getId();
            String focusNodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
            if (TREE_BTN_EDIT.equals(key) && StringUtils.equals((CharSequence)focusNodeId, (CharSequence)rootId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u7f16\u8f91\u3002", (String)"KMBaseListPlugin_9", (String)SYSTEM, (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (TREE_BTN_DELETE.equals(key)) {
                DynamicObject managerNumber;
                if (StringUtils.equals((CharSequence)focusNodeId, (CharSequence)rootId)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"KMBaseListPlugin_10", (String)SYSTEM, (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String kmEntityId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                KMDataService kmDataService = KMDataService.create();
                boolean knlExsit = kmDataService.isKnlExsit((managerNumber = kmEntityId.endsWith("_qa") ? kmDataService.getManagerByQAEntityNumber(kmEntityId) : kmDataService.getManagerByKMEntityNumber(kmEntityId)).getString("number"), Long.parseLong(focusNodeId));
                if (knlExsit) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4e0b\u5b58\u5728\u77e5\u8bc6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"KMBaseListPlugin_6", (String)SYSTEM, (Object[])new Object[0]));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector) {
            String key = ((Vector)source).getKey();
            if (TREE_BTN_NEW.equals(key) || TREE_BTN_EDIT.equals(key)) {
                String useOrg = this.getPageCache().get(PARAM_USEORG);
                if (StringUtils.isBlank((CharSequence)useOrg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"KMBaseListPlugin_0", (String)SYSTEM, (Object[])new Object[0]));
                    return;
                }
                TreeView treeView = this.getTreeListView().getTreeView();
                String focusNodeId = treeView.getTreeState().getFocusNodeId();
                String rootId = this.getTreeModel().getRoot().getId();
                String groupEntity = this.getTreeModel().getGroupProp().getBaseEntityId();
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId(FORM_KNL_GROUP_EDIT);
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCustomParam(PARAM_USEORG, (Object)useOrg);
                fsp.setCustomParam(PARAM_GROUP_ENTITY, (Object)groupEntity);
                if (StringUtils.isNotBlank((CharSequence)focusNodeId) && !StringUtils.equals((CharSequence)rootId, (CharSequence)focusNodeId)) {
                    fsp.setCustomParam(PARAM_CURRENT_GROUP_ID, (Object)focusNodeId);
                }
                fsp.setCustomParam(PARAM_GROUP_STATUS, (Object)(TREE_BTN_EDIT.equals(key) ? OPERATE_GROUP_EDIT : OPERATE_GROUP_NEW));
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_GROUP_EDIT));
                this.getView().showForm(fsp);
            } else if (TREE_BTN_DELETE.equals(key)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u9009\u62e9\u5206\u7ec4\u5c06\u540c\u6b65\u5220\u9664\u6240\u6709\u4e0b\u7ea7\u5206\u7ec4\uff0c\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"KMBaseListPlugin_7", (String)SYSTEM, (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CALLBACK_DELETE_TREE_NODE));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String permName;
        String entityNumber;
        boolean hasPerm;
        String itemKey = evt.getItemKey();
        if (BTN_QA_NEW.equals(itemKey)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            String rootId = this.getTreeModel().getRoot().getId();
            if (StringUtils.isBlank((CharSequence)focusNodeId) || StringUtils.equals((CharSequence)focusNodeId, (CharSequence)rootId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u8282\u70b9\u3002", (String)"KMBaseListPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else if (BTN_ASSOCIATE_KNL.equals(itemKey)) {
            String permName2;
            String entityNumber2;
            boolean hasPerm2;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (null == selectedRows || selectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"KMBaseListPlugin_3", (String)SYSTEM, (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (!(hasPerm2 = this.validatePerm(entityNumber2 = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), "4715a0df000000ac", permName2 = ResManager.loadKDString((String)"\u4fee\u6539", (String)"KMBaseListPlugin_15", (String)SYSTEM, (Object[])new Object[0])))) {
                evt.setCancel(true);
            }
        } else if (("importknl".equals(itemKey) || "importkmqa".equals(itemKey) || BTN_GEN_QA.equals(itemKey)) && !(hasPerm = this.validatePerm(entityNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId(), "47156aff000000ac", permName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"KMBaseListPlugin_14", (String)SYSTEM, (Object[])new Object[0])))) {
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "importkmqa": {
                this.importQaForm();
                break;
            }
            case "genqa": {
                ListSelectedRowCollection listSelectedRows = ((IListView)this.getView()).getSelectedRows();
                if (listSelectedRows == null || listSelectedRows.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u3002", (String)"FieldsSelectF7Plugin_1", (String)SYSTEM, (Object[])new Object[0]));
                    return;
                }
                Object[] ids = listSelectedRows.getPrimaryKeyValues();
                String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                FormShowParameter parameter = new FormShowParameter();
                parameter.setCustomParam("knlIds", Arrays.asList(ids));
                parameter.setCustomParam("entityNumber", (Object)billFormId);
                String QAEntityNumber = EntityUtils.getBilllistBindEntityId(billFormId, BILLLISTAP);
                parameter.setCustomParam("qaEntityNumber", (Object)QAEntityNumber);
                parameter.setCustomParam("callBackPlugin", (Object)this.getPluginName());
                parameter.setCustomParam("canBackground", (Object)"true");
                String useOrg = this.getPageCache().get(PARAM_USEORG);
                parameter.setCustomParam(PARAM_USEORG, (Object)useOrg);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getPageCache().put("genQAConfigParams_" + this.getView().getPageId(), SerializationUtils.toJsonString((Object)parameter.getCustomParams()));
                parameter.setFormId("aikm_genqa_config");
                this.getView().showForm(parameter);
                break;
            }
            case "associateknl": {
                this.selectAssociateKnl();
                break;
            }
            case "simidetect": {
                this.similarDetect();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operationKey;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operationKey = operate.getOperateKey()) {
            case "delete": {
                String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
                String bindEntityId = EntityUtils.getBilllistBindEntityId(billFormId, BILLLISTAP);
                if (!StringUtils.isNotBlank((CharSequence)bindEntityId)) break;
                operate.getOption().setVariableValue("bindentityid", bindEntityId);
                break;
            }
            case "save": 
            case "submit": {
                operate.getOption().setVariableValue("pageid", this.getView().getPageId());
                operate.getOption().setVariableValue("pluginname", this.getPluginName());
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (COLUMN_ASSOCIATE_NAME.equals(fieldName)) {
            args.setCancel(true);
            ListSelectedRow currentRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
            Object qaKnlId = currentRow.getPrimaryKeyValue();
            String billFormId = ((ListView)this.getView()).getBillFormId();
            DynamicObject qaKnlObj = QueryServiceHelper.queryOne((String)billFormId, (String)PROP_ASSOCIATE_ID, (QFilter[])new QFilter[]{new QFilter("id", "=", qaKnlId)});
            if (null != qaKnlObj) {
                Object associateKnlId = qaKnlObj.get(PROP_ASSOCIATE_ID);
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId(billFormId.substring(0, billFormId.length() - 3));
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.setPkId(associateKnlId);
                fsp.setStatus(OperationStatus.VIEW);
                fsp.setBillStatus(BillOperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)fsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        switch (actionId) {
            case "callBackGroupEdit": {
                if (!"dook".equals(returnData)) break;
                this.getTreeListView().focusRootNode();
                this.getTreeListView().refreshTreeView();
                break;
            }
            case "callBackQAEdit": {
                BillList billList = (BillList)this.getControl(BILLLISTAP);
                billList.refresh();
                break;
            }
            case "callBackAssociateKnl": {
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRow selectedDocKnl = ((ListSelectedRowCollection)returnData).get(0);
                this.associateKnlToQA(selectedDocKnl.getPrimaryKeyValue());
                break;
            }
            case "taskGenQA": {
                if (returnData == null) break;
                this.showGenQAResult(returnData);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CALLBACK_DELETE_TREE_NODE.equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String groupEntityId = this.getTreeModel().getGroupProp().getBaseEntityId();
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            List<Long> allSubGroupIds = KMDataService.create().getAllSubGroupIds(groupEntityId, Long.parseLong(focusNodeId));
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)groupEntityId, (Object[])allSubGroupIds.toArray(), (OperateOption)OperateOption.create());
            if (!deleteResult.isSuccess()) {
                this.getView().showTipNotification(deleteResult.getMessage());
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"KMBaseListPlugin_8", (String)SYSTEM, (Object[])new Object[0]));
            this.getTreeListView().focusRootNode();
            this.getTreeListView().refresh();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        cache.remove("openedQADataId_" + this.getView().getPageId());
    }

    private List<String> getPublicGroupIds(String entityNumber) {
        DynamicObjectCollection groups = QueryServiceHelper.query((String)entityNumber, (String)"id,visiblerange", null);
        if (groups.isEmpty()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> groupIds = new ArrayList<String>(groups.size());
        for (DynamicObject group : groups) {
            String visibleRange = group.getString("visiblerange");
            if (!"public".equals(visibleRange)) continue;
            groupIds.add(group.getString("id"));
        }
        return groupIds;
    }

    private void collectChildrenNodes(TreeNode node, List<TreeNode> allNodes) {
        List children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        allNodes.addAll(children);
        for (TreeNode child : children) {
            this.collectChildrenNodes(child, allNodes);
        }
    }

    private void importQaForm() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String formId = formShowParameter.getBillFormId();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCustomParam("formId", (Object)formId);
        String useOrg = this.getPageCache().get(PARAM_USEORG);
        showParameter.setCustomParam(PARAM_USEORG, (Object)useOrg);
        TreeView treeView = (TreeView)this.getControl("treeview");
        if (null != treeView) {
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            String rootId = this.getTreeModel().getRoot().getId();
            if (StringUtils.isBlank((CharSequence)focusNodeId) || StringUtils.equals((CharSequence)focusNodeId, (CharSequence)rootId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7ec4\u8282\u70b9\u3002", (String)"KMBaseListPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
                return;
            }
            showParameter.setCustomParam(PARAM_GROUP_ID, (Object)focusNodeId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(AIKM_KNL_QA_IMPORT);
        this.getView().showForm(showParameter);
    }

    private void selectAssociateKnl() {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String qaKMEntityNumber = formShowParameter.getBillFormId();
        String qaKMEntityid = MetadataDao.getIdByNumber((String)qaKMEntityNumber, (MetaCategory)MetaCategory.Entity);
        DynamicObject managerData = QueryServiceHelper.queryOne((String)ENTITY_KM_MANAGER, (String)"kmentityid", (QFilter[])new QFilter[]{new QFilter("kmqaentityid", "=", (Object)qaKMEntityid)});
        if (null == managerData) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u77e5\u8bc6\u5e93\u4fe1\u606f\u3002", (String)"KMBaseListPlugin_5", (String)SYSTEM, (Object[])new Object[0]));
        }
        String docKMEntityId = managerData.getString("kmentityid");
        String docKMEntityNumber = MetadataDao.getNumberById((String)docKMEntityId);
        ListShowParameter docKnlSelectF7 = ShowFormHelper.createShowListForm((String)docKMEntityNumber, (boolean)false);
        docKnlSelectF7.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_ASSOCIATE_KNL));
        String useOrg = this.getPageCache().get(PARAM_USEORG);
        docKnlSelectF7.setCustomParam(PARAM_USEORG, (Object)useOrg);
        this.getView().showForm((FormShowParameter)docKnlSelectF7);
    }

    private void associateKnlToQA(Object knlId) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (null == selectedRows || selectedRows.isEmpty()) {
            return;
        }
        List selectedQAIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String qaKMEntityNumber = formShowParameter.getBillFormId();
        DynamicObject[] qaKnlDatas = BusinessDataServiceHelper.load((Object[])selectedQAIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)qaKMEntityNumber));
        KMDataService kmDataService = KMDataService.create();
        DynamicObject manager = kmDataService.getManagerByQAEntityNumber(qaKMEntityNumber);
        String kmEntityNumber = KMManageUtils.getKMEntityNumber(manager.getString("number"));
        DynamicObject kmData = QueryServiceHelper.queryOne((String)kmEntityNumber, (String)"expiretime", (QFilter[])new QFilter[]{new QFilter("id", "=", knlId)});
        Object expireTime = kmData.get("expiretime");
        for (DynamicObject qaKnlData : qaKnlDatas) {
            qaKnlData.set(BTN_ASSOCIATE_KNL, knlId);
            if (null == expireTime) continue;
            qaKnlData.set("expiretime", expireTime);
        }
        SaveServiceHelper.update((DynamicObject[])qaKnlDatas);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u77e5\u8bc6\u6210\u529f\u3002", (String)"KMBaseListPlugin_4", (String)SYSTEM, (Object[])new Object[0]));
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        billList.refresh();
    }

    private boolean validatePerm(String entityNumber, String permItem, String permName) {
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)entityNumber, (String)permItem);
        if (!hasPerm) {
            String msg = ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"KMBaseListPlugin_13", (String)SYSTEM, (Object[])new Object[0]);
            String entityId = MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Entity);
            if (StringUtils.isBlank((CharSequence)entityId)) {
                return true;
            }
            QFilter filter = new QFilter("kmentityid", "=", (Object)entityId);
            filter.or("kmqaentityid", "=", (Object)entityId);
            DynamicObject manager = QueryServiceHelper.queryOne((String)ENTITY_KM_MANAGER, (String)"name", (QFilter[])new QFilter[]{filter});
            if (null == manager) {
                return true;
            }
            this.getView().showErrorNotification(String.format(msg, manager.getString("name"), permName));
            return false;
        }
        return true;
    }

    private void showGenQAResult(Object returnData) {
        List errorInfoList;
        String success = KMJobTaskUtils.getJobTaskParam(returnData, "success");
        String errorInfos = KMJobTaskUtils.getJobTaskParam(returnData, "errorInfos");
        if (!"true".equals(success)) {
            if (StringUtils.isBlank((CharSequence)errorInfos)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"KMBaseListPlugin_16", (String)SYSTEM, (Object[])new Object[0]));
            } else {
                List errorInfoList2 = (List)SerializationUtils.fromJsonString((String)errorInfos, List.class);
                String title = ResManager.loadKDString((String)"\u751f\u6210\u5931\u8d25", (String)"KMBaseListPlugin_17", (String)SYSTEM, (Object[])new Object[0]);
                this.getView().showMessage(title, String.join((CharSequence)"\n", errorInfoList2), MessageTypes.Default);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)errorInfos) && null != (errorInfoList = (List)SerializationUtils.fromJsonString((String)errorInfos, List.class)) && !errorInfoList.isEmpty()) {
            String title = ResManager.loadKDString((String)"\u90e8\u5206\u77e5\u8bc6\u751f\u6210\u5931\u8d25", (String)"KMBaseListPlugin_18", (String)SYSTEM, (Object[])new Object[0]);
            this.getView().showMessage(title, String.join((CharSequence)"\n", errorInfoList), MessageTypes.Default);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("aikm_genqa_result");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("pageId", (Object)this.getView().getPageId());
        fsp.setCustomParam("kmEntityNumber", (Object)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
        fsp.setCustomParam(PARAM_USEORG, (Object)this.getView().getPageCache().get(PARAM_USEORG));
        fsp.setCustomParam("prompt", (Object)KMJobTaskUtils.getJobTaskParam(returnData, "prompt"));
        fsp.setCustomParam("lastConfigs", (Object)KMJobTaskUtils.getJobTaskParam(returnData, "lastConfigs"));
        fsp.setCustomParam("securityPrompt", (Object)KMJobTaskUtils.getJobTaskParam(returnData, "securityPrompt"));
        fsp.setCustomParam("genCount", (Object)KMJobTaskUtils.getJobTaskParam(returnData, "genCount"));
        this.getView().showForm(fsp);
    }

    private void similarDetect() {
        if (this.getView() instanceof ListView && ((ListView)this.getView()).getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u68c0\u6d4b\u7684\u95ee\u7b54\u5bf9\u3002", (String)"KMBaseListPlugin_2", (String)SYSTEM, (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("aikm_similarity_issue");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        ListShowParameter currentListShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entityNumber = currentListShowParameter.getBillFormId();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            formShowParameter.setCustomParam("entitynumber", (Object)entityNumber);
        }
        Object[] selectedIds = ((ListView)this.getView()).getSelectedRows().getPrimaryKeyValues();
        formShowParameter.setCustomParam("selectedids", (Object)selectedIds);
        this.getView().showForm(formShowParameter);
    }
}

