/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.tpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class KMBaseQAFormPlugin
extends AbstractFormPlugin {
    private static final String SYSTEM = "ai-km";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_QUESTION = "question_tag";
    private static final String FIELD_ANSWER = "answer_tag";
    private static final String FIELD_SPLIT_TYPE = "type";
    private static final String FIELD_CREATEORG = "org";
    private static final String FIELD_GROUP = "group";
    private static final String FIELD_ASSOCIATE_KNL = "associateknl";
    private static final String FIELD_EXPIRETIME = "expiretime";
    private static final String LABEL_WORD_COUNT = "wordcount";
    private static final String PARAM_USEORG = "useOrg";
    private static final String PARAM_GROUP_ID = "groupId";
    private static final String CACHE_OPENED_QA_DATA_ID = "openedQADataId";
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, true));

    public void registerListener(EventObject e) {
        BasedataEdit associateKnlEdit = (BasedataEdit)this.getControl(FIELD_ASSOCIATE_KNL);
        Date currentDate = new Date();
        String useOrg = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_USEORG);
        associateKnlEdit.addBeforeF7SelectListener(evt -> {
            QFilter filter = new QFilter(FIELD_EXPIRETIME, "is null", null);
            filter.or(FIELD_EXPIRETIME, ">", (Object)currentDate);
            evt.setCustomQFilters(Collections.singletonList(filter));
            ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
            lsp.setShowApproved(false);
            lsp.setCustomParam(PARAM_USEORG, (Object)useOrg);
        });
        this.addClickListeners(new String[]{"editap", "previewap"});
    }

    public void afterCreateNewData(EventObject e) {
        BillOperationStatus status;
        this.getModel().setValue(FIELD_SPLIT_TYPE, (Object)"qa");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            this.getModel().setValue(FIELD_ASSOCIATE_KNL, (Object)parentView.getModel().getDataEntity());
        }
        if ("ADDNEW".equals((status = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()).name())) {
            Markdown answerMarkDown = (Markdown)this.getControl("answermk");
            this.setMarkDownModelType(answerMarkDown, "edit");
        }
    }

    public void afterBindData(EventObject e) {
        BillOperationStatus status;
        this.updateWordCountLabel();
        this.getModel().beginInit();
        this.getModel().setValue(FIELD_SPLIT_TYPE, (Object)"qa");
        this.getModel().endInit();
        boolean lockAssociateKnle = this.getView().getFormShowParameter().getCustomParams().containsKey("lock_associateknl");
        if (lockAssociateKnle) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{FIELD_ASSOCIATE_KNL});
        }
        String answer = (String)this.getModel().getValue(FIELD_ANSWER);
        Markdown answerMarkDown = (Markdown)this.getControl("answermk");
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            answerMarkDown.setText(answer);
        }
        if ("ADDNEW".equals((status = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()).name())) {
            boolean hasResetQa = this.getView().getFormShowParameter().getCustomParams().containsKey("resetqa_addnew");
            if (!hasResetQa) {
                this.setMarkDownModelType(answerMarkDown, "edit");
            }
        } else {
            this.setMarkDownModelType(answerMarkDown, "preview");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (FIELD_QUESTION.equals(propName) || FIELD_ANSWER.equals(propName)) {
            this.updateWordCountLabel();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        Object source = args.getSource();
        if (source instanceof Save || source instanceof Submit) {
            this.setFieldsBeforeSave();
            JSONArray content = new JSONArray();
            JSONObject qaJson = new JSONObject();
            Object question = this.getModel().getValue(FIELD_QUESTION);
            Object answer = this.getModel().getValue(FIELD_ANSWER);
            qaJson.put("Q", (Object)question.toString());
            qaJson.put("A", (Object)(StringUtils.isBlank((Object)answer) ? "" : answer.toString()));
            content.add((Object)qaJson);
            this.getModel().setValue("inputcontent_tag", (Object)content.toJSONString());
        } else if (source instanceof Donothing && "resetqa".equals(opKey = ((Donothing)source).getOperateKey())) {
            this.resetQa();
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Markdown answerMarkDown = (Markdown)this.getControl("answermk");
            this.setMarkDownModelType(answerMarkDown, "preview");
            IFormView parentView = this.getView().getParentView();
            parentView.updateView("billlistap");
            this.getView().sendFormAction(parentView);
            String parentPageId = parentView.getFormShowParameter().getParentPageId();
            String cacheKey = "openedQADataId_" + parentPageId;
            if (!cache.contains(cacheKey) || "0".equals(cache.get(cacheKey))) {
                cache.put(cacheKey, (Object)this.getModel().getDataEntity().getPkValue().toString());
            }
        } else if ("audit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            IFormView parentView = this.getView().getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f\u3002", (String)"KMBaseQAFormPlugin_1", (String)SYSTEM, (Object[])new Object[0]));
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        cache.remove("openedQADataId_" + parentPageId);
    }

    private void updateWordCountLabel() {
        Object question = this.getModel().getValue(FIELD_QUESTION);
        Object answer = this.getModel().getValue(FIELD_ANSWER);
        int wordCount = 0;
        if (StringUtils.isNotBlank((Object)question) || StringUtils.isNotBlank((Object)answer)) {
            int questionLenth = StringUtils.isBlank((Object)question) ? 0 : ((String)question).length();
            int answerLenth = StringUtils.isBlank((Object)answer) ? 0 : ((String)answer).length();
            wordCount = questionLenth + answerLenth;
        }
        String msg = String.format(ResManager.loadKDString((String)"%d\u5b57\u7b26", (String)"KMBaseQAFormPlugin_0", (String)SYSTEM, (Object[])new Object[0]), wordCount);
        Label wordCountLabel = (Label)this.getControl(LABEL_WORD_COUNT);
        wordCountLabel.setText(msg);
    }

    private void setFieldsBeforeSave() {
        Object group;
        String question;
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            long id = ID.genLongId();
            this.getModel().setValue("id", (Object)id);
            String number = "QA-" + id;
            this.getModel().setValue(FIELD_NUMBER, (Object)number);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            this.getModel().setValue(FIELD_CREATEORG, (Object)customParams.getOrDefault(PARAM_USEORG, RequestContext.get().getOrgId()));
            this.getModel().setValue(FIELD_GROUP, customParams.getOrDefault(PARAM_GROUP_ID, null));
        }
        if (StringUtils.isNotBlank((CharSequence)(question = (String)this.getModel().getValue("question"))) && question.length() >= 200) {
            this.getModel().setValue(FIELD_NAME, (Object)question.substring(0, 200));
        } else {
            this.getModel().setValue(FIELD_NAME, (Object)question);
        }
        Object associateKnl = this.getModel().getValue(FIELD_ASSOCIATE_KNL);
        if (null != associateKnl) {
            this.getModel().setValue(FIELD_GROUP, ((DynamicObject)associateKnl).get(FIELD_GROUP));
            this.getModel().setValue(FIELD_CREATEORG, ((DynamicObject)associateKnl).get(FIELD_CREATEORG));
        }
        if (null == (group = this.getModel().getValue(FIELD_GROUP))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u5206\u7ec4\u3002", (String)"KMBaseQAFormPlugin_2", (String)SYSTEM, (Object[])new Object[0]));
        }
        Markdown markdown = (Markdown)this.getControl("answermk");
        String answer = markdown.getText();
        this.getModel().setValue(FIELD_ANSWER, (Object)answer);
        if (StringUtils.isNotBlank((CharSequence)answer) && answer.length() > 200) {
            this.getModel().setValue("answer", (Object)answer.substring(0, 200));
        } else {
            this.getModel().setValue("answer", (Object)answer);
        }
        int attachCount = ((DynamicObjectCollection)this.getModel().getValue("attachment")).size();
        this.getModel().setValue("attachcount", (Object)attachCount);
    }

    private void setMarkDownModelType(Markdown answerMk, String modelType) {
        if (answerMk == null || StringUtils.isBlank((CharSequence)modelType)) {
            return;
        }
        if ("preview".equals(modelType)) {
            answerMk.setModelType(Markdown.Preview);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"previewap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"editap"});
        } else if ("edit".equals(modelType)) {
            answerMk.setModelType(Markdown.Edit);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"previewap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"editap"});
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector) {
            String key = ((Vector)source).getKey();
            Markdown markdown = (Markdown)this.getControl("answermk");
            if ("editap".equals(key)) {
                this.setMarkDownModelType(markdown, "edit");
                String answer = (String)this.getModel().getValue(FIELD_ANSWER);
                if (StringUtils.isNotBlank((CharSequence)answer)) {
                    Markdown answerMarkDown = (Markdown)this.getControl("answermk");
                    answerMarkDown.setText(answer);
                }
            } else if ("previewap".equals(key)) {
                this.setMarkDownModelType(markdown, "preview");
            }
        }
    }

    private void resetQa() {
        BillOperationStatus status = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if ("ADDNEW".equals(status.name())) {
            this.getModel().setValue("question", null);
            this.getModel().setValue(FIELD_QUESTION, null);
            this.getModel().setValue("answer", null);
            this.getModel().setValue(FIELD_ANSWER, null);
            Markdown answerMarkDown = (Markdown)this.getControl("answermk");
            answerMarkDown.setText(null);
            this.setMarkDownModelType(answerMarkDown, "preview");
            this.getView().getFormShowParameter().setCustomParam("resetqa_addnew", (Object)"true");
        } else {
            Object fid = ((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
            Map result = BusinessDataReader.loadFromCache((Object[])new Object[]{fid}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()));
            DynamicObject crrentDyObj = (DynamicObject)result.get(fid);
            if (crrentDyObj != null) {
                this.getModel().setValue("question", crrentDyObj.get("question"));
                this.getModel().setValue(FIELD_QUESTION, crrentDyObj.get(FIELD_QUESTION));
                this.getModel().setValue("answer", crrentDyObj.get("answer"));
                this.getModel().setValue(FIELD_ANSWER, crrentDyObj.get(FIELD_ANSWER));
                Markdown answerMarkDown = (Markdown)this.getControl("answermk");
                answerMarkDown.setText(crrentDyObj.getString(FIELD_ANSWER));
            }
        }
    }
}

