/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.km.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.km.openapi.AIKMAPIService;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.gptas.api.km.DocParser;
import kd.bos.gptas.api.km.ParseListener;
import kd.bos.gptas.kmbase.parser.FileParseFactory;
import kd.bos.gptas.kmbase.utils.KnowledgeUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;

public class KMManager {
    private static final String SYSTEM_TYPE = "bos-gptas-km";
    private static final FileService fileService;
    private static final List<String> forbiddenExtensions;
    private static final Log logger;
    private final DynamicObject repo;
    private String kmEntityNumber = null;
    private String kmGroupNumber = null;
    private String qaEntityNumber = null;
    private MainEntityType kmEntityType = null;
    private MainEntityType kmGroupEntityType = null;
    private ParseListener parseListener = null;

    public KMManager(Long repoId) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"aikm_knl_manager");
        Map repoData = BusinessDataReader.loadFromCache((Object[])new Object[]{repoId}, (DynamicObjectType)dataEntityType);
        this.repo = (DynamicObject)repoData.get(repoId);
        if (this.repo == null) {
            throw new KDBizException(new ErrorCode("102", ResManager.loadKDString((String)"\u77e5\u8bc6\u5e93\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AIKMAPIService_0", (String)SYSTEM_TYPE, (Object[])new Object[0])), new Object[0]);
        }
    }

    public String getKMEntityId() {
        return this.repo.getString("kmentityid");
    }

    public String getKMEntityNumber() {
        if (this.kmEntityNumber == null) {
            this.kmEntityNumber = MetadataDao.getNumberById((String)this.repo.getString("kmentityid"));
        }
        return this.kmEntityNumber;
    }

    public String getKMGroupEntityId() {
        return this.repo.getString("kmgroupentityid");
    }

    public String getKMGroupEntityNumber() {
        if (this.kmGroupNumber == null) {
            this.kmGroupNumber = MetadataDao.getNumberById((String)this.repo.getString("kmgroupentityid"));
        }
        return this.kmGroupNumber;
    }

    public MainEntityType getKMGroupEntityType() {
        if (this.kmGroupEntityType == null) {
            this.kmGroupEntityType = EntityMetadataCache.getDataEntityType((String)this.getKMGroupEntityNumber());
        }
        return this.kmGroupEntityType;
    }

    public MainEntityType getKMEntityType() {
        if (this.kmEntityType == null) {
            this.kmEntityType = EntityMetadataCache.getDataEntityType((String)this.getKMEntityNumber());
        }
        return this.kmEntityType;
    }

    public String getQAEntityNumber() {
        if (this.qaEntityNumber == null) {
            this.qaEntityNumber = MetadataDao.getNumberById((String)this.repo.getString("kmqaentityid"));
        }
        return this.qaEntityNumber;
    }

    public Long save(Long groupId, String fileName, byte[] fileData, Consumer<DynamicObject> saveData) {
        Long knlId = ID.genLongId();
        return this.save(knlId, groupId, fileName, fileData, saveData);
    }

    public Long save(Long id, Long groupId, String fileName, byte[] fileData, Consumer<DynamicObject> saveData) {
        OperationResult operationResult;
        String hash = DigestUtils.sha256Hex((byte[])fileData);
        DynamicObject data = new DynamicObject((DynamicObjectType)this.getKMEntityType());
        data.set("id", (Object)id);
        data.set("number", (Object)("doc-" + id));
        data.set("name", (Object)fileName);
        if (fileName.endsWith(".xls") || fileName.endsWith(".xlsx")) {
            data.set("type", (Object)"excel");
        } else {
            data.set("type", (Object)"common");
        }
        data.set("status", (Object)"A");
        data.set("group_id", (Object)groupId);
        data.set("org_id", (Object)RequestContext.get().getOrgId());
        data.set("filehash", (Object)hash);
        data.set("uploadstatus", (Object)"I");
        data.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        String fileType = FilenameUtils.getExtension((String)fileName);
        String url = this.uploadAttachmentFile(fileName, fileType, fileData);
        this.saveAttachmentInfo(this.getKMEntityNumber(), fileName, id, url, fileData.length);
        String input_content = this.parseFileContent(fileType, new ByteArrayInputStream(fileData), url, this.getKMEntityNumber(), false);
        data.set("inputcontent_tag", (Object)input_content);
        data.set("attachsize", (Object)fileData.length);
        if (saveData != null) {
            saveData.accept((Object)data);
        }
        if ((operationResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getKMEntityNumber(), (DynamicObject[])new DynamicObject[]{data}, (OperateOption)OperateOption.create())).isSuccess() && (operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)this.getKMEntityNumber(), (Object[])new Object[]{data.getLong("id")}, (OperateOption)OperateOption.create())).isSuccess() && (operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.getKMEntityNumber(), (Object[])new Object[]{data.getLong("id")}, (OperateOption)OperateOption.create())).isSuccess()) {
            return id;
        }
        StringBuilder errMsg = new StringBuilder(16);
        for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
            errMsg.append(operateInfo.getMessage()).append('\n');
        }
        throw new KDBizException(new ErrorCode("103", errMsg.toString()), new Object[0]);
    }

    private void saveAttachmentInfo(String entityNumber, String fileName, Long knlPkId, String filePath, long size) {
        HashMap<String, Object> attachmentMap = new HashMap<String, Object>();
        attachmentMap.put("name", fileName);
        attachmentMap.put("entityNum", entityNumber);
        attachmentMap.put("billPkId", knlPkId);
        attachmentMap.put("size", size);
        attachmentMap.put("status", "success");
        attachmentMap.put("lastModified", new Date().getTime());
        attachmentMap.put("url", filePath);
        AttachmentServiceHelper.upload((String)entityNumber, (Object)knlPkId, (String)"attachmentpanelap", Collections.singletonList(attachmentMap));
    }

    private String uploadAttachmentFile(String fileName, String fileType, byte[] data) {
        if (!forbiddenExtensions.contains(fileType)) {
            String uploadPath = KMManager.getKnlFileUploadPath(fileName);
            FileItem fileItem = new FileItem(fileName, uploadPath, (InputStream)new ByteArrayInputStream(data));
            if (StringUtils.isBlank((CharSequence)(uploadPath = fileService.upload(fileItem)))) {
                String message = fileName + "\uff1a" + ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u670d\u52a1\u540e\u91cd\u8bd5\u3002", (String)"ImportKnowledgeTask_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                logger.error(message);
                return "";
            }
            return uploadPath;
        }
        return "";
    }

    private static String getKnlFileUploadPath(String fileName) {
        String tenantId;
        RequestContext requestContext = RequestContext.get();
        if (null == requestContext) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u83b7\u53d6\u4e0a\u4e0b\u6587\u5931\u8d25\u3002", (String)"ImportKnowledgeTask_15", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        if (StringUtils.isBlank((CharSequence)(tenantId = requestContext.getTenantId()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u79df\u6237ID\u3002", (String)"ImportKnowledgeTask_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String accountId = requestContext.getAccountId();
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4e2d\u5fc3ID\u3002", (String)"ImportKnowledgeTask_17", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String formatDate = sdf.format(new Date());
        return rootPath + String.format("/%s/%s/%s/%s", tenantId, accountId, formatDate, fileName);
    }

    public String parseFileContent(String fileType, InputStream in, String url, String entityNumber, boolean isQAKnl) {
        String content;
        if (StringUtils.isBlank((CharSequence)fileType)) {
            return "";
        }
        DocParser parser = FileParseFactory.getParser((String)fileType, (String)(StringUtils.isBlank((CharSequence)entityNumber) ? "" : entityNumber));
        parser.setSplitType(KnowledgeUtils.getSplitTypeByExtention((String)fileType, (boolean)isQAKnl));
        try {
            content = parser.parse(in, url, this.parseListener == null ? new ParseListener(){

                public boolean getStop() {
                    return false;
                }

                public void updateProgress(String progress) {
                }
            } : this.parseListener);
        }
        catch (IOException e) {
            throw new KDBizException(e.toString());
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u77e5\u8bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportKnowledgeTask_18", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        }
        String warnMsg = parser.getWarnMsg();
        if (StringUtils.isNotBlank((CharSequence)warnMsg)) {
            throw new KDBizException(warnMsg);
        }
        return content;
    }

    public ParseListener getParseListener() {
        return this.parseListener;
    }

    public void setParseListener(ParseListener parseListener) {
        this.parseListener = parseListener;
    }

    static {
        logger = LogFactory.getLog(AIKMAPIService.class);
        fileService = FileServiceFactory.getAttachmentFileService();
        forbiddenExtensions = fileService.getForbiddenExtensions();
        forbiddenExtensions.add("java");
        forbiddenExtensions.add("ts");
    }
}

