/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.operate.bizrule.OpBizRule;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.image.pojo.ImageInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.image.ImageServiceNewHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class HeterogeneImageOpAction
extends AbstractOpBizRuleAction {
    private static final Log log = LogFactory.getLog(HeterogeneImageOpAction.class);
    public static final String SYN = "1";
    public static final String ASYN = "2";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        for (String value : params.values()) {
            if (!StringUtils.isNotEmpty((String)value)) continue;
            fieldKeys.add(value);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] billDatas = e.getDataEntities();
        int billDatasLength = billDatas.length;
        if (billDatasLength <= 0) {
            log.info("\u5f02\u6784\u5355\u636e\u5f71\u50cf\u96c6\u6210\u670d\u52a1dataEntities\u7684size\u4e3a0");
            return;
        }
        DynamicObject billData = billDatas[0];
        OpBizRule bizRule = this.getBizRule();
        Map params = (Map)SerializationUtils.fromJsonString((String)bizRule.getParameter(), Map.class);
        String imagenumberKey = (String)params.get("imagenumber");
        String imageStatusKey = (String)params.get("imagestatus");
        boolean isFillImageNo = StringUtils.isNotEmpty((String)imagenumberKey) && billData.containsProperty(imagenumberKey);
        boolean isFillImageStatus = StringUtils.isNotEmpty((String)imageStatusKey) && billData.containsProperty(imageStatusKey);
        log.info("\u5f02\u6784\u5355\u636e\u5f71\u50cf\u96c6\u6210\u670d\u52a1\u914d\u7f6e \uff1a" + bizRule.getParameter());
        String heterogeneidField = (String)params.get("heterogeneid");
        if (!billData.containsProperty(heterogeneidField)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u201c\u5f02\u6784\u5355\u636e\u5f71\u50cf\u670d\u52a1\u96c6\u6210\u201d\u670d\u52a1\u914d\u7f6e\u5f02\u6784\u5355\u636eID\u5b57\u6bb5\u662f\u5426\u914d\u7f6e\u6b63\u786e", (String)"HeterogeneImageOpAction_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
        }
        String billType = billDatas[0].getDataEntityType().getName();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(billDatasLength);
        HashMap<String, DynamicObject> mapToUpdate = new HashMap<String, DynamicObject>();
        for (DynamicObject data : billDatas) {
            map.put(data.getPkValue().toString(), data);
        }
        List imageInfoList = ImageInfo.buildImageInfoListByBillDatas((DynamicObject[])billDatas, (Map)params, (String)billType);
        for (ImageInfo imageInfo : imageInfoList) {
            ImageInfo imageInfo2Update = ImageServiceNewHelper.createHetecrogeneImageInfo((ImageInfo)imageInfo);
            DynamicObject billDynamicObject = (DynamicObject)map.get(imageInfo.getBillId());
            if (isFillImageNo && billDynamicObject != null && StringUtils.isNotEmpty((String)imageInfo2Update.getImageNo())) {
                billDynamicObject.set(imagenumberKey, (Object)imageInfo2Update.getImageNo());
                mapToUpdate.put(imageInfo.getBillId(), billDynamicObject);
            }
            if (!isFillImageStatus || billDynamicObject == null || !StringUtils.isNotEmpty((String)imageInfo2Update.getImageState())) continue;
            billDynamicObject.set(imageStatusKey, (Object)imageInfo2Update.getImageState());
            mapToUpdate.putIfAbsent(imageInfo.getBillId(), billDynamicObject);
        }
        Collection values = mapToUpdate.values();
        if (values.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])values.toArray(new DynamicObject[0]));
        }
    }
}

