/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.operate.formop;

import kd.bos.cache.BosImageDistributeSessionCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.DefaultDynamicFormOperate;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.util.StringUtils;

public class ImageReviewDs
extends DefaultDynamicFormOperate {
    private static final Log log = LogFactory.getLog(ImageReviewDs.class);
    private final String cacheUrlKey = "ImageReviewDsUrl";
    private final String cachePageKey = "ImageReviewDsPageId";
    private final String formKey = "bos_viewinvoiceds";

    protected OperationResult invokeOperation() {
        OperationResult operationResult = super.invokeOperation();
        IFormView view = this.getView();
        String userID = String.valueOf(RequestContext.get().getUserId());
        String userName = String.valueOf(RequestContext.get().getUserName());
        IDataModel model = this.getView().getModel();
        Object billId = 0L;
        String billType = null;
        if (view instanceof BillView) {
            BillModel billModel = (BillModel)model;
            billId = billModel.getPKValue();
            billType = view.getEntityId();
        } else if (view instanceof ListView) {
            ListSelectedRow row = this.getListFocusRow();
            billId = row.getPrimaryKeyValue();
            billType = ((ListView)view).getEntityTypeId();
        }
        ImageSysInfo enableImageSysInfo = null;
        try {
            enableImageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (enableImageSysInfo == null) {
            String message = ResManager.loadKDString((String)"\u65e0\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ImageReview_0", (String)"bos-image-formplugin", (Object[])new Object[0]);
            view.showTipNotification(message);
            operationResult.setMessage(message);
            operationResult.setSuccess(false);
            return operationResult;
        }
        String imageSys = enableImageSysInfo.getNumber();
        log.info("\u83b7\u53d6\u5230\u7684billId:" + billId + ",imagesys:" + imageSys);
        ViewImageVo viewImageVo = new ViewImageVo();
        viewImageVo.setBillId(billId.toString());
        viewImageVo.setUserId(userID);
        viewImageVo.setUserName(userName);
        viewImageVo.setMobile(false);
        viewImageVo.setBilltype(billType);
        viewImageVo.setImageSys(imageSys);
        viewImageVo = ImageServiceHelper.viewPhoto((ViewImageVo)viewImageVo);
        if (viewImageVo.getUrl() == null) {
            view.showTipNotification(viewImageVo.getMessage());
            operationResult.setMessage(viewImageVo.getMessage());
            operationResult.setSuccess(false);
            return operationResult;
        }
        String url = viewImageVo.getUrl();
        log.info("ImageReviewDs\u4ece\u53d1\u7968\u4e91\u83b7\u53d6\u7684\u5f71\u50cfurl :" + url);
        this.autoOpenImage(view, userID, url);
        return operationResult;
    }

    private void autoOpenImage(IFormView view, String userId, String url) {
        String cachedUserUrlKey = "ImageReviewDsUrl" + userId;
        String cachedUserPageIdKey = "ImageReviewDsPageId" + userId;
        log.info("imageReviewDs\u81ea\u52a8\u6253\u5f00\u5f71\u50cf\u7f13\u5b58\u7528\u6237\u9700\u6253\u5f00\u7684\u5f71\u50cf\u5730\u5740\u7684key\uff1a" + cachedUserUrlKey);
        BosImageDistributeSessionCache.put(cachedUserUrlKey, url);
        if (StringUtils.isEmpty((String)BosImageDistributeSessionCache.get(cachedUserPageIdKey))) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_viewinvoiceds");
            String pageId = formShowParameter.getPageId();
            log.info("pageId:" + pageId);
            formShowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
            view.showForm(formShowParameter);
            BosImageDistributeSessionCache.put(cachedUserPageIdKey, pageId, 3);
        }
    }
}

