/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.ext.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.image.ext.ImageReviewOpService;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.image.pojo.ViewImageVo;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.image.ImageServiceNewHelper;

public class ImageReviewOpServiceImpl
implements ImageReviewOpService {
    private static final Log log = LogFactory.getLog(ImageReviewOpServiceImpl.class);
    private Set<String> mobileView = new HashSet<String>(Arrays.asList("HISENSE", "IMC", "FPY"));

    @Override
    public void doImageReview(IFormView view, OperationResult operationResult) {
        String userID = RequestContext.get().getUserId();
        String userName = String.valueOf(RequestContext.get().getUserName());
        IDataModel model = view.getModel();
        boolean isMobile = false;
        String billType = null;
        Object billId = null;
        if (view instanceof BillView) {
            BillModel billModel = (BillModel)model;
            billId = billModel.getPKValue();
            billType = view.getEntityId();
        } else if (view instanceof ListView) {
            ListView listView = (ListView)view;
            billId = listView.getFocusRowPkId();
            billType = listView.getEntityTypeId();
        }
        if (view instanceof MobileBillView) {
            isMobile = true;
        }
        log.info("\u67e5\u770b\u5f71\u50cf\uff1a\u5355\u636e\u7c7b\u578b = " + billType + "\uff0c\u5355\u636eId = " + billId + "\uff0c\u662f\u5426\u4e3a\u79fb\u52a8\u7aef\uff1a" + isMobile);
        if (billId == null || StringUtils.isEmpty((CharSequence)billType)) {
            String message = ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5355\u636e\u4fe1\u606f\uff0c\u65e0\u6cd5\u67e5\u770b\u5f71\u50cf\u3002", (String)"ImageReview_2", (String)"bos-image-formplugin", (Object[])new Object[0]);
            view.showTipNotification(message);
            operationResult.setMessage(message);
            operationResult.setSuccess(false);
            return;
        }
        ImageSysInfo enableImageSysInfo = null;
        try {
            enableImageSysInfo = SSCImageUtils.getEnableImageSysInfo();
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u5f71\u50cf\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (enableImageSysInfo == null) {
            String message = ResManager.loadKDString((String)"\u65e0\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ImageReview_0", (String)"bos-image-formplugin", (Object[])new Object[0]);
            view.showTipNotification(message);
            operationResult.setMessage(message);
            operationResult.setSuccess(false);
            return;
        }
        String imageSys = enableImageSysInfo.getNumber();
        log.info("\u5f53\u524d\u542f\u7528\u7684\u5f71\u50cf\u7cfb\u7edf\u4e3a\uff1a" + imageSys);
        if (isMobile && !this.supportMobile(imageSys, enableImageSysInfo)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5f71\u50cf\u7cfb\u7edf\u4e0d\u652f\u6301\u79fb\u52a8\u7aef\u67e5\u770b\u5f71\u50cf\uff0c\u8bf7\u5728PC\u7aef\u67e5\u770b\u5f71\u50cf\u3002", (String)"ImageReview_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            operationResult.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5f71\u50cf\u7cfb\u7edf\u4e0d\u652f\u6301\u79fb\u52a8\u7aef\u67e5\u770b\u5f71\u50cf\uff0c\u8bf7\u5728PC\u7aef\u67e5\u770b\u5f71\u50cf\u3002", (String)"ImageReview_1", (String)"bos-image-formplugin", (Object[])new Object[0]));
            operationResult.setSuccess(false);
            return;
        }
        ViewImageVo viewImageVo = new ViewImageVo();
        viewImageVo.setBillId(billId.toString());
        viewImageVo.setUserId(userID);
        viewImageVo.setUserName(userName);
        viewImageVo.setMobile(isMobile);
        viewImageVo.setBilltype(billType);
        viewImageVo.setImageSys(imageSys);
        viewImageVo = ImageServiceNewHelper.viewPhoto((ViewImageVo)viewImageVo);
        if (viewImageVo.getUrl() == null) {
            view.showTipNotification(viewImageVo.getMessage());
            operationResult.setMessage(viewImageVo.getMessage());
            operationResult.setSuccess(false);
            return;
        }
        String url = viewImageVo.getUrl();
        String message = viewImageVo.getMessage();
        if (kd.bos.util.StringUtils.isNotEmpty((String)message)) {
            view.showMessage(message);
        }
        if (isMobile) {
            MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
            String formId = "bos_viewinvoicemobile";
            if ("IMC".equals(imageSys)) {
                view.openUrl(url);
            } else {
                formShowParameter.setFormId(formId);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                formShowParameter.setCustomParam("url", (Object)url);
                view.showForm((FormShowParameter)formShowParameter);
            }
        } else {
            view.openUrl(url);
        }
    }

    private boolean supportMobile(String number, ImageSysInfo enableImageSysInfo) {
        return enableImageSysInfo.getSupportMobile() != false || this.mobileView.contains(number);
    }
}

