/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.pojo.ImageErrorInfo;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.common.ImageOperaionEnum;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;

public class ImageErrorInfoListPlugin
extends AbstractListPlugin
implements ClickListener {
    private static final String TABLE_BAS_IMAGEERROR = "bas_imageerrorinfo";
    private static final String APP_ID = "18XSXYEL8//U";
    private static final String FIELDS = "id, imagenumber, creator.name, createtime, operation, retrycount, retryresult, imageid";
    private static final int BATCH_COUNT = 5;
    private static final String PROGRESS_FORMID = "bos_imagedel_progress_new";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("delretry".equals(operateKey)) {
            this.delretry();
        }
    }

    private void delretry() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u9879", (String)"ImageErrorInfoListPlugin_4", (String)"bos-image-formplugin", (Object[])new Object[0]));
        } else {
            ImageSysInfo enableImageSysInfo = SSCImageUtils.getEnableImageSysInfo();
            this.getPageCache().put("imageSysNumber", enableImageSysInfo.getNumber());
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("imageerror_confirm", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u6267\u884c\u5220\u9664\u91cd\u8bd5", (String)"ImageErrorInfoListPlugin_1", (String)"bos-image-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, callBackListener);
        }
    }

    private DynamicObjectCollection getRetryData(ListSelectedRowCollection selectedRows) {
        Object[] pkValues = selectedRows.getPrimaryKeyValues();
        return QueryServiceHelper.query((String)(((Object)((Object)this)).getClass().getName() + ".query"), (String)TABLE_BAS_IMAGEERROR, (String)FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkValues)}, null);
    }

    private List<ImageErrorInfo> toImageErrorInfo(DynamicObjectCollection dynamicObjects) {
        LinkedList<ImageErrorInfo> infoList = new LinkedList<ImageErrorInfo>();
        for (DynamicObject e : dynamicObjects) {
            ImageErrorInfo info = new ImageErrorInfo();
            info.setId(e.getLong("id"));
            info.setImageNumber(e.getString("imagenumber"));
            info.setCreator(e.getString("creator.name"));
            info.setCreatetime(e.getDate("createtime"));
            info.setOperation(e.getString("operation"));
            info.setRetrycount(e.getInt("retrycount"));
            info.setRetryresult(e.getString("retryresult"));
            info.setImageId(e.getString("imageid"));
            infoList.add(info);
        }
        return infoList;
    }

    private void saveOperationLog(List<ImageErrorInfo> imageErrorInfoList) {
        LinkedList<OpLogAppInfo> appLogInfos = new LinkedList<OpLogAppInfo>();
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664\u91cd\u8bd5", "ImageErrorInfoListPlugin_2", "bos-image-formplugin");
        MultiLangEnumBridge opDes = new MultiLangEnumBridge("\u5f71\u50cf\u7f16\u7801%s\uff0c\u5220\u9664\u91cd\u8bd5", "ImageErrorInfoListPlugin_3", "bos-image-formplugin");
        for (ImageErrorInfo info : imageErrorInfoList) {
            OpLogAppInfo opLogAppInfo = new OpLogAppInfo();
            opLogAppInfo.setBizAppID(APP_ID);
            opLogAppInfo.setBizObjID(TABLE_BAS_IMAGEERROR);
            opLogAppInfo.setOpName("deleteRetry", opName);
            opLogAppInfo.setOpDesc(opDes, new String[]{info.getImageNumber()});
            appLogInfos.add(opLogAppInfo);
        }
        LogServiceHelper.addBatchLog(appLogInfos);
    }

    private boolean operationAllDel(DynamicObjectCollection dynamicObjects) {
        for (DynamicObject e : dynamicObjects) {
            if (ImageOperaionEnum.DELETE.getValue().equals(e.getString("operation"))) continue;
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        if ("imageerror_confirm".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == (result = messageBoxClosedEvent.getResult())) {
            ListView listView = (ListView)messageBoxClosedEvent.getSource();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            DynamicObjectCollection retryData = this.getRetryData(selectedRows);
            if (!this.operationAllDel(retryData)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u64cd\u4f5c\u5fc5\u987b\u90fd\u662f\u5220\u9664", (String)"ImageErrorInfoListPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
            } else {
                List<ImageErrorInfo> imageErrorInfoList = this.toImageErrorInfo(retryData);
                this.saveOperationLog(imageErrorInfoList);
                String infoStr = JSONObject.toJSONString(imageErrorInfoList);
                List imageNumbers = imageErrorInfoList.stream().map(ImageErrorInfo::getImageNumber).collect(Collectors.toList());
                DynamicObjectCollection imageNumberCollection = QueryServiceHelper.query((String)"task_billimagemap", (String)"imagenumber", (QFilter[])new QFilter[]{new QFilter("imagenumber", "in", imageNumbers)});
                List imageNumberList = imageNumberCollection.stream().map(dynamicObject -> dynamicObject.getString("imagenumber")).collect(Collectors.toList());
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId(PROGRESS_FORMID);
                parameters.setCustomParam("batchcount", (Object)5);
                parameters.setCustomParam("errorInfos", (Object)infoStr);
                parameters.setCustomParam("existedImageNumber", (Object)JSONObject.toJSONString(imageNumberList));
                this.getView().showForm(parameters);
            }
        }
    }
}

