/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.image.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.image.pojo.ImageSysInfo;
import kd.bos.imageplatform.common.ImageSysEnum;
import kd.bos.imageplatform.util.SSCImageUtils;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceNewHelper;
import kd.bos.sysint.servicehelper.SysIntegrationServiceHelper;

public class ImageScanerIndexListPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener,
ProgresssListener {
    private static final Log log = LogFactory.getLog(ImageScanerIndexListPlugin.class);
    private static final String CLICK_KEY_GETSCANHOME = "getscanhome";
    private static final String CLICK_KEY_GETSCANHOMEAGAIN = "getscanhomeagain";
    private static final String FIELD_SSCUNIT = "sscunit";
    private static final String TABLE_BOS_SSCUNITLIST = "bos_sscunitlist";
    private static final String TABLE_TASK_BILLIMAGEMAP = "task_billimagemap";
    private static final int DKWS_API = 2;
    private static final int DKWS_WEBSERVICE = 1;

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{CLICK_KEY_GETSCANHOME});
        this.addClickListeners(new String[]{"scanhistory"});
        this.addClickListeners(new String[]{"sscunitbtn"});
        this.addClickListeners(new String[]{CLICK_KEY_GETSCANHOMEAGAIN});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_KEY_GETSCANHOMEAGAIN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        ((Label)this.getControl("scanhistorynum")).setText(this.getUserScanNum(currentUserId) + "");
        DynamicObjectCollection col = this.getDefaultScaner(currentUserId);
        if (null != col && col.size() > 0) {
            DynamicObject dynamicObject = (DynamicObject)col.get(0);
            long sscunitId = dynamicObject.getLong("id");
            String sscunitName = dynamicObject.getString("name");
            this.getModel().setValue(FIELD_SSCUNIT, (Object)sscunitId);
            ((Label)this.getControl("sscunitlab")).setText(sscunitName);
        }
    }

    private DynamicObjectCollection getDefaultScaner(Long currentUserId) {
        ORM orm = ORM.create();
        String selectField = "id,number,name";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("entryentity.displayname", "=", (Object)currentUserId));
        try (DataSet ds = orm.queryDataSet(((Object)((Object)this)).getClass().getName() + ".getBosOrgCompanyByNum", TABLE_BOS_SSCUNITLIST, selectField, filterList.toArray(new QFilter[0])).orderBy(new String[]{"number asc"});){
            DynamicObjectCollection collection;
            DynamicObjectCollection dynamicObjectCollection = collection = orm.toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    protected int getUserScanNum(Long userid) {
        ORM orm = ORM.create();
        String selectField = "id";
        int scanNum = 0;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        filterList.add(new QFilter("scanuserid", "=", (Object)String.valueOf(userid)));
        try (DataSet ds = orm.queryDataSet("kd.bd.assistant.plugin.basedata.ImageScanerIndexListPlugin.getUserScanNum", TABLE_TASK_BILLIMAGEMAP, selectField, filterList.toArray(new QFilter[0]));){
            DynamicObjectCollection d = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)TABLE_TASK_BILLIMAGEMAP);
            DynamicObject userObj = BusinessDataServiceHelper.loadSingle((Object)userid, (String)"bos_user", (String)"username");
            String userName = userObj.getString("username");
            QFilter[] filter = new QFilter[]{new QFilter("scanuserid", "=", (Object)userName)};
            DynamicObjectCollection d2 = QueryServiceHelper.query((String)TABLE_TASK_BILLIMAGEMAP, (String)selectField, (QFilter[])filter);
            scanNum = d2 == null ? d.size() : d.size() + d2.size();
        }
        return scanNum;
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CLICK_KEY_GETSCANHOME.equalsIgnoreCase(key) || CLICK_KEY_GETSCANHOMEAGAIN.equalsIgnoreCase(key)) {
            DynamicObject sscunit;
            ImageSysInfo currImageSys = SSCImageUtils.getEnableImageSysInfo();
            String currentImageSysNumber = currImageSys.getNumber();
            log.info("\u5f53\u524d\u5f71\u50cf\u7cfb\u7edf\u4e3a:" + currentImageSysNumber);
            if (ImageSysEnum.FPY.getValue().equals(currentImageSysNumber) || "NGXHC".equals(currentImageSysNumber) || ImageSysEnum.FPY_IMC.getValue().equals(currentImageSysNumber)) {
                try {
                    String scanHomeUrl = ImageServiceNewHelper.getScanHomeUrl(null, null, (boolean)false, (boolean)false, (boolean)false, null);
                    this.getView().openUrl(scanHomeUrl);
                    return;
                }
                catch (Exception e) {
                    this.getView().showMessage(e.getMessage());
                    return;
                }
            }
            String scanUserId = String.valueOf(RequestContext.get().getCurrUserId());
            String scanLocation = null;
            if (ImageSysEnum.DKWS_LINUX.getValue().equals(currentImageSysNumber)) {
                sscunit = (DynamicObject)this.getModel().getValue(FIELD_SSCUNIT);
                if (sscunit == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u626b\u63cf\u70b9", (String)"ImageScanerIndexListPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
                    return;
                }
                scanLocation = sscunit.getString("name");
            } else if (ImageSysEnum.DKWS.getValue().equals(currentImageSysNumber)) {
                sscunit = (DynamicObject)this.getModel().getValue(FIELD_SSCUNIT);
                if (sscunit == null) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u626b\u63cf\u70b9", (String)"ImageScanerIndexListPlugin_0", (String)"bos-image-formplugin", (Object[])new Object[0]));
                    return;
                }
                scanLocation = sscunit.getString("number");
                String externalErpNumber = currImageSys.getExternalerpNumber();
                if ("EAS".equals(externalErpNumber)) {
                    String EASuserName;
                    String EASuserID;
                    try {
                        Map internalData = SysIntegrationServiceHelper.getExternalData((Long)1L, (String)"bos_person", (String)scanUserId, null, null);
                        EASuserID = (String)internalData.get("id");
                        EASuserName = (String)internalData.get("name");
                    }
                    catch (Exception e) {
                        log.error("\u7528\u6237\uff1a" + RequestContext.get().getUserName() + "\u548cEAS\u7528\u6237\u65e0\u6cd5\u5339\u914d " + e.getMessage());
                        this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7528\u6237\uff1a%1$s\u548cEAS\u7528\u6237\u65e0\u6cd5\u5339\u914d", (String)"ImageScanerIndexListPlugin_1", (String)"bos-image-formplugin", (Object[])new Object[0]), RequestContext.get().getUserName()));
                        return;
                    }
                    scanUserId = EASuserID + "((()))" + EASuserName;
                } else if ("KDCC".equals(externalErpNumber)) {
                    scanUserId = scanUserId + "((()))" + RequestContext.get().getUserName();
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1\u7cfb\u7edf\uff0c\u8bf7\u9009\u62e9EAS\u6216\u8005\u91d1\u8776\u4e91\u82cd\u7a79", (String)"ImageScanerIndexListPlugin_3", (String)"bos-image-formplugin", (Object[])new Object[0]));
                }
            }
            try {
                String home = ImageServiceNewHelper.getScanHomeUrl((String)scanUserId, (String)scanLocation, (boolean)true, (boolean)true, (boolean)true, (String)"2");
                if (StringUtils.isEmpty((CharSequence)home)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5f71\u50cf\u7cfb\u7edf\u4e0d\u652f\u6301\u8df3\u8f6c\u626b\u63cf\u9996\u9875\u3002", (String)"ImageScanerIndexListPlugin_5", (String)"bos-image-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().openUrl(home);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5f71\u50cf\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5f71\u50cf\u51fa\u9519\uff1a%1$s", (String)"ImageScanerIndexListPlugin_4", (String)"bos-image-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (CLICK_KEY_GETSCANHOME.equalsIgnoreCase(key)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{CLICK_KEY_GETSCANHOME});
                this.getView().setVisible(Boolean.TRUE, new String[]{CLICK_KEY_GETSCANHOMEAGAIN});
            }
        } else if ("scanhistory".equalsIgnoreCase(key)) {
            this.openOtherPageById(TABLE_TASK_BILLIMAGEMAP);
        } else if ("sscunitbtn".equals(key)) {
            this.openSscunitF7();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        if ("advconap_add".equals(e.getActionId())) {
            if (null == e.getReturnData()) {
                return;
            }
            Object[] pk = this.getSelectedEntryPK(e);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)TABLE_BOS_SSCUNITLIST);
            Map mapObjects = BusinessDataReader.loadFromCache((Object[])pk, (DynamicObjectType)type, (boolean)false);
            for (Map.Entry entry : mapObjects.entrySet()) {
                Long sscunitId = ((DynamicObject)entry.getValue()).getLong("id");
                String sscunitName = ((DynamicObject)entry.getValue()).getString("name");
                model.setValue(FIELD_SSCUNIT, (Object)sscunitId);
                ((Label)this.getControl("sscunitlab")).setText(sscunitName);
            }
        }
    }

    private Object[] getSelectedEntryPK(ClosedCallBackEvent e) {
        ListSelectedRowCollection rowDataCol = (ListSelectedRowCollection)e.getReturnData();
        Object[] pk = new Object[rowDataCol.size()];
        for (int i = 0; i < rowDataCol.size(); ++i) {
            ListSelectedRow selectrow = rowDataCol.get(i);
            if (StringUtils.isBlank((Object)selectrow.getPrimaryKeyValue())) continue;
            pk[i] = selectrow.getPrimaryKeyValue();
        }
        return pk;
    }

    private void openSscunitF7() {
        ListShowParameter para = new ListShowParameter();
        para.setLookUp(true);
        para.setBillFormId(TABLE_BOS_SSCUNITLIST);
        para.setFormId("bos_sscunitlist_f7");
        StyleCss css = new StyleCss();
        css.setWidth("960");
        css.setHeight("580");
        para.getOpenStyle().setInlineStyleCss(css);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setMultiSelect(false);
        para.setShowTitle(false);
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "advconap_add"));
        para.setHasRight(true);
        RequestContext requestContext = RequestContext.get();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        QFilter qfilter = new QFilter("entryentity.displayname", "=", (Object)Long.valueOf(requestContext.getUserId()));
        listFilterParameter.setQFilter(qfilter.toSerializedString());
        para.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)para);
    }

    private void openOtherPageById(String pageId) {
        IFormView view = this.getView();
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(pageId);
        showParameter.setFormId("bos_list");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        FormShowParameter parent = this.getView().getFormShowParameter();
        showParameter.setParentPageId(parent.getParentPageId());
        view.showForm((FormShowParameter)showParameter);
    }

    public void onProgress(ProgressEvent arg0) {
        int value = 12;
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        ((Label)this.getControl("scanhistorynum")).setText(this.getUserScanNum(currentUserId) + "");
        arg0.setProgress(value);
    }
}

